/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.util.AssertUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum AttestationConveyancePreference {
    NONE("none"),
    INDIRECT("indirect"),
    DIRECT("direct"),
    ENTERPRISE("enterprise");

    private final String value;

    private AttestationConveyancePreference(String value) {
        this.value = value;
    }

    public static @NonNull AttestationConveyancePreference create(@NonNull String value) {
        AssertUtil.notNull((Object)value, (String)"value must not be null.");
        switch (value) {
            case "none": {
                return NONE;
            }
            case "indirect": {
                return INDIRECT;
            }
            case "direct": {
                return DIRECT;
            }
            case "enterprise": {
                return ENTERPRISE;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static @NonNull AttestationConveyancePreference deserialize(@NonNull String value) throws InvalidFormatException {
        try {
            return AttestationConveyancePreference.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, AttestationConveyancePreference.class);
        }
    }

    @JsonValue
    public @NonNull String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

