/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@JsonIgnoreProperties(value={"format"})
@JsonTypeName(value="apple")
public class AppleAnonymousAttestationStatement
implements CertificateBaseAttestationStatement {
    public static final String FORMAT = "apple";
    @JsonProperty
    private final AttestationCertificatePath x5c;

    public AppleAnonymousAttestationStatement(@JsonProperty(value="x5c") @NonNull AttestationCertificatePath x5c) {
        AssertUtil.notNull((Object)x5c, (String)"x5c must not be null");
        this.x5c = x5c;
    }

    @Override
    public @NonNull AttestationCertificatePath getX5c() {
        return this.x5c;
    }

    @Override
    @JsonIgnore
    public @NonNull String getFormat() {
        return FORMAT;
    }

    @Override
    public void validate() {
        if (this.x5c.isEmpty()) {
            throw new ConstraintViolationException("No attestation certificate is found in apple anonymous attestation statement.");
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppleAnonymousAttestationStatement that = (AppleAnonymousAttestationStatement)o;
        return Objects.equals(this.x5c, that.x5c);
    }

    public int hashCode() {
        return Objects.hash(this.x5c);
    }
}

