/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum UserVerificationMethod {
    PRESENCE_INTERNAL(1L),
    FINGERPRINT_INTERNAL(2L),
    PASSCODE_INTERNAL(4L),
    VOICEPRINT_INTERNAL(8L),
    FACEPRINT_INTERNAL(16L),
    LOCATION_INTERNAL(32L),
    EYEPRINT_INTERNAL(64L),
    PATTERN_INTERNAL(128L),
    HANDPRINT_INTERNAL(256L),
    PASSCODE_EXTERNAL(2048L),
    PATTERN_EXTERNAL(4096L),
    NONE(512L),
    ALL(1024L);

    private final long value;

    private UserVerificationMethod(long value) {
        this.value = value;
    }

    public static UserVerificationMethod create(long value) {
        if (value == 1L) {
            return PRESENCE_INTERNAL;
        }
        if (value == 2L) {
            return FINGERPRINT_INTERNAL;
        }
        if (value == 4L) {
            return PASSCODE_INTERNAL;
        }
        if (value == 8L) {
            return VOICEPRINT_INTERNAL;
        }
        if (value == 16L) {
            return FACEPRINT_INTERNAL;
        }
        if (value == 32L) {
            return LOCATION_INTERNAL;
        }
        if (value == 64L) {
            return EYEPRINT_INTERNAL;
        }
        if (value == 128L) {
            return PATTERN_INTERNAL;
        }
        if (value == 256L) {
            return HANDPRINT_INTERNAL;
        }
        if (value == 2048L) {
            return PASSCODE_EXTERNAL;
        }
        if (value == 4096L) {
            return PATTERN_EXTERNAL;
        }
        if (value == 512L) {
            return NONE;
        }
        if (value == 1024L) {
            return ALL;
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static @NonNull UserVerificationMethod deserialize(long value) throws InvalidFormatException {
        try {
            return UserVerificationMethod.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, UserVerificationMethod.class);
        }
    }

    @JsonValue
    public long getValue() {
        return this.value;
    }
}

