/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.webauthn4j.converter.jackson.deserializer.COSEKeyEnvelope;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class COSEKeyEnvelopeDeserializer
extends StdDeserializer<COSEKeyEnvelope> {
    public COSEKeyEnvelopeDeserializer() {
        super(COSEKeyEnvelope.class);
    }

    public @NonNull COSEKeyEnvelope deserialize(@NonNull JsonParser p, @NonNull DeserializationContext ctxt) throws IOException {
        @Nullable COSEKey coseKey = (COSEKey)ctxt.readValue(p, COSEKey.class);
        int length = (int)p.getCurrentLocation().getByteOffset();
        return new COSEKeyEnvelope(coseKey, length);
    }
}

