/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CoreRegistrationParameters
implements Serializable {
    private final CoreServerProperty serverProperty;
    private final boolean userVerificationRequired;
    private final boolean userPresenceRequired;

    public CoreRegistrationParameters(@NonNull CoreServerProperty serverProperty, boolean userVerificationRequired, boolean userPresenceRequired) {
        AssertUtil.notNull((Object)serverProperty, (String)"serverProperty must not be null");
        this.serverProperty = serverProperty;
        this.userVerificationRequired = userVerificationRequired;
        this.userPresenceRequired = userPresenceRequired;
    }

    public CoreRegistrationParameters(@NonNull CoreServerProperty serverProperty, boolean userVerificationRequired) {
        this(serverProperty, userVerificationRequired, true);
    }

    public @NonNull CoreServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public boolean isUserVerificationRequired() {
        return this.userVerificationRequired;
    }

    public boolean isUserPresenceRequired() {
        return this.userPresenceRequired;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreRegistrationParameters that = (CoreRegistrationParameters)o;
        return this.userVerificationRequired == that.userVerificationRequired && this.userPresenceRequired == that.userPresenceRequired && Objects.equals(this.serverProperty, that.serverProperty);
    }

    public int hashCode() {
        return Objects.hash(this.serverProperty, this.userVerificationRequired, this.userPresenceRequired);
    }
}

