/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum PublicKeyCredentialType implements Serializable
{
    PUBLIC_KEY("public-key");

    private final String value;

    private PublicKeyCredentialType(String value) {
        this.value = value;
    }

    public static @NonNull PublicKeyCredentialType create(@NonNull String value) {
        AssertUtil.notNull((Object)value, (String)"value must not be null.");
        if ("public-key".equals(value)) {
            return PUBLIC_KEY;
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static @NonNull PublicKeyCredentialType deserialize(@NonNull String value) throws InvalidFormatException {
        try {
            return PublicKeyCredentialType.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, PublicKeyCredentialType.class);
        }
    }

    @JsonValue
    public @NonNull String getValue() {
        return this.value;
    }
}

