/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.client.challenge.DefaultChallenge;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ChallengeDeserializer
extends StdDeserializer<Challenge> {
    public ChallengeDeserializer() {
        super(Challenge.class);
    }

    public @NonNull Challenge deserialize(@NonNull JsonParser p, @NonNull DeserializationContext ctxt) throws IOException {
        String str = p.getValueAsString();
        try {
            return new DefaultChallenge(str);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)str, DefaultChallenge.class);
        }
    }
}

