/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.CollectionUtil;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.validator.CoreRegistrationObject;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

public class RegistrationObject
extends CoreRegistrationObject {
    private final CollectedClientData collectedClientData;
    private final byte[] collectedClientDataBytes;
    private final AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions;
    private final Set<AuthenticatorTransport> transports;

    public RegistrationObject(AttestationObject attestationObject, byte[] attestationObjectBytes, CollectedClientData collectedClientData, byte[] collectedClientDataBytes, AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions, Set<AuthenticatorTransport> transports, ServerProperty serverProperty, Instant timestamp) {
        super(attestationObject, attestationObjectBytes, MessageDigestUtil.createSHA256().digest(collectedClientDataBytes), serverProperty, timestamp);
        this.collectedClientData = collectedClientData;
        this.collectedClientDataBytes = ArrayUtil.clone((byte[])collectedClientDataBytes);
        this.clientExtensions = clientExtensions;
        this.transports = CollectionUtil.unmodifiableSet(transports);
    }

    public RegistrationObject(AttestationObject attestationObject, byte[] attestationObjectBytes, CollectedClientData collectedClientData, byte[] collectedClientDataBytes, AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions, Set<AuthenticatorTransport> transports, ServerProperty serverProperty) {
        this(attestationObject, attestationObjectBytes, collectedClientData, collectedClientDataBytes, clientExtensions, transports, serverProperty, Instant.now());
    }

    public CollectedClientData getCollectedClientData() {
        return this.collectedClientData;
    }

    public byte[] getCollectedClientDataBytes() {
        return ArrayUtil.clone((byte[])this.collectedClientDataBytes);
    }

    public AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> getClientExtensions() {
        return this.clientExtensions;
    }

    public Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    @Override
    public ServerProperty getServerProperty() {
        return (ServerProperty)super.getServerProperty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegistrationObject that = (RegistrationObject)o;
        return Objects.equals(this.collectedClientData, that.collectedClientData) && Arrays.equals(this.collectedClientDataBytes, that.collectedClientDataBytes) && Objects.equals(this.clientExtensions, that.clientExtensions) && Objects.equals(this.transports, that.transports);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.collectedClientData, this.clientExtensions, this.transports);
        result = 31 * result + Arrays.hashCode(this.collectedClientDataBytes);
        return result;
    }
}

