/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.authenticator.CoreAuthenticator;
import com.webauthn4j.data.CoreAuthenticationData;
import com.webauthn4j.data.CoreAuthenticationParameters;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.AssertionSignatureValidator;
import com.webauthn4j.validator.AuthenticatorExtensionValidator;
import com.webauthn4j.validator.BeanAssertUtil;
import com.webauthn4j.validator.CoreAuthenticationObject;
import com.webauthn4j.validator.CoreMaliciousCounterValueHandler;
import com.webauthn4j.validator.CustomCoreAuthenticationValidator;
import com.webauthn4j.validator.DefaultCoreMaliciousCounterValueHandler;
import com.webauthn4j.validator.RpIdHashValidator;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import com.webauthn4j.validator.exception.UserNotPresentException;
import com.webauthn4j.validator.exception.UserNotVerifiedException;
import java.util.ArrayList;
import java.util.List;

public class CoreAuthenticationDataValidator {
    private final RpIdHashValidator rpIdHashValidator = new RpIdHashValidator();
    private final AuthenticatorExtensionValidator authenticatorExtensionValidator = new AuthenticatorExtensionValidator();
    private final List<CustomCoreAuthenticationValidator> customAuthenticationValidators;
    private AssertionSignatureValidator assertionSignatureValidator = new AssertionSignatureValidator();
    private CoreMaliciousCounterValueHandler coreMaliciousCounterValueHandler = new DefaultCoreMaliciousCounterValueHandler();

    public CoreAuthenticationDataValidator(List<CustomCoreAuthenticationValidator> customAuthenticationValidators) {
        this.customAuthenticationValidators = customAuthenticationValidators;
    }

    public CoreAuthenticationDataValidator() {
        this(new ArrayList<CustomCoreAuthenticationValidator>());
    }

    protected CoreAuthenticationDataValidator(List<CustomCoreAuthenticationValidator> customAuthenticationValidators, AssertionSignatureValidator assertionSignatureValidator) {
        this.customAuthenticationValidators = customAuthenticationValidators;
        this.assertionSignatureValidator = assertionSignatureValidator;
    }

    public void validate(CoreAuthenticationData authenticationData, CoreAuthenticationParameters authenticationParameters) {
        BeanAssertUtil.validate(authenticationData);
        BeanAssertUtil.validate(authenticationParameters);
        AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData = authenticationData.getAuthenticatorData();
        CoreServerProperty serverProperty = authenticationParameters.getServerProperty();
        BeanAssertUtil.validate(authenticatorData);
        BeanAssertUtil.validate(serverProperty);
        this.validateAuthenticatorData(authenticatorData);
        CoreAuthenticator authenticator = authenticationParameters.getAuthenticator();
        CoreAuthenticationObject authenticationObject = this.createCoreAuthenticationObject(authenticationData, authenticationParameters);
        this.rpIdHashValidator.validate(authenticatorData.getRpIdHash(), serverProperty);
        if (authenticationParameters.isUserPresenceRequired() && !authenticatorData.isFlagUP()) {
            throw new UserNotPresentException("Validator is configured to check user present, but UP flag in authenticatorData is not set.");
        }
        if (authenticationParameters.isUserVerificationRequired() && !authenticatorData.isFlagUV()) {
            throw new UserNotVerifiedException("Validator is configured to check user verified, but UV flag in authenticatorData is not set.");
        }
        AuthenticationExtensionsAuthenticatorOutputs<AuthenticationExtensionAuthenticatorOutput> authenticationExtensionsAuthenticatorOutputs = authenticatorData.getExtensions();
        this.authenticatorExtensionValidator.validate(authenticationExtensionsAuthenticatorOutputs);
        this.assertionSignatureValidator.validate(authenticationData, authenticator.getAttestedCredentialData().getCOSEKey());
        long presentedCounter = authenticatorData.getSignCount();
        long storedCounter = authenticator.getCounter();
        if (presentedCounter > 0L || storedCounter > 0L) {
            if (presentedCounter > storedCounter) {
                authenticator.setCounter(presentedCounter);
            } else {
                this.coreMaliciousCounterValueHandler.maliciousCounterValueDetected(authenticationObject);
            }
        }
        for (CustomCoreAuthenticationValidator customAuthenticationValidator : this.customAuthenticationValidators) {
            customAuthenticationValidator.validate(authenticationObject);
        }
    }

    protected CoreAuthenticationObject createCoreAuthenticationObject(CoreAuthenticationData authenticationData, CoreAuthenticationParameters authenticationParameters) {
        byte[] credentialId = authenticationData.getCredentialId();
        AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData = authenticationData.getAuthenticatorData();
        byte[] authenticatorDataBytes = authenticationData.getAuthenticatorDataBytes();
        byte[] clientDataHash = authenticationData.getClientDataHash();
        CoreServerProperty serverProperty = authenticationParameters.getServerProperty();
        CoreAuthenticator authenticator = authenticationParameters.getAuthenticator();
        return new CoreAuthenticationObject(credentialId, authenticatorData, authenticatorDataBytes, clientDataHash, serverProperty, authenticator);
    }

    void validateAuthenticatorData(AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData) {
        if (authenticatorData.getAttestedCredentialData() != null) {
            throw new ConstraintViolationException("attestedCredentialData must be null on authentication");
        }
    }

    public CoreMaliciousCounterValueHandler getMaliciousCounterValueHandler() {
        return this.coreMaliciousCounterValueHandler;
    }

    public void setMaliciousCounterValueHandler(CoreMaliciousCounterValueHandler coreMaliciousCounterValueHandler) {
        AssertUtil.notNull((Object)coreMaliciousCounterValueHandler, (String)"maliciousCounterValueHandler must not be null");
        this.coreMaliciousCounterValueHandler = coreMaliciousCounterValueHandler;
    }

    public List<CustomCoreAuthenticationValidator> getCustomAuthenticationValidators() {
        return this.customAuthenticationValidators;
    }
}

