/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;

public enum TPMIAlgPublic {
    TPM_ALG_ERROR(0),
    TPM_ALG_RSA(1),
    TPM_ALG_NULL(16),
    TPM_ALG_ECDSA(24);

    private final int value;

    private TPMIAlgPublic(int value) {
        this.value = value;
    }

    public static TPMIAlgPublic create(int value) {
        if (value == TPMIAlgPublic.TPM_ALG_ERROR.value) {
            return TPM_ALG_ERROR;
        }
        if (value == TPMIAlgPublic.TPM_ALG_RSA.value) {
            return TPM_ALG_RSA;
        }
        if (value == TPMIAlgPublic.TPM_ALG_NULL.value) {
            return TPM_ALG_NULL;
        }
        if (value == TPMIAlgPublic.TPM_ALG_ECDSA.value) {
            return TPM_ALG_ECDSA;
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static TPMIAlgPublic deserialize(int value) throws InvalidFormatException {
        try {
            return TPMIAlgPublic.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, TPMIAlgPublic.class);
        }
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }
}

