/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.authenticator.CoreAuthenticator;
import com.webauthn4j.server.CoreServerProperty;
import java.io.Serializable;
import java.util.Objects;

public class CoreAuthenticationParameters
implements Serializable {
    private final CoreServerProperty serverProperty;
    private final CoreAuthenticator authenticator;
    private final boolean userVerificationRequired;
    private final boolean userPresenceRequired;

    public CoreAuthenticationParameters(CoreServerProperty serverProperty, CoreAuthenticator authenticator, boolean userVerificationRequired, boolean userPresenceRequired) {
        this.serverProperty = serverProperty;
        this.authenticator = authenticator;
        this.userVerificationRequired = userVerificationRequired;
        this.userPresenceRequired = userPresenceRequired;
    }

    public CoreAuthenticationParameters(CoreServerProperty serverProperty, CoreAuthenticator authenticator, boolean userVerificationRequired) {
        this(serverProperty, authenticator, userVerificationRequired, true);
    }

    public CoreServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public CoreAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public boolean isUserVerificationRequired() {
        return this.userVerificationRequired;
    }

    public boolean isUserPresenceRequired() {
        return this.userPresenceRequired;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreAuthenticationParameters that = (CoreAuthenticationParameters)o;
        return this.userVerificationRequired == that.userVerificationRequired && this.userPresenceRequired == that.userPresenceRequired && Objects.equals(this.serverProperty, that.serverProperty) && Objects.equals(this.authenticator, that.authenticator);
    }

    public int hashCode() {
        return Objects.hash(this.serverProperty, this.authenticator, this.userVerificationRequired, this.userPresenceRequired);
    }
}

