/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator.attestation.statement.androidsafetynet;

import com.webauthn4j.data.attestation.statement.AndroidSafetyNetAttestationStatement;
import com.webauthn4j.data.attestation.statement.AttestationCertificate;
import com.webauthn4j.data.attestation.statement.AttestationType;
import com.webauthn4j.data.attestation.statement.Response;
import com.webauthn4j.util.Base64Util;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.validator.RegistrationObject;
import com.webauthn4j.validator.attestation.statement.AbstractStatementValidator;
import com.webauthn4j.validator.attestation.statement.androidsafetynet.GooglePlayServiceVersionValidator;
import com.webauthn4j.validator.exception.BadAttestationStatementException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Objects;

public class AndroidSafetyNetAttestationStatementValidator
extends AbstractStatementValidator<AndroidSafetyNetAttestationStatement> {
    private GooglePlayServiceVersionValidator versionValidator = new DefaultVersionValidator();
    private int forwardThreshold = 0;
    private int backwardThreshold = 60;

    @Override
    public AttestationType validate(RegistrationObject registrationObject) {
        if (!this.supports(registrationObject)) {
            throw new IllegalArgumentException("Specified format is not supported by " + this.getClass().getName());
        }
        AndroidSafetyNetAttestationStatement attestationStatement = (AndroidSafetyNetAttestationStatement)registrationObject.getAttestationObject().getAttestationStatement();
        if (attestationStatement.getX5c().isEmpty()) {
            throw new BadAttestationStatementException("No attestation certificate is found in android safetynet attestation statement.");
        }
        this.versionValidator.validate(attestationStatement.getVer());
        Response response = attestationStatement.getResponse().getPayload();
        String nonce = response.getNonce();
        byte[] authenticatorData = registrationObject.getAuthenticatorDataBytes();
        byte[] collectedClientData = registrationObject.getCollectedClientDataBytes();
        this.validateNonce(nonce, authenticatorData, collectedClientData);
        AttestationCertificate attestationCertificate = attestationStatement.getX5c().getEndEntityAttestationCertificate();
        if (!Objects.equals(attestationCertificate.getSubjectCommonName(), "attest.android.com")) {
            throw new BadAttestationStatementException("The attestation certificate is not issued to 'attest.android.com'.");
        }
        if (!response.isCtsProfileMatch()) {
            throw new BadAttestationStatementException("The profile of the device doesn't match the profile of a device that has passed Android Compatibility Test Suite.");
        }
        if (Instant.ofEpochMilli(response.getTimestampMs()).isBefore(registrationObject.getTimestamp().toInstant(ZoneOffset.UTC).minus(Duration.ofSeconds(this.backwardThreshold)))) {
            throw new BadAttestationStatementException("timestampMs violates backwardThreshold.");
        }
        if (Instant.ofEpochMilli(response.getTimestampMs()).isAfter(registrationObject.getTimestamp().toInstant(ZoneOffset.UTC).plus(Duration.ofSeconds(this.forwardThreshold)))) {
            throw new BadAttestationStatementException("timestampMs violates forwardThreshold.");
        }
        if (!attestationStatement.getResponse().isValidSignature()) {
            throw new BadAttestationStatementException("Android safetynet response in the attestation statement doesn't have a valid signature.");
        }
        return AttestationType.BASIC;
    }

    private void validateNonce(String nonce, byte[] authenticatorData, byte[] collectedClientData) {
        byte[] clientDataHash = MessageDigestUtil.createSHA256().digest(collectedClientData);
        ByteBuffer buffer = ByteBuffer.allocate(authenticatorData.length + clientDataHash.length);
        byte[] data = buffer.put(authenticatorData).put(clientDataHash).array();
        byte[] hash = MessageDigestUtil.createSHA256().digest(data);
        if (!Arrays.equals(hash, Base64Util.decode((String)nonce))) {
            throw new BadAttestationStatementException("Nonce in the Android safetynet response doesn't match.");
        }
    }

    public int getForwardThreshold() {
        return this.forwardThreshold;
    }

    public void setForwardThreshold(int forwardThreshold) {
        this.forwardThreshold = forwardThreshold;
    }

    public int getBackwardThreshold() {
        return this.backwardThreshold;
    }

    public void setBackwardThreshold(int backwardThreshold) {
        this.backwardThreshold = backwardThreshold;
    }

    public GooglePlayServiceVersionValidator getVersionValidator() {
        return this.versionValidator;
    }

    public void setVersionValidator(GooglePlayServiceVersionValidator versionValidator) {
        this.versionValidator = versionValidator;
    }

    private static class DefaultVersionValidator
    implements GooglePlayServiceVersionValidator {
        private static final int MINIMAL_VERSION = 0;

        private DefaultVersionValidator() {
        }

        @Override
        public void validate(String version) {
            try {
                int versionNumber = Integer.parseInt(version);
                if (versionNumber < 0) {
                    throw new BadAttestationStatementException("The version number of Google Play Services responsible for providing the SafetyNet API doesn't conform minimal requirement.");
                }
            }
            catch (NumberFormatException e) {
                throw new BadAttestationStatementException("`ver` in android safetynet attestation statement cannot be parsed as number.");
            }
        }
    }
}

