/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.client.ClientDataType;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.AssertionSignatureValidator;
import com.webauthn4j.validator.AuthenticationObject;
import com.webauthn4j.validator.BeanAssertUtil;
import com.webauthn4j.validator.ChallengeValidator;
import com.webauthn4j.validator.CustomAuthenticationValidator;
import com.webauthn4j.validator.DefaultMaliciousCounterValueHandler;
import com.webauthn4j.validator.ExtensionValidator;
import com.webauthn4j.validator.MaliciousCounterValueHandler;
import com.webauthn4j.validator.OriginValidator;
import com.webauthn4j.validator.RpIdHashValidator;
import com.webauthn4j.validator.TokenBindingValidator;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import com.webauthn4j.validator.exception.InconsistentClientDataTypeException;
import com.webauthn4j.validator.exception.UserNotPresentException;
import com.webauthn4j.validator.exception.UserNotVerifiedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AuthenticationDataValidator {
    private final ChallengeValidator challengeValidator = new ChallengeValidator();
    private final OriginValidator originValidator = new OriginValidator();
    private final TokenBindingValidator tokenBindingValidator = new TokenBindingValidator();
    private final RpIdHashValidator rpIdHashValidator = new RpIdHashValidator();
    private final AssertionSignatureValidator assertionSignatureValidator = new AssertionSignatureValidator();
    private final ExtensionValidator extensionValidator = new ExtensionValidator();
    private final List<CustomAuthenticationValidator> customAuthenticationValidators;
    private MaliciousCounterValueHandler maliciousCounterValueHandler = new DefaultMaliciousCounterValueHandler();

    public AuthenticationDataValidator(List<CustomAuthenticationValidator> customAuthenticationValidators) {
        this.customAuthenticationValidators = customAuthenticationValidators;
    }

    public AuthenticationDataValidator() {
        this.customAuthenticationValidators = new ArrayList<CustomAuthenticationValidator>();
    }

    public void validate(AuthenticationData authenticationData, AuthenticationParameters authenticationParameters) {
        BeanAssertUtil.validate(authenticationData);
        BeanAssertUtil.validate(authenticationParameters);
        byte[] cData = authenticationData.getCollectedClientDataBytes();
        byte[] aData = authenticationData.getAuthenticatorDataBytes();
        CollectedClientData collectedClientData = authenticationData.getCollectedClientData();
        AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData = authenticationData.getAuthenticatorData();
        AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> clientExtensions = authenticationData.getClientExtensions();
        ServerProperty serverProperty = authenticationParameters.getServerProperty();
        BeanAssertUtil.validate(collectedClientData);
        BeanAssertUtil.validate(authenticatorData);
        BeanAssertUtil.validate(serverProperty);
        this.validateAuthenticatorData(authenticatorData);
        byte[] credentialId = authenticationData.getCredentialId();
        Authenticator authenticator = authenticationParameters.getAuthenticator();
        AuthenticationObject authenticationObject = new AuthenticationObject(credentialId, authenticatorData, aData, collectedClientData, cData, clientExtensions, serverProperty, authenticator);
        if (!Objects.equals((Object)collectedClientData.getType(), (Object)ClientDataType.GET)) {
            throw new InconsistentClientDataTypeException("ClientData.type must be 'get' on authentication, but it isn't.");
        }
        this.challengeValidator.validate(collectedClientData, serverProperty);
        this.originValidator.validate(collectedClientData, serverProperty);
        this.tokenBindingValidator.validate(collectedClientData.getTokenBinding(), serverProperty.getTokenBindingId());
        this.rpIdHashValidator.validate(authenticatorData.getRpIdHash(), serverProperty);
        if (authenticationParameters.isUserPresenceRequired() && !authenticatorData.isFlagUP()) {
            throw new UserNotPresentException("Validator is configured to check user present, but UP flag in authenticatorData is not set.");
        }
        if (authenticationParameters.isUserVerificationRequired() && !authenticatorData.isFlagUV()) {
            throw new UserNotVerifiedException("Validator is configured to check user verified, but UV flag in authenticatorData is not set.");
        }
        AuthenticationExtensionsAuthenticatorOutputs<AuthenticationExtensionAuthenticatorOutput> authenticationExtensionsAuthenticatorOutputs = authenticatorData.getExtensions();
        List<String> expectedExtensionIdentifiers = authenticationParameters.getExpectedExtensionIds();
        this.extensionValidator.validate(clientExtensions, authenticationExtensionsAuthenticatorOutputs, expectedExtensionIdentifiers);
        this.assertionSignatureValidator.validate(authenticationData, authenticator.getAttestedCredentialData().getCOSEKey());
        long presentedCounter = authenticatorData.getSignCount();
        long storedCounter = authenticator.getCounter();
        if (presentedCounter > 0L || storedCounter > 0L) {
            if (presentedCounter > storedCounter) {
                authenticator.setCounter(presentedCounter);
            } else {
                this.maliciousCounterValueHandler.maliciousCounterValueDetected(authenticationObject);
            }
        }
        for (CustomAuthenticationValidator customAuthenticationValidator : this.customAuthenticationValidators) {
            customAuthenticationValidator.validate(authenticationObject);
        }
    }

    void validateAuthenticatorData(AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData) {
        if (authenticatorData.getAttestedCredentialData() != null) {
            throw new ConstraintViolationException("attestedCredentialData must be null on authentication");
        }
    }

    public MaliciousCounterValueHandler getMaliciousCounterValueHandler() {
        return this.maliciousCounterValueHandler;
    }

    public void setMaliciousCounterValueHandler(MaliciousCounterValueHandler maliciousCounterValueHandler) {
        AssertUtil.notNull((Object)maliciousCounterValueHandler, (String)"maliciousCounterValueHandler must not be null");
        this.maliciousCounterValueHandler = maliciousCounterValueHandler;
    }

    public List<CustomAuthenticationValidator> getCustomAuthenticationValidators() {
        return this.customAuthenticationValidators;
    }
}

