/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.authenticator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.attestation.authenticator.AbstractCOSEKey;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.attestation.statement.COSEKeyOperation;
import com.webauthn4j.data.attestation.statement.COSEKeyType;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.RSAUtil;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.List;

public class RSACOSEKey
extends AbstractCOSEKey {
    @JsonProperty(value="-1")
    private byte[] n;
    @JsonProperty(value="-2")
    private byte[] e;
    @JsonProperty(value="-3")
    private byte[] d;
    @JsonProperty(value="-4")
    private byte[] p;
    @JsonProperty(value="-5")
    private byte[] q;
    @JsonProperty(value="-6")
    private byte[] dP;
    @JsonProperty(value="-7")
    private byte[] dQ;
    @JsonProperty(value="-8")
    private byte[] qInv;

    @JsonCreator
    public RSACOSEKey(@JsonProperty(value="2") byte[] keyId, @JsonProperty(value="3") COSEAlgorithmIdentifier algorithm, @JsonProperty(value="4") List<COSEKeyOperation> keyOps, @JsonProperty(value="-1") byte[] n, @JsonProperty(value="-2") byte[] e, @JsonProperty(value="-3") byte[] d, @JsonProperty(value="-4") byte[] p, @JsonProperty(value="-5") byte[] q, @JsonProperty(value="-6") byte[] dP, @JsonProperty(value="-7") byte[] dQ, @JsonProperty(value="-8") byte[] qInv) {
        super(keyId, algorithm, keyOps, null);
        this.n = n;
        this.e = e;
        this.d = d;
        this.p = p;
        this.q = q;
        this.dP = dP;
        this.dQ = dQ;
        this.qInv = qInv;
    }

    public RSACOSEKey(@JsonProperty(value="2") byte[] keyId, @JsonProperty(value="3") COSEAlgorithmIdentifier algorithm, @JsonProperty(value="4") List<COSEKeyOperation> keyOps, @JsonProperty(value="-1") byte[] n, @JsonProperty(value="-2") byte[] e) {
        super(keyId, algorithm, keyOps, null);
        this.n = n;
        this.e = e;
    }

    public static RSACOSEKey create(RSAPrivateKey privateKey, COSEAlgorithmIdentifier alg) {
        byte[] n = privateKey.getModulus().toByteArray();
        byte[] d = privateKey.getPrivateExponent().toByteArray();
        return new RSACOSEKey(null, alg, null, n, null, d, null, null, null, null, null);
    }

    public static RSACOSEKey create(RSAPublicKey publicKey, COSEAlgorithmIdentifier alg) {
        publicKey.getPublicExponent();
        byte[] n = publicKey.getModulus().toByteArray();
        byte[] e = publicKey.getPublicExponent().toByteArray();
        return new RSACOSEKey(null, alg, null, n, e);
    }

    public static RSACOSEKey create(KeyPair keyPair, COSEAlgorithmIdentifier alg) {
        if (keyPair != null && keyPair.getPrivate() instanceof RSAPrivateKey && keyPair.getPublic() instanceof RSAPublicKey) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
            byte[] n = rsaPublicKey.getModulus().toByteArray();
            byte[] e = rsaPublicKey.getPublicExponent().toByteArray();
            byte[] d = rsaPrivateKey.getPrivateExponent().toByteArray();
            return new RSACOSEKey(null, alg, null, n, e, d, null, null, null, null, null);
        }
        throw new IllegalArgumentException();
    }

    public static RSACOSEKey create(RSAPrivateKey privateKey) {
        return RSACOSEKey.create(privateKey, null);
    }

    public static RSACOSEKey create(RSAPublicKey publicKey) {
        return RSACOSEKey.create(publicKey, null);
    }

    public static RSACOSEKey create(KeyPair keyPair) {
        return RSACOSEKey.create(keyPair, null);
    }

    @Override
    public COSEKeyType getKeyType() {
        return COSEKeyType.RSA;
    }

    public byte[] getN() {
        return ArrayUtil.clone((byte[])this.n);
    }

    public byte[] getE() {
        return ArrayUtil.clone((byte[])this.e);
    }

    public byte[] getD() {
        return ArrayUtil.clone((byte[])this.d);
    }

    public byte[] getP() {
        return this.p;
    }

    public byte[] getQ() {
        return this.q;
    }

    public byte[] getDP() {
        return this.dP;
    }

    public byte[] getDQ() {
        return this.dQ;
    }

    public byte[] getQInv() {
        return this.qInv;
    }

    @Override
    public boolean hasPublicKey() {
        return this.n != null && this.e != null;
    }

    @Override
    public boolean hasPrivateKey() {
        return this.n != null && this.d != null;
    }

    @Override
    public PublicKey getPublicKey() {
        if (!this.hasPublicKey()) {
            return null;
        }
        RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(1, this.getN()), new BigInteger(1, this.getE()));
        return RSAUtil.createPublicKey((RSAPublicKeySpec)spec);
    }

    @Override
    public PrivateKey getPrivateKey() {
        if (!this.hasPrivateKey()) {
            return null;
        }
        RSAPrivateKeySpec rsaPrivateKeySpec = new RSAPrivateKeySpec(new BigInteger(1, this.getN()), new BigInteger(1, this.getD()));
        return RSAUtil.createPrivateKey((RSAPrivateKeySpec)rsaPrivateKeySpec);
    }

    @Override
    public void validate() {
        if (this.getAlgorithm() == null) {
            throw new ConstraintViolationException("algorithm must not be null");
        }
        if (this.n == null) {
            throw new ConstraintViolationException("n must not be null");
        }
        if (this.e == null) {
            throw new ConstraintViolationException("e must not be null");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RSACOSEKey that = (RSACOSEKey)o;
        return Arrays.equals(this.n, that.n) && Arrays.equals(this.e, that.e) && Arrays.equals(this.d, that.d) && Arrays.equals(this.p, that.p) && Arrays.equals(this.q, that.q) && Arrays.equals(this.dP, that.dP) && Arrays.equals(this.dQ, that.dQ) && Arrays.equals(this.qInv, that.qInv);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.n);
        result = 31 * result + Arrays.hashCode(this.e);
        result = 31 * result + Arrays.hashCode(this.d);
        result = 31 * result + Arrays.hashCode(this.p);
        result = 31 * result + Arrays.hashCode(this.q);
        result = 31 * result + Arrays.hashCode(this.dP);
        result = 31 * result + Arrays.hashCode(this.dQ);
        result = 31 * result + Arrays.hashCode(this.qInv);
        return result;
    }
}

