/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.webauthn4j.converter.jackson.JacksonUtil;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.Base64UrlUtil;

public class AttestationObjectConverter {
    private CborConverter cborConverter;

    public AttestationObjectConverter(ObjectConverter objectConverter) {
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.cborConverter = objectConverter.getCborConverter();
    }

    public AttestationObject convert(String source) {
        if (source == null) {
            return null;
        }
        byte[] value = Base64UrlUtil.decode((String)source);
        return this.convert(value);
    }

    public AttestationObject convert(byte[] source) {
        if (source == null) {
            return null;
        }
        return (AttestationObject)this.cborConverter.readValue(source, AttestationObject.class);
    }

    public byte[] convertToBytes(AttestationObject source) {
        return this.cborConverter.writeValueAsBytes(source);
    }

    public String convertToBase64urlString(AttestationObject source) {
        byte[] bytes = this.convertToBytes(source);
        return Base64UrlUtil.encodeToString((byte[])bytes);
    }

    public byte[] extractAuthenticatorData(byte[] attestationObject) {
        return JacksonUtil.binaryValue(this.cborConverter.readTree(attestationObject).get("authData"));
    }

    public byte[] extractAttestationStatement(byte[] attestationObject) {
        return this.cborConverter.writeValueAsBytes(this.cborConverter.readTree(attestationObject).get("attStmt"));
    }
}

