/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.statement.Response;
import com.webauthn4j.data.jws.JWS;
import com.webauthn4j.data.jws.JWSFactory;
import com.webauthn4j.util.AssertUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class JWSDeserializer
extends StdDeserializer<JWS> {
    private JWSFactory jwsFactory;

    public JWSDeserializer(ObjectConverter objectConverter) {
        super(JWS.class);
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.jwsFactory = new JWSFactory(objectConverter);
    }

    public JWS deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        byte[] value = p.getBinaryValue();
        String str = new String(value, StandardCharsets.UTF_8);
        try {
            return this.jwsFactory.parse(str, Response.class);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(p, "value is not valid as JWS", (Object)value, JWS.class);
        }
    }
}

