/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.WebAuthnManager;
import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.AuthenticationRequest;
import com.webauthn4j.data.WebAuthnAuthenticationContext;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.exception.WebAuthnException;
import com.webauthn4j.validator.CustomAuthenticationValidator;
import com.webauthn4j.validator.MaliciousCounterValueHandler;
import com.webauthn4j.validator.WebAuthnAuthenticationContextValidationResponse;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.NullCertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.ecdaa.NullECDAATrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.NullSelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Deprecated
public class WebAuthnAuthenticationContextValidator {
    private final WebAuthnManager webAuthnManager;
    private List<CustomAuthenticationValidator> customAuthenticationValidators = new ArrayList<CustomAuthenticationValidator>();

    public WebAuthnAuthenticationContextValidator() {
        this(new JsonConverter(), new CborConverter());
    }

    public WebAuthnAuthenticationContextValidator(JsonConverter jsonConverter, CborConverter cborConverter) {
        AssertUtil.notNull((Object)jsonConverter, (String)"jsonConverter must not be null");
        AssertUtil.notNull((Object)cborConverter, (String)"cborConverter must not be null");
        this.webAuthnManager = new WebAuthnManager(Collections.emptyList(), new NullCertPathTrustworthinessValidator(), new NullECDAATrustworthinessValidator(), new NullSelfAttestationTrustworthinessValidator(), Collections.emptyList(), this.customAuthenticationValidators, new ObjectConverter(jsonConverter, cborConverter));
    }

    public WebAuthnAuthenticationContextValidationResponse validate(WebAuthnAuthenticationContext authenticationContext, Authenticator authenticator) throws WebAuthnException {
        AuthenticationRequest authenticationRequest = new AuthenticationRequest(authenticationContext.getCredentialId(), authenticationContext.getUserHandle(), authenticationContext.getAuthenticatorData(), authenticationContext.getClientDataJSON(), authenticationContext.getClientExtensionsJSON(), authenticationContext.getSignature());
        AuthenticationParameters authenticationParameters = new AuthenticationParameters(authenticationContext.getServerProperty(), authenticator, authenticationContext.isUserVerificationRequired(), authenticationContext.isUserPresenceRequired(), authenticationContext.getExpectedExtensionIds());
        AuthenticationData authenticationData = this.webAuthnManager.validate(authenticationRequest, authenticationParameters);
        return new WebAuthnAuthenticationContextValidationResponse(authenticationData.getCollectedClientData(), authenticationData.getAuthenticatorData(), authenticationData.getClientExtensions());
    }

    void validateAuthenticatorData(AuthenticatorData authenticatorData) {
        if (authenticatorData.getAttestedCredentialData() != null) {
            throw new ConstraintViolationException("attestedCredentialData must be null on authentication");
        }
    }

    public MaliciousCounterValueHandler getMaliciousCounterValueHandler() {
        return this.webAuthnManager.getAuthenticationDataValidator().getMaliciousCounterValueHandler();
    }

    public void setMaliciousCounterValueHandler(MaliciousCounterValueHandler maliciousCounterValueHandler) {
        AssertUtil.notNull((Object)maliciousCounterValueHandler, (String)"maliciousCounterValueHandler must not be null");
        this.webAuthnManager.getAuthenticationDataValidator().setMaliciousCounterValueHandler(maliciousCounterValueHandler);
    }

    public List<CustomAuthenticationValidator> getCustomAuthenticationValidators() {
        return this.customAuthenticationValidators;
    }
}

