/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.async.verifier.attestation.trustworthiness.certpath;

import com.webauthn4j.async.anchor.TrustAnchorAsyncRepository;
import com.webauthn4j.async.verifier.attestation.trustworthiness.certpath.CertPathTrustworthinessAsyncVerifier;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.data.attestation.statement.FIDOU2FAttestationStatement;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CertificateUtil;
import com.webauthn4j.util.CompletionStageUtil;
import com.webauthn4j.verifier.attestation.trustworthiness.certpath.DefaultCertPathTrustworthinessVerifier;
import com.webauthn4j.verifier.exception.CertificateException;
import com.webauthn4j.verifier.exception.TrustAnchorNotFoundException;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;

public class DefaultCertPathTrustworthinessAsyncVerifier
implements CertPathTrustworthinessAsyncVerifier {
    private final TrustAnchorAsyncRepository trustAnchorAsyncRepository;
    private boolean fullChainProhibited = false;
    private boolean policyQualifiersRejected = false;

    public DefaultCertPathTrustworthinessAsyncVerifier(TrustAnchorAsyncRepository trustAnchorAsyncRepository) {
        this.trustAnchorAsyncRepository = trustAnchorAsyncRepository;
    }

    @Override
    public CompletionStage<Void> verify(@NotNull AAGUID aaguid, @NotNull CertificateBaseAttestationStatement attestationStatement, @NotNull Instant timestamp) {
        return CompletionStageUtil.compose(() -> {
            AssertUtil.notNull((Object)aaguid, (String)"aaguid must not be null");
            AssertUtil.notNull((Object)attestationStatement, (String)"attestationStatement must not be null");
            AssertUtil.notNull((Object)timestamp, (String)"timestamp must not be null");
            if (attestationStatement instanceof FIDOU2FAttestationStatement) {
                FIDOU2FAttestationStatement fidou2fAttestationStatement = (FIDOU2FAttestationStatement)attestationStatement;
                byte[] subjectKeyIdentifier = DefaultCertPathTrustworthinessVerifier.extractSubjectKeyIdentifier((X509Certificate)fidou2fAttestationStatement.getX5c().getEndEntityAttestationCertificate().getCertificate());
                return this.trustAnchorAsyncRepository.find(subjectKeyIdentifier);
            }
            return this.trustAnchorAsyncRepository.find(aaguid);
        }).thenCompose(trustAnchors -> {
            CertPath certPath = attestationStatement.getX5c().createCertPath();
            this.verifyCertPath(certPath, (Set<TrustAnchor>)trustAnchors, timestamp);
            return CompletableFuture.completedFuture(null);
        });
    }

    private TrustAnchor verifyCertPath(CertPath certPath, Set<TrustAnchor> trustAnchors, Instant timestamp) {
        PKIXCertPathValidatorResult result;
        if (trustAnchors.isEmpty()) {
            throw new TrustAnchorNotFoundException("TrustAnchors are not found");
        }
        CertPathValidator certPathValidator = CertificateUtil.createCertPathValidator();
        PKIXParameters certPathParameters = CertificateUtil.createPKIXParameters(trustAnchors);
        certPathParameters.setPolicyQualifiersRejected(this.policyQualifiersRejected);
        certPathParameters.setRevocationEnabled(false);
        certPathParameters.setDate(Date.from(timestamp));
        if (certPath.getCertificates().size() == 1) {
            Certificate certificate = certPath.getCertificates().get(0);
            TrustAnchor trustAnchor = trustAnchors.stream().filter(it -> it.getTrustedCert().equals(certificate)).findFirst().orElse(null);
            if (trustAnchor != null) {
                return trustAnchor;
            }
        }
        try {
            result = (PKIXCertPathValidatorResult)certPathValidator.validate(certPath, certPathParameters);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertificateException("invalid algorithm parameter", (Throwable)e);
        }
        catch (CertPathValidatorException e) {
            throw new CertificateException("invalid cert path", (Throwable)e);
        }
        if (this.fullChainProhibited && certPath.getCertificates().contains(result.getTrustAnchor().getTrustedCert())) {
            throw new CertificateException("`certpath` must not contain full chain.");
        }
        return trustAnchors.stream().filter(item -> Objects.equals(item, result.getTrustAnchor())).findFirst().orElseThrow(() -> new IllegalStateException("Matching TrustAnchor is not found."));
    }

    public boolean isFullChainProhibited() {
        return this.fullChainProhibited;
    }

    public void setFullChainProhibited(boolean fullChainProhibited) {
        this.fullChainProhibited = fullChainProhibited;
    }

    public boolean isPolicyQualifiersRejected() {
        return this.policyQualifiersRejected;
    }

    public void setPolicyQualifiersRejected(boolean policyQualifiersRejected) {
        this.policyQualifiersRejected = policyQualifiersRejected;
    }
}

