/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.async.verifier;

import com.webauthn4j.async.verifier.AttestationAsyncVerifier;
import com.webauthn4j.async.verifier.AuthenticatorExtensionAsyncVerifier;
import com.webauthn4j.async.verifier.ClientExtensionAsyncVerifier;
import com.webauthn4j.async.verifier.CustomRegistrationAsyncVerifier;
import com.webauthn4j.async.verifier.OriginAsyncVerifier;
import com.webauthn4j.async.verifier.OriginAsyncVerifierImpl;
import com.webauthn4j.async.verifier.attestation.statement.AttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.certpath.CertPathTrustworthinessAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.self.SelfAttestationTrustworthinessAsyncVerifier;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationParameters;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.client.ClientDataType;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.client.TokenBinding;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.CoreRegistrationObject;
import com.webauthn4j.verifier.RegistrationObject;
import com.webauthn4j.verifier.exception.ConstraintViolationException;
import com.webauthn4j.verifier.exception.InconsistentClientDataTypeException;
import com.webauthn4j.verifier.internal.BEBSFlagsVerifier;
import com.webauthn4j.verifier.internal.BeanAssertUtil;
import com.webauthn4j.verifier.internal.COSEAlgorithmIdentifierVerifier;
import com.webauthn4j.verifier.internal.ChallengeVerifier;
import com.webauthn4j.verifier.internal.CredentialIdLengthVerifier;
import com.webauthn4j.verifier.internal.RpIdHashVerifier;
import com.webauthn4j.verifier.internal.TokenBindingVerifier;
import com.webauthn4j.verifier.internal.TopOriginVerifier;
import com.webauthn4j.verifier.internal.UPUVFlagsVerifier;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class RegistrationDataAsyncVerifier {
    private static final int DEFAULT_MAX_CREDENTIAL_ID_LENGTH = 1023;
    private final ClientExtensionAsyncVerifier clientExtensionAsyncVerifier = new ClientExtensionAsyncVerifier();
    private final AuthenticatorExtensionAsyncVerifier authenticatorExtensionAsyncVerifier = new AuthenticatorExtensionAsyncVerifier();
    private final List<CustomRegistrationAsyncVerifier> customRegistrationAsyncVerifiers;
    private final AttestationAsyncVerifier attestationAsyncVerifier;
    private OriginAsyncVerifier originVerifier = new OriginAsyncVerifierImpl();
    private final TopOriginVerifier topOriginVerifier = new TopOriginVerifier();
    private int maxCredentialIdLength = 1023;

    public RegistrationDataAsyncVerifier(List<AttestationStatementAsyncVerifier> attestationStatementAsyncVerifiers, CertPathTrustworthinessAsyncVerifier certPathTrustworthinessAsyncVerifier, SelfAttestationTrustworthinessAsyncVerifier selfAttestationTrustworthinessAsyncVerifier, List<CustomRegistrationAsyncVerifier> customRegistrationAsyncVerifiers, ObjectConverter objectConverter) {
        AssertUtil.notNull(attestationStatementAsyncVerifiers, (String)"attestationStatementAsyncVerifiers must not be null");
        AssertUtil.notNull((Object)certPathTrustworthinessAsyncVerifier, (String)"certPathTrustworthinessAsyncVerifier must not be null");
        AssertUtil.notNull((Object)selfAttestationTrustworthinessAsyncVerifier, (String)"selfAttestationTrustworthinessAsyncVerifier must not be null");
        AssertUtil.notNull(customRegistrationAsyncVerifiers, (String)"customRegistrationAsyncVerifiers must not be null");
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.attestationAsyncVerifier = new AttestationAsyncVerifier(attestationStatementAsyncVerifiers, certPathTrustworthinessAsyncVerifier, selfAttestationTrustworthinessAsyncVerifier);
        this.customRegistrationAsyncVerifiers = customRegistrationAsyncVerifiers;
    }

    public CompletionStage<RegistrationData> verify(RegistrationData registrationData, RegistrationParameters registrationParameters) {
        RegistrationDataVerification registrationDataVerification = new RegistrationDataVerification(registrationData, registrationParameters);
        return registrationDataVerification.execute();
    }

    public OriginAsyncVerifier getOriginVerifier() {
        return this.originVerifier;
    }

    public void setOriginVerifier(OriginAsyncVerifier originVerifier) {
        this.originVerifier = originVerifier;
    }

    public int getMaxCredentialIdLength() {
        return this.maxCredentialIdLength;
    }

    public void setMaxCredentialIdLength(int maxCredentialIdLength) {
        this.maxCredentialIdLength = maxCredentialIdLength;
    }

    private class RegistrationDataVerification {
        private final RegistrationData registrationData;
        private final RegistrationParameters registrationParameters;
        private CollectedClientData collectedClientData;
        private AttestationObject attestationObject;
        private RegistrationObject registrationObject;
        private AuthenticatorData<RegistrationExtensionAuthenticatorOutput> authenticatorData;

        private RegistrationDataVerification(RegistrationData registrationData, RegistrationParameters registrationParameters) {
            this.registrationData = registrationData;
            this.registrationParameters = registrationParameters;
        }

        public CompletionStage<RegistrationData> execute() {
            return this.execStep1toStep8().thenCompose(unused -> this.execStep9()).thenCompose(unused -> this.execStep10toStep19()).thenCompose(unused -> this.execStep20()).thenCompose(unused -> this.execStep21toStep24AndStep28()).thenCompose(unused -> this.execStep25toStep27()).thenApply(unused -> this.registrationData);
        }

        private CompletionStage<Void> execStep1toStep8() {
            BeanAssertUtil.validate((RegistrationData)this.registrationData);
            AssertUtil.notNull((Object)this.registrationParameters, (String)"registrationParameters must not be null");
            AuthenticationExtensionsClientOutputs clientExtensions = this.registrationData.getClientExtensions();
            this.attestationObject = this.registrationData.getAttestationObject();
            if (this.attestationObject.getAuthenticatorData().getAttestedCredentialData() == null) {
                throw new ConstraintViolationException("attestedCredentialData must not be null on registration");
            }
            this.collectedClientData = this.registrationData.getCollectedClientData();
            this.authenticatorData = this.attestationObject.getAuthenticatorData();
            ServerProperty serverProperty = this.registrationParameters.getServerProperty();
            Set transports = this.registrationData.getTransports();
            byte[] clientDataBytes = this.registrationData.getCollectedClientDataBytes();
            byte[] attestationObjectBytes = this.registrationData.getAttestationObjectBytes();
            this.registrationObject = new RegistrationObject(this.attestationObject, attestationObjectBytes, this.collectedClientData, clientDataBytes, clientExtensions, transports, serverProperty);
            if (!Objects.equals(this.collectedClientData.getType(), ClientDataType.WEBAUTHN_CREATE)) {
                throw new InconsistentClientDataTypeException("ClientData.type must be 'create' on registration, but it isn't.");
            }
            ChallengeVerifier.verify((CollectedClientData)this.collectedClientData, (ServerProperty)this.registrationObject.getServerProperty());
            return CompletableFuture.completedFuture(null);
        }

        private CompletionStage<Void> execStep9() {
            return RegistrationDataAsyncVerifier.this.originVerifier.verify(this.registrationObject);
        }

        private CompletionStage<Void> execStep10toStep19() {
            TokenBindingVerifier.verify((TokenBinding)this.collectedClientData.getTokenBinding(), (byte[])this.registrationObject.getServerProperty().getTokenBindingId());
            RegistrationDataAsyncVerifier.this.topOriginVerifier.verify(this.registrationObject);
            RpIdHashVerifier.verify((byte[])this.authenticatorData.getRpIdHash(), (CoreServerProperty)this.registrationObject.getServerProperty());
            UPUVFlagsVerifier.verify(this.authenticatorData, (boolean)this.registrationParameters.isUserPresenceRequired(), (boolean)this.registrationParameters.isUserVerificationRequired());
            BEBSFlagsVerifier.verify(this.authenticatorData);
            COSEAlgorithmIdentifier alg = this.authenticatorData.getAttestedCredentialData().getCOSEKey().getAlgorithm();
            List pubKeyCredParams = this.registrationParameters.getPubKeyCredParams();
            COSEAlgorithmIdentifierVerifier.verify((COSEAlgorithmIdentifier)alg, (List)pubKeyCredParams);
            return CompletableFuture.completedFuture(null);
        }

        private CompletionStage<Void> execStep20() {
            AuthenticationExtensionsClientOutputs clientExtensions = this.registrationObject.getClientExtensions();
            AuthenticationExtensionsAuthenticatorOutputs authenticatorExtensions = this.authenticatorData.getExtensions();
            return RegistrationDataAsyncVerifier.this.clientExtensionAsyncVerifier.verify(clientExtensions).thenCompose(unused -> RegistrationDataAsyncVerifier.this.authenticatorExtensionAsyncVerifier.verify(authenticatorExtensions));
        }

        private CompletionStage<Void> execStep21toStep24AndStep28() {
            return RegistrationDataAsyncVerifier.this.attestationAsyncVerifier.verify((CoreRegistrationObject)this.registrationObject);
        }

        private CompletionStage<Void> execStep25toStep27() {
            CredentialIdLengthVerifier.verify((byte[])this.attestationObject.getAuthenticatorData().getAttestedCredentialData().getCredentialId(), (int)RegistrationDataAsyncVerifier.this.maxCredentialIdLength);
            Iterator<CustomRegistrationAsyncVerifier> iterator = RegistrationDataAsyncVerifier.this.customRegistrationAsyncVerifiers.iterator();
            CompletionStage<Object> completableFuture = CompletableFuture.completedFuture(null);
            while (iterator.hasNext()) {
                CustomRegistrationAsyncVerifier customRegistrationAsyncVerifier = iterator.next();
                completableFuture = completableFuture.thenAccept(unused -> customRegistrationAsyncVerifier.verify(this.registrationObject));
            }
            return CompletableFuture.completedFuture(null);
        }
    }
}

