/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.async;

import com.webauthn4j.async.verifier.CustomRegistrationAsyncVerifier;
import com.webauthn4j.async.verifier.RegistrationDataAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.AttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.androidkey.NullAndroidKeyAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.androidsafetynet.NullAndroidSafetyNetAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.apple.NullAppleAnonymousAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.none.NoneAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.packed.NullPackedAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.tpm.NullTPMAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.u2f.NullFIDOU2FAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.certpath.CertPathTrustworthinessAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.certpath.NullCertPathTrustworthinessAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.self.NullSelfAttestationTrustworthinessAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.self.SelfAttestationTrustworthinessAsyncVerifier;
import com.webauthn4j.converter.AttestationObjectConverter;
import com.webauthn4j.converter.AuthenticationExtensionsClientOutputsConverter;
import com.webauthn4j.converter.AuthenticatorTransportConverter;
import com.webauthn4j.converter.CollectedClientDataConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticatorAttestationResponse;
import com.webauthn4j.data.PublicKeyCredential;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationParameters;
import com.webauthn4j.data.RegistrationRequest;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CompletionStageUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.core.type.TypeReference;

public class WebAuthnRegistrationAsyncManager {
    private final Logger logger = LoggerFactory.getLogger(WebAuthnRegistrationAsyncManager.class);
    private final CollectedClientDataConverter collectedClientDataConverter;
    private final AttestationObjectConverter attestationObjectConverter;
    private final AuthenticatorTransportConverter authenticatorTransportConverter;
    private final AuthenticationExtensionsClientOutputsConverter authenticationExtensionsClientOutputsConverter;
    private final RegistrationDataAsyncVerifier registrationDataAsyncVerifier;
    private final ObjectConverter objectConverter;

    public WebAuthnRegistrationAsyncManager(@NotNull List<AttestationStatementAsyncVerifier> attestationStatementAsyncVerifiers, @NotNull CertPathTrustworthinessAsyncVerifier certPathTrustworthinessAsyncVerifier, @NotNull SelfAttestationTrustworthinessAsyncVerifier selfAttestationTrustworthinessAsyncVerifier, @NotNull List<CustomRegistrationAsyncVerifier> customRegistrationAsyncVerifiers, @NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull(attestationStatementAsyncVerifiers, (String)"attestationStatementAsyncVerifiers must not be null");
        AssertUtil.notNull((Object)certPathTrustworthinessAsyncVerifier, (String)"certPathTrustworthinessAsyncVerifier must not be null");
        AssertUtil.notNull((Object)selfAttestationTrustworthinessAsyncVerifier, (String)"selfAttestationTrustworthinessAsyncVerifier must not be null");
        AssertUtil.notNull(customRegistrationAsyncVerifiers, (String)"customRegistrationAsyncVerifiers must not be null");
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.registrationDataAsyncVerifier = new RegistrationDataAsyncVerifier(attestationStatementAsyncVerifiers, certPathTrustworthinessAsyncVerifier, selfAttestationTrustworthinessAsyncVerifier, customRegistrationAsyncVerifiers, objectConverter);
        this.collectedClientDataConverter = new CollectedClientDataConverter(objectConverter);
        this.attestationObjectConverter = new AttestationObjectConverter(objectConverter);
        this.authenticatorTransportConverter = new AuthenticatorTransportConverter();
        this.authenticationExtensionsClientOutputsConverter = new AuthenticationExtensionsClientOutputsConverter(objectConverter);
        this.objectConverter = objectConverter;
    }

    public WebAuthnRegistrationAsyncManager(@NotNull List<AttestationStatementAsyncVerifier> attestationStatementAsyncVerifiers, @NotNull CertPathTrustworthinessAsyncVerifier certPathTrustworthinessAsyncVerifier, @NotNull SelfAttestationTrustworthinessAsyncVerifier selfAttestationTrustworthinessAsyncVerifier, @NotNull List<CustomRegistrationAsyncVerifier> customRegistrationAsyncVerifiers) {
        this(attestationStatementAsyncVerifiers, certPathTrustworthinessAsyncVerifier, selfAttestationTrustworthinessAsyncVerifier, customRegistrationAsyncVerifiers, new ObjectConverter());
    }

    public WebAuthnRegistrationAsyncManager(@NotNull List<AttestationStatementAsyncVerifier> attestationStatementAsyncVerifiers, @NotNull CertPathTrustworthinessAsyncVerifier certPathTrustworthinessAsyncVerifier, @NotNull SelfAttestationTrustworthinessAsyncVerifier selfAttestationTrustworthinessAsyncVerifier, @NotNull ObjectConverter objectConverter) {
        this(attestationStatementAsyncVerifiers, certPathTrustworthinessAsyncVerifier, selfAttestationTrustworthinessAsyncVerifier, Collections.emptyList(), objectConverter);
    }

    public WebAuthnRegistrationAsyncManager(@NotNull List<AttestationStatementAsyncVerifier> attestationStatementAsyncVerifiers, @NotNull CertPathTrustworthinessAsyncVerifier certPathTrustworthinessAsyncVerifier, @NotNull SelfAttestationTrustworthinessAsyncVerifier selfAttestationTrustworthinessAsyncVerifier) {
        this(attestationStatementAsyncVerifiers, certPathTrustworthinessAsyncVerifier, selfAttestationTrustworthinessAsyncVerifier, Collections.emptyList());
    }

    @NotNull
    public static WebAuthnRegistrationAsyncManager createNonStrictWebAuthnRegistrationAsyncManager() {
        ObjectConverter objectConverter = new ObjectConverter();
        return WebAuthnRegistrationAsyncManager.createNonStrictWebAuthnRegistrationAsyncManager(objectConverter);
    }

    @NotNull
    public static WebAuthnRegistrationAsyncManager createNonStrictWebAuthnRegistrationAsyncManager(@NotNull ObjectConverter objectConverter) {
        return new WebAuthnRegistrationAsyncManager(Arrays.asList(new NoneAttestationStatementAsyncVerifier(), new NullFIDOU2FAttestationStatementAsyncVerifier(), new NullPackedAttestationStatementAsyncVerifier(), new NullTPMAttestationStatementAsyncVerifier(), new NullAndroidKeyAttestationStatementAsyncVerifier(), new NullAndroidSafetyNetAttestationStatementAsyncVerifier(), new NullAppleAnonymousAttestationStatementAsyncVerifier()), (CertPathTrustworthinessAsyncVerifier)new NullCertPathTrustworthinessAsyncVerifier(), (SelfAttestationTrustworthinessAsyncVerifier)new NullSelfAttestationTrustworthinessAsyncVerifier(), objectConverter);
    }

    @NotNull
    public CompletionStage<RegistrationData> parse(String registrationResponseJSON) {
        return CompletionStageUtil.supply(() -> (PublicKeyCredential)this.objectConverter.getJsonMapper().readValue(registrationResponseJSON, (TypeReference)new TypeReference<PublicKeyCredential<AuthenticatorAttestationResponse, RegistrationExtensionClientOutput>>(){})).thenApply(publicKeyCredential -> {
            byte[] attestationObjectBytes = ((AuthenticatorAttestationResponse)publicKeyCredential.getResponse()).getAttestationObject();
            AttestationObject attestationObject = attestationObjectBytes == null ? null : this.attestationObjectConverter.convert(attestationObjectBytes);
            byte[] clientDataBytes = ((AuthenticatorAttestationResponse)publicKeyCredential.getResponse()).getClientDataJSON();
            CollectedClientData collectedClientData = clientDataBytes == null ? null : this.collectedClientDataConverter.convert(clientDataBytes);
            return new RegistrationData(attestationObject, attestationObjectBytes, collectedClientData, clientDataBytes, publicKeyCredential.getClientExtensionResults(), ((AuthenticatorAttestationResponse)publicKeyCredential.getResponse()).getTransports());
        });
    }

    @NotNull
    public CompletionStage<RegistrationData> parse(@NotNull RegistrationRequest registrationRequest) {
        return CompletionStageUtil.supply(() -> {
            AssertUtil.notNull((Object)registrationRequest, (String)"registrationRequest must not be null");
            byte[] clientDataBytes = registrationRequest.getClientDataJSON();
            byte[] attestationObjectBytes = registrationRequest.getAttestationObject();
            this.logger.trace("Parse: {}", (Object)registrationRequest);
            CollectedClientData collectedClientData = clientDataBytes == null ? null : this.collectedClientDataConverter.convert(clientDataBytes);
            AttestationObject attestationObject = attestationObjectBytes == null ? null : this.attestationObjectConverter.convert(attestationObjectBytes);
            Set transports = registrationRequest.getTransports() == null ? null : this.authenticatorTransportConverter.convertSet(registrationRequest.getTransports());
            AuthenticationExtensionsClientOutputs clientExtensions = registrationRequest.getClientExtensionsJSON() == null ? null : this.authenticationExtensionsClientOutputsConverter.convert(registrationRequest.getClientExtensionsJSON());
            return new RegistrationData(attestationObject, attestationObjectBytes, collectedClientData, clientDataBytes, clientExtensions, transports);
        });
    }

    public CompletionStage<RegistrationData> verify(String registrationResponseJSON, @NotNull RegistrationParameters registrationParameters) {
        return this.parse(registrationResponseJSON).thenCompose(registrationData -> this.verify((RegistrationData)registrationData, registrationParameters));
    }

    @NotNull
    public CompletionStage<RegistrationData> verify(@NotNull RegistrationRequest registrationRequest, @NotNull RegistrationParameters registrationParameters) {
        return this.parse(registrationRequest).thenCompose(registrationData -> this.verify((RegistrationData)registrationData, registrationParameters));
    }

    @NotNull
    public CompletionStage<RegistrationData> verify(@NotNull RegistrationData registrationData, @NotNull RegistrationParameters registrationParameters) {
        this.logger.trace("Verify: {}, {}", (Object)registrationData, (Object)registrationParameters);
        return this.registrationDataAsyncVerifier.verify(registrationData, registrationParameters);
    }

    @NotNull
    public RegistrationDataAsyncVerifier getRegistrationDataAsyncVerifier() {
        return this.registrationDataAsyncVerifier;
    }
}

