/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.async.verifier;

import com.webauthn4j.async.verifier.AuthenticatorExtensionAsyncVerifier;
import com.webauthn4j.async.verifier.ClientExtensionAsyncVerifier;
import com.webauthn4j.async.verifier.CustomAuthenticationAsyncVerifier;
import com.webauthn4j.async.verifier.DefaultMaliciousCounterValueAsyncHandler;
import com.webauthn4j.async.verifier.OriginAsyncVerifier;
import com.webauthn4j.async.verifier.OriginAsyncVerifierImpl;
import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.credential.CoreCredentialRecord;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.CoreAuthenticationData;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.client.ClientDataType;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.client.TokenBinding;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.AuthenticationObject;
import com.webauthn4j.verifier.exception.ConstraintViolationException;
import com.webauthn4j.verifier.exception.InconsistentClientDataTypeException;
import com.webauthn4j.verifier.internal.AssertionSignatureVerifier;
import com.webauthn4j.verifier.internal.BEBSFlagsVerifier;
import com.webauthn4j.verifier.internal.BEFlagVerifier;
import com.webauthn4j.verifier.internal.BeanAssertUtil;
import com.webauthn4j.verifier.internal.ChallengeVerifier;
import com.webauthn4j.verifier.internal.CredentialIdVerifier;
import com.webauthn4j.verifier.internal.RpIdHashVerifier;
import com.webauthn4j.verifier.internal.TokenBindingVerifier;
import com.webauthn4j.verifier.internal.TopOriginVerifier;
import com.webauthn4j.verifier.internal.UPUVFlagsVerifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;

public class AuthenticationDataAsyncVerifier {
    private final AssertionSignatureVerifier assertionSignatureVerifier = new AssertionSignatureVerifier();
    private final ClientExtensionAsyncVerifier clientExtensionAsyncVerifier = new ClientExtensionAsyncVerifier();
    private final AuthenticatorExtensionAsyncVerifier authenticatorExtensionAsyncVerifier = new AuthenticatorExtensionAsyncVerifier();
    private final List<CustomAuthenticationAsyncVerifier> customAuthenticationAsyncVerifiers;
    private OriginAsyncVerifier originAsyncVerifier = new OriginAsyncVerifierImpl();
    private TopOriginVerifier topOriginVerifier = new TopOriginVerifier();
    private DefaultMaliciousCounterValueAsyncHandler maliciousCounterValueAsyncHandler = new DefaultMaliciousCounterValueAsyncHandler();

    public AuthenticationDataAsyncVerifier(@NotNull List<CustomAuthenticationAsyncVerifier> customAuthenticationAsyncVerifiers) {
        AssertUtil.notNull(customAuthenticationAsyncVerifiers, (String)"customAuthenticationAsyncVerifiers must not be null");
        this.customAuthenticationAsyncVerifiers = customAuthenticationAsyncVerifiers;
    }

    public AuthenticationDataAsyncVerifier() {
        this.customAuthenticationAsyncVerifiers = new ArrayList<CustomAuthenticationAsyncVerifier>();
    }

    public CompletionStage<AuthenticationData> verify(AuthenticationData authenticationData, AuthenticationParameters authenticationParameters) {
        return new AuthenticationDataVerification(authenticationData, authenticationParameters).execute();
    }

    static void updateRecord(Authenticator authenticator, AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData) {
        authenticator.setCounter(authenticatorData.getSignCount());
        if (authenticator instanceof CoreCredentialRecord) {
            CoreCredentialRecord coreCredentialRecord = (CoreCredentialRecord)authenticator;
            coreCredentialRecord.setBackedUp(authenticatorData.isFlagBS());
            Boolean uvInitializedRecord = coreCredentialRecord.isUvInitialized();
            if (Objects.isNull(uvInitializedRecord) || Boolean.FALSE.equals(uvInitializedRecord)) {
                coreCredentialRecord.setUvInitialized(authenticatorData.isFlagUV());
            }
        }
    }

    public DefaultMaliciousCounterValueAsyncHandler getMaliciousCounterValueAsyncHandler() {
        return this.maliciousCounterValueAsyncHandler;
    }

    public void setMaliciousCounterValueAsyncHandler(DefaultMaliciousCounterValueAsyncHandler maliciousCounterValueAsyncHandler) {
        this.maliciousCounterValueAsyncHandler = maliciousCounterValueAsyncHandler;
    }

    public OriginAsyncVerifier getOriginAsyncVerifier() {
        return this.originAsyncVerifier;
    }

    public void setOriginAsyncVerifier(OriginAsyncVerifier originAsyncVerifier) {
        this.originAsyncVerifier = originAsyncVerifier;
    }

    public List<CustomAuthenticationAsyncVerifier> getCustomAuthenticationAsyncVerifiers() {
        return this.customAuthenticationAsyncVerifiers;
    }

    @Deprecated
    public boolean isCrossOriginAllowed() {
        return !this.topOriginVerifier.isForceBlockCrossOrigin();
    }

    @Deprecated
    public void setCrossOriginAllowed(boolean crossOriginAllowed) {
        this.topOriginVerifier.setForceBlockCrossOrigin(!crossOriginAllowed);
    }

    private class AuthenticationDataVerification {
        private final AuthenticationData authenticationData;
        private final AuthenticationParameters authenticationParameters;
        private AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData;
        private AuthenticationObject authenticationObject;
        private CollectedClientData collectedClientData;
        private ServerProperty serverProperty;
        private Authenticator authenticator;

        private AuthenticationDataVerification(AuthenticationData authenticationData, AuthenticationParameters authenticationParameters) {
            this.authenticationData = authenticationData;
            this.authenticationParameters = authenticationParameters;
        }

        public CompletionStage<AuthenticationData> execute() {
            return this.execStep1toStep14().thenCompose(unused -> this.execStep15toStep20()).thenCompose(unused -> this.execStep21()).thenCompose(unused -> this.execStep22toStep24()).thenCompose(unused -> this.execStep25toStep27()).thenApply(unused -> this.authenticationData);
        }

        private CompletionStage<Void> execStep1toStep14() {
            BeanAssertUtil.validate((AuthenticationData)this.authenticationData);
            AssertUtil.notNull((Object)this.authenticationParameters, (String)"authenticationParameters must not be null");
            AuthenticationExtensionsClientOutputs clientExtensions = this.authenticationData.getClientExtensions();
            byte[] credentialId = this.authenticationData.getCredentialId();
            List allowCredentials = this.authenticationParameters.getAllowCredentials();
            CredentialIdVerifier.verify((byte[])credentialId, (List)allowCredentials);
            byte[] cData = this.authenticationData.getCollectedClientDataBytes();
            byte[] aData = this.authenticationData.getAuthenticatorDataBytes();
            this.collectedClientData = this.authenticationData.getCollectedClientData();
            this.authenticatorData = this.authenticationData.getAuthenticatorData();
            this.serverProperty = this.authenticationParameters.getServerProperty();
            BeanAssertUtil.validate((CollectedClientData)this.collectedClientData);
            BeanAssertUtil.validate(this.authenticatorData);
            if (this.authenticatorData.getAttestedCredentialData() != null) {
                throw new ConstraintViolationException("attestedCredentialData must be null on authentication");
            }
            this.authenticator = this.authenticationParameters.getAuthenticator();
            this.authenticationObject = new AuthenticationObject(credentialId, this.authenticatorData, aData, this.collectedClientData, cData, clientExtensions, this.serverProperty, this.authenticator);
            if (!Objects.equals(this.collectedClientData.getType(), ClientDataType.WEBAUTHN_GET)) {
                throw new InconsistentClientDataTypeException("ClientData.type must be 'get' on authentication, but it isn't.");
            }
            ChallengeVerifier.verify((CollectedClientData)this.collectedClientData, (ServerProperty)this.serverProperty);
            return AuthenticationDataAsyncVerifier.this.originAsyncVerifier.verify(this.authenticationObject);
        }

        private CompletionStage<Void> execStep15toStep20() {
            AuthenticationDataAsyncVerifier.this.topOriginVerifier.verify(this.authenticationObject);
            TokenBindingVerifier.verify((TokenBinding)this.collectedClientData.getTokenBinding(), (byte[])this.serverProperty.getTokenBindingId());
            RpIdHashVerifier.verify((byte[])this.authenticatorData.getRpIdHash(), (CoreServerProperty)this.serverProperty);
            UPUVFlagsVerifier.verify(this.authenticatorData, (boolean)this.authenticationParameters.isUserPresenceRequired(), (boolean)this.authenticationParameters.isUserVerificationRequired());
            BEBSFlagsVerifier.verify(this.authenticatorData);
            BEFlagVerifier.verify((Authenticator)this.authenticator, this.authenticatorData);
            return CompletableFuture.completedFuture(null);
        }

        private CompletionStage<Void> execStep21() {
            AuthenticationExtensionsClientOutputs clientExtensions = this.authenticationData.getClientExtensions();
            AuthenticationExtensionsAuthenticatorOutputs authenticatorExtensions = this.authenticatorData.getExtensions();
            return AuthenticationDataAsyncVerifier.this.clientExtensionAsyncVerifier.verify(clientExtensions).thenCompose(unused -> AuthenticationDataAsyncVerifier.this.authenticatorExtensionAsyncVerifier.verify(authenticatorExtensions));
        }

        private CompletionStage<Void> execStep22toStep24() {
            AuthenticationDataAsyncVerifier.this.assertionSignatureVerifier.verify((CoreAuthenticationData)this.authenticationData, this.authenticator.getAttestedCredentialData().getCOSEKey());
            long presentedSignCount = this.authenticatorData.getSignCount();
            long storedSignCount = this.authenticator.getCounter();
            if (presentedSignCount > 0L || storedSignCount > 0L) {
                if (presentedSignCount > storedSignCount) {
                    return CompletableFuture.completedFuture(null);
                }
                return AuthenticationDataAsyncVerifier.this.maliciousCounterValueAsyncHandler.maliciousCounterValueDetected(this.authenticationObject);
            }
            return CompletableFuture.completedFuture(null);
        }

        private CompletionStage<Void> execStep25toStep27() {
            AuthenticationDataAsyncVerifier.updateRecord(this.authenticationParameters.getAuthenticator(), this.authenticatorData);
            for (CustomAuthenticationAsyncVerifier customAuthenticationAsyncVerifier : AuthenticationDataAsyncVerifier.this.customAuthenticationAsyncVerifiers) {
                customAuthenticationAsyncVerifier.verify(this.authenticationObject);
            }
            Iterator<CustomAuthenticationAsyncVerifier> iterator = AuthenticationDataAsyncVerifier.this.customAuthenticationAsyncVerifiers.iterator();
            CompletionStage<Object> completableFuture = CompletableFuture.completedFuture(null);
            while (iterator.hasNext()) {
                CustomAuthenticationAsyncVerifier customAuthenticationAsyncVerifier = iterator.next();
                completableFuture = completableFuture.thenAccept(unused -> customAuthenticationAsyncVerifier.verify(this.authenticationObject));
            }
            return CompletableFuture.completedFuture(null);
        }
    }
}

