/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.linkis.cs.persistence.persistence.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.webank.wedatasphere.linkis.cs.common.entity.enumeration.ContextScope;
import com.webank.wedatasphere.linkis.cs.common.entity.enumeration.ContextType;
import com.webank.wedatasphere.linkis.cs.common.entity.source.ContextID;
import com.webank.wedatasphere.linkis.cs.common.entity.source.ContextKey;
import com.webank.wedatasphere.linkis.cs.common.entity.source.ContextKeyValue;
import com.webank.wedatasphere.linkis.cs.common.entity.source.ContextValue;
import com.webank.wedatasphere.linkis.cs.common.exception.CSErrorException;
import com.webank.wedatasphere.linkis.cs.common.serialize.helper.ContextSerializationHelper;
import com.webank.wedatasphere.linkis.cs.common.serialize.helper.SerializationHelper;
import com.webank.wedatasphere.linkis.cs.persistence.dao.ContextMapMapper;
import com.webank.wedatasphere.linkis.cs.persistence.entity.ExtraFieldClass;
import com.webank.wedatasphere.linkis.cs.persistence.entity.PersistenceContextKey;
import com.webank.wedatasphere.linkis.cs.persistence.entity.PersistenceContextKeyValue;
import com.webank.wedatasphere.linkis.cs.persistence.entity.PersistenceContextValue;
import com.webank.wedatasphere.linkis.cs.persistence.persistence.ContextMapPersistence;
import com.webank.wedatasphere.linkis.cs.persistence.util.PersistenceUtils;
import com.webank.wedatasphere.linkis.server.BDPJettyServerHelper;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextMapPersistenceImpl
implements ContextMapPersistence {
    @Autowired
    private ContextMapMapper contextMapMapper;
    private Class<PersistenceContextKey> pKClass = PersistenceContextKey.class;
    private Class<PersistenceContextValue> pVClass = PersistenceContextValue.class;
    private Class<PersistenceContextKeyValue> pKVClass = PersistenceContextKeyValue.class;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper json = BDPJettyServerHelper.jacksonJson();
    private final SerializationHelper serialHelper = ContextSerializationHelper.getInstance();

    @Override
    public void create(ContextID contextID, ContextKeyValue kV) throws CSErrorException {
        try {
            Pair<PersistenceContextKey, ExtraFieldClass> pK = PersistenceUtils.transfer(kV.getContextKey(), this.pKClass);
            Pair<PersistenceContextValue, ExtraFieldClass> pV = PersistenceUtils.transfer(kV.getContextValue(), this.pVClass);
            Pair<PersistenceContextKeyValue, ExtraFieldClass> pKV = PersistenceUtils.transfer(kV, this.pKVClass);
            ((PersistenceContextValue)pV.getFirst()).setValueStr(this.serialHelper.serialize(kV.getContextValue().getValue()));
            ((ExtraFieldClass)pKV.getSecond()).addSub((ExtraFieldClass)pK.getSecond());
            ((ExtraFieldClass)pKV.getSecond()).addSub((ExtraFieldClass)pV.getSecond());
            ((PersistenceContextKeyValue)pKV.getFirst()).setProps(this.json.writeValueAsString(pKV.getSecond()));
            ((PersistenceContextKeyValue)pKV.getFirst()).setContextId(contextID.getContextId());
            ((PersistenceContextKeyValue)pKV.getFirst()).setContextKey((ContextKey)pK.getFirst());
            ((PersistenceContextKeyValue)pKV.getFirst()).setContextValue((ContextValue)pV.getFirst());
            this.contextMapMapper.createMap((PersistenceContextKeyValue)pKV.getFirst());
        }
        catch (JsonProcessingException e) {
            this.logger.error("writeAsJson failed:", (Throwable)e);
            throw new CSErrorException(97000, e.getMessage());
        }
    }

    @Override
    public void update(ContextID contextID, ContextKeyValue kV) throws CSErrorException {
        Pair<PersistenceContextKey, ExtraFieldClass> pK = PersistenceUtils.transfer(kV.getContextKey(), this.pKClass);
        Pair<PersistenceContextValue, ExtraFieldClass> pV = PersistenceUtils.transfer(kV.getContextValue(), this.pVClass);
        Pair<PersistenceContextKeyValue, ExtraFieldClass> pKV = PersistenceUtils.transfer(kV, this.pKVClass);
        Object value = kV.getContextValue().getValue();
        if (value != null) {
            ((PersistenceContextValue)pV.getFirst()).setValueStr(this.serialHelper.serialize(value));
        }
        ((PersistenceContextKeyValue)pKV.getFirst()).setContextKey((ContextKey)pK.getFirst());
        ((PersistenceContextKeyValue)pKV.getFirst()).setContextValue((ContextValue)pV.getFirst());
        ((PersistenceContextKeyValue)pKV.getFirst()).setContextId(contextID.getContextId());
        this.contextMapMapper.updateMap((PersistenceContextKeyValue)pKV.getFirst());
    }

    @Override
    public ContextKeyValue get(ContextID contextID, ContextKey contextKey) throws CSErrorException {
        PersistenceContextKeyValue pKV = this.contextMapMapper.getContextMap(contextID, contextKey);
        if (pKV == null) {
            return null;
        }
        return this.transfer(pKV);
    }

    private ContextKeyValue transfer(PersistenceContextKeyValue pKV) throws CSErrorException {
        try {
            PersistenceContextKey pK = (PersistenceContextKey)pKV.getContextKey();
            PersistenceContextValue pV = (PersistenceContextValue)pKV.getContextValue();
            ExtraFieldClass extraFieldClass = (ExtraFieldClass)this.json.readValue(pKV.getProps(), ExtraFieldClass.class);
            ContextKey key = (ContextKey)PersistenceUtils.transfer(extraFieldClass.getOneSub(0), pK);
            ContextValue value = (ContextValue)PersistenceUtils.transfer(extraFieldClass.getOneSub(1), pV);
            if (value != null) {
                value.setValue(this.serialHelper.deserialize(pV.getValueStr()));
            }
            ContextKeyValue kv = (ContextKeyValue)PersistenceUtils.transfer(extraFieldClass, pKV);
            kv.setContextKey(key);
            kv.setContextValue(value);
            return kv;
        }
        catch (IOException e) {
            this.logger.error("readJson failed:", (Throwable)e);
            throw new CSErrorException(97000, e.getMessage());
        }
    }

    @Override
    public List<ContextKeyValue> getAll(ContextID contextID, String key) {
        List<PersistenceContextKeyValue> pKVs = this.contextMapMapper.getAllContextMapByKey(contextID, key);
        return pKVs.stream().map(PersistenceUtils.map(this::transfer)).collect(Collectors.toList());
    }

    @Override
    public List<ContextKeyValue> getAll(ContextID contextID) {
        List<PersistenceContextKeyValue> pKVs = this.contextMapMapper.getAllContextMapByContextID(contextID);
        return pKVs.stream().map(PersistenceUtils.map(this::transfer)).collect(Collectors.toList());
    }

    @Override
    public List<ContextKeyValue> getAll(ContextID contextID, ContextScope contextScope) {
        List<PersistenceContextKeyValue> pKVs = this.contextMapMapper.getAllContextMapByScope(contextID, contextScope);
        return pKVs.stream().map(PersistenceUtils.map(this::transfer)).collect(Collectors.toList());
    }

    @Override
    public List<ContextKeyValue> getAll(ContextID contextID, ContextType contextType) {
        List<PersistenceContextKeyValue> pKVs = this.contextMapMapper.getAllContextMapByType(contextID, contextType);
        return pKVs.stream().map(PersistenceUtils.map(this::transfer)).collect(Collectors.toList());
    }

    @Override
    public void reset(ContextID contextID, ContextKey contextKey) {
    }

    @Override
    public void remove(ContextID contextID, ContextKey contextKey) {
        this.contextMapMapper.removeContextMap(contextID, contextKey);
    }

    @Override
    public void removeAll(ContextID contextID) {
        this.contextMapMapper.removeAllContextMapByContextID(contextID);
    }

    @Override
    public void removeAll(ContextID contextID, ContextType contextType) {
        this.contextMapMapper.removeAllContextMapByType(contextID, contextType);
    }

    @Override
    public void removeAll(ContextID contextID, ContextScope contextScope) {
        this.contextMapMapper.removeAllContextMapByScope(contextID, contextScope);
    }

    @Override
    public void removeByKeyPrefix(ContextID contextID, String keyPrefix) {
        this.contextMapMapper.removeByKeyPrefix(contextID, keyPrefix);
    }

    @Override
    public void removeByKeyPrefix(ContextID contextID, ContextType contextType, String keyPrefix) {
        this.contextMapMapper.removeByKeyPrefixAndContextType(contextID, contextType, keyPrefix);
    }
}

