/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker.date;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.wdullaer.materialdatetimepicker.Utils;
import com.wdullaer.materialdatetimepicker.date.DatePickerController;
import com.wdullaer.materialdatetimepicker.date.DatePickerDialog;
import com.wdullaer.materialdatetimepicker.date.MonthAdapter;
import com.wdullaer.materialdatetimepicker.date.MonthView;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public abstract class DayPickerView
extends ListView
implements AbsListView.OnScrollListener,
DatePickerDialog.OnDateChangedListener {
    private static final String TAG = "MonthFragment";
    protected static final int SCROLL_HYST_WEEKS = 2;
    protected static final int GOTO_SCROLL_DURATION = 250;
    protected static final int SCROLL_CHANGE_DELAY = 40;
    public static final int DAYS_PER_WEEK = 7;
    public static int LIST_TOP_OFFSET = -1;
    protected int mNumWeeks = 6;
    protected boolean mShowWeekNumber = false;
    protected int mDaysPerWeek = 7;
    private static SimpleDateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy", Locale.getDefault());
    protected float mFriction = 1.0f;
    protected Context mContext;
    protected Handler mHandler;
    protected MonthAdapter.CalendarDay mSelectedDay;
    protected MonthAdapter mAdapter;
    protected MonthAdapter.CalendarDay mTempDay;
    protected int mFirstDayOfWeek;
    protected CharSequence mPrevMonthName;
    protected int mCurrentMonthDisplayed;
    protected long mPreviousScrollPosition;
    protected int mPreviousScrollState = 0;
    protected int mCurrentScrollState = 0;
    private DatePickerController mController;
    private boolean mPerformingScroll;
    protected ScrollStateRunnable mScrollStateChangedRunnable = new ScrollStateRunnable();

    public DayPickerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public DayPickerView(Context context, DatePickerController controller) {
        super(context);
        this.init(context);
        this.setController(controller);
    }

    public void setController(DatePickerController controller) {
        this.mController = controller;
        this.mController.registerOnDateChangedListener(this);
        this.mSelectedDay = new MonthAdapter.CalendarDay(this.mController.getTimeZone());
        this.mTempDay = new MonthAdapter.CalendarDay(this.mController.getTimeZone());
        this.refreshAdapter();
        this.onDateChanged();
    }

    public void init(Context context) {
        this.mHandler = new Handler();
        this.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
        this.setDrawSelectorOnTop(false);
        this.mContext = context;
        this.setUpListView();
    }

    public void onChange() {
        this.refreshAdapter();
    }

    protected void refreshAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = this.createMonthAdapter(this.getContext(), this.mController);
        } else {
            this.mAdapter.setSelectedDay(this.mSelectedDay);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    public abstract MonthAdapter createMonthAdapter(Context var1, DatePickerController var2);

    protected void setUpListView() {
        this.setCacheColorHint(0);
        this.setDivider(null);
        this.setItemsCanFocus(true);
        this.setFastScrollEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.setOnScrollListener(this);
        this.setFadingEdgeLength(0);
        this.setFriction(ViewConfiguration.getScrollFriction() * this.mFriction);
    }

    public boolean goTo(MonthAdapter.CalendarDay day, boolean animate, boolean setSelected, boolean forceScroll) {
        View child;
        if (setSelected) {
            this.mSelectedDay.set(day);
        }
        this.mTempDay.set(day);
        int minMonth = this.mController.getStartDate().get(2);
        int position = (day.year - this.mController.getMinYear()) * 12 + day.month - minMonth;
        int i = 0;
        int top = 0;
        while ((child = this.getChildAt(i++)) != null) {
            top = child.getTop();
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("child at " + (i - 1) + " has top " + top));
            }
            if (top < 0) continue;
        }
        int selectedPosition = child != null ? this.getPositionForView(child) : 0;
        if (setSelected) {
            this.mAdapter.setSelectedDay(this.mSelectedDay);
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("GoTo position " + position));
        }
        if (position != selectedPosition || forceScroll) {
            this.setMonthDisplayed(this.mTempDay);
            this.mPreviousScrollState = 2;
            if (animate) {
                this.smoothScrollToPositionFromTop(position, LIST_TOP_OFFSET, 250);
                return true;
            }
            this.postSetSelection(position);
        } else if (setSelected) {
            this.setMonthDisplayed(this.mSelectedDay);
        }
        return false;
    }

    public void postSetSelection(final int position) {
        this.clearFocus();
        this.post(new Runnable(){

            @Override
            public void run() {
                DayPickerView.this.setSelection(position);
            }
        });
        this.onScrollStateChanged((AbsListView)this, 0);
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        long currScroll;
        MonthView child = (MonthView)view.getChildAt(0);
        if (child == null) {
            return;
        }
        this.mPreviousScrollPosition = currScroll = (long)(view.getFirstVisiblePosition() * child.getHeight() - child.getBottom());
        this.mPreviousScrollState = this.mCurrentScrollState;
    }

    protected void setMonthDisplayed(MonthAdapter.CalendarDay date) {
        this.mCurrentMonthDisplayed = date.month;
        this.invalidateViews();
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        this.mScrollStateChangedRunnable.doScrollStateChange(view, scrollState);
    }

    public int getMostVisiblePosition() {
        View child;
        int firstPosition = this.getFirstVisiblePosition();
        int height = this.getHeight();
        int maxDisplayedHeight = 0;
        int mostVisibleIndex = 0;
        int i = 0;
        int bottom = 0;
        while (bottom < height && (child = this.getChildAt(i)) != null) {
            bottom = child.getBottom();
            int displayedHeight = Math.min(bottom, height) - Math.max(0, child.getTop());
            if (displayedHeight > maxDisplayedHeight) {
                mostVisibleIndex = i;
                maxDisplayedHeight = displayedHeight;
            }
            ++i;
        }
        return firstPosition + mostVisibleIndex;
    }

    @Override
    public void onDateChanged() {
        this.goTo(this.mController.getSelectedDay(), false, true, true);
    }

    private MonthAdapter.CalendarDay findAccessibilityFocus() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            MonthAdapter.CalendarDay focus;
            View child = this.getChildAt(i);
            if (!(child instanceof MonthView) || (focus = ((MonthView)child).getAccessibilityFocus()) == null) continue;
            if (Build.VERSION.SDK_INT == 17) {
                ((MonthView)child).clearAccessibilityFocus();
            }
            return focus;
        }
        return null;
    }

    private boolean restoreAccessibilityFocus(MonthAdapter.CalendarDay day) {
        if (day == null) {
            return false;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!(child instanceof MonthView) || !((MonthView)child).restoreAccessibilityFocus(day)) continue;
            return true;
        }
        return false;
    }

    protected void layoutChildren() {
        MonthAdapter.CalendarDay focusedDay = this.findAccessibilityFocus();
        super.layoutChildren();
        if (this.mPerformingScroll) {
            this.mPerformingScroll = false;
        } else {
            this.restoreAccessibilityFocus(focusedDay);
        }
    }

    public void onInitializeAccessibilityEvent(@NonNull AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setItemCount(-1);
    }

    private static String getMonthAndYearString(MonthAdapter.CalendarDay day) {
        Calendar cal = Calendar.getInstance();
        cal.set(day.year, day.month, day.day);
        String sbuf = "";
        sbuf = sbuf + cal.getDisplayName(2, 2, Locale.getDefault());
        sbuf = sbuf + " ";
        sbuf = sbuf + YEAR_FORMAT.format(cal.getTime());
        return sbuf;
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        if (Build.VERSION.SDK_INT >= 21) {
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
        } else {
            info.addAction(4096);
            info.addAction(8192);
        }
    }

    @SuppressLint(value={"NewApi"})
    public boolean performAccessibilityAction(int action, Bundle arguments) {
        View firstVisibleView;
        if (action != 4096 && action != 8192) {
            return super.performAccessibilityAction(action, arguments);
        }
        int firstVisiblePosition = this.getFirstVisiblePosition();
        int minMonth = this.mController.getStartDate().get(2);
        int month = (firstVisiblePosition + minMonth) % 12;
        int year = (firstVisiblePosition + minMonth) / 12 + this.mController.getMinYear();
        MonthAdapter.CalendarDay day = new MonthAdapter.CalendarDay(year, month, 1);
        if (action == 4096) {
            ++day.month;
            if (day.month == 12) {
                day.month = 0;
                ++day.year;
            }
        } else if (action == 8192 && (firstVisibleView = this.getChildAt(0)) != null && firstVisibleView.getTop() >= -1) {
            --day.month;
            if (day.month == -1) {
                day.month = 11;
                --day.year;
            }
        }
        Utils.tryAccessibilityAnnounce((View)this, DayPickerView.getMonthAndYearString(day));
        this.goTo(day, true, false, true);
        this.mPerformingScroll = true;
        return true;
    }

    protected class ScrollStateRunnable
    implements Runnable {
        private int mNewState;

        protected ScrollStateRunnable() {
        }

        public void doScrollStateChange(AbsListView view, int scrollState) {
            DayPickerView.this.mHandler.removeCallbacks((Runnable)this);
            this.mNewState = scrollState;
            DayPickerView.this.mHandler.postDelayed((Runnable)this, 40L);
        }

        @Override
        public void run() {
            DayPickerView.this.mCurrentScrollState = this.mNewState;
            if (Log.isLoggable((String)DayPickerView.TAG, (int)3)) {
                Log.d((String)DayPickerView.TAG, (String)("new scroll state: " + this.mNewState + " old state: " + DayPickerView.this.mPreviousScrollState));
            }
            if (this.mNewState == 0 && DayPickerView.this.mPreviousScrollState != 0 && DayPickerView.this.mPreviousScrollState != 1) {
                DayPickerView.this.mPreviousScrollState = this.mNewState;
                int i = 0;
                View child = DayPickerView.this.getChildAt(i);
                while (child != null && child.getBottom() <= 0) {
                    child = DayPickerView.this.getChildAt(++i);
                }
                if (child == null) {
                    return;
                }
                int firstPosition = DayPickerView.this.getFirstVisiblePosition();
                int lastPosition = DayPickerView.this.getLastVisiblePosition();
                boolean scroll = firstPosition != 0 && lastPosition != DayPickerView.this.getCount() - 1;
                int top = child.getTop();
                int bottom = child.getBottom();
                int midpoint = DayPickerView.this.getHeight() / 2;
                if (scroll && top < LIST_TOP_OFFSET) {
                    if (bottom > midpoint) {
                        DayPickerView.this.smoothScrollBy(top, 250);
                    } else {
                        DayPickerView.this.smoothScrollBy(bottom, 250);
                    }
                }
            } else {
                DayPickerView.this.mPreviousScrollState = this.mNewState;
            }
        }
    }
}

