/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker.time;

import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.wdullaer.materialdatetimepicker.HapticFeedbackController;
import com.wdullaer.materialdatetimepicker.R;
import com.wdullaer.materialdatetimepicker.TypefaceHelper;
import com.wdullaer.materialdatetimepicker.Utils;
import com.wdullaer.materialdatetimepicker.time.RadialPickerLayout;
import com.wdullaer.materialdatetimepicker.time.TimePickerController;
import com.wdullaer.materialdatetimepicker.time.Timepoint;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class TimePickerDialog
extends DialogFragment
implements RadialPickerLayout.OnValueSelectedListener,
TimePickerController {
    private static final String TAG = "TimePickerDialog";
    private static final String KEY_INITIAL_TIME = "initial_time";
    private static final String KEY_IS_24_HOUR_VIEW = "is_24_hour_view";
    private static final String KEY_TITLE = "dialog_title";
    private static final String KEY_CURRENT_ITEM_SHOWING = "current_item_showing";
    private static final String KEY_IN_KB_MODE = "in_kb_mode";
    private static final String KEY_TYPED_TIMES = "typed_times";
    private static final String KEY_THEME_DARK = "theme_dark";
    private static final String KEY_THEME_DARK_CHANGED = "theme_dark_changed";
    private static final String KEY_ACCENT = "accent";
    private static final String KEY_VIBRATE = "vibrate";
    private static final String KEY_DISMISS = "dismiss";
    private static final String KEY_SELECTABLE_TIMES = "selectable_times";
    private static final String KEY_MIN_TIME = "min_time";
    private static final String KEY_MAX_TIME = "max_time";
    private static final String KEY_ENABLE_SECONDS = "enable_seconds";
    private static final String KEY_ENABLE_MINUTES = "enable_minutes";
    private static final String KEY_OK_RESID = "ok_resid";
    private static final String KEY_OK_STRING = "ok_string";
    private static final String KEY_CANCEL_RESID = "cancel_resid";
    private static final String KEY_CANCEL_STRING = "cancel_string";
    public static final int HOUR_INDEX = 0;
    public static final int MINUTE_INDEX = 1;
    public static final int SECOND_INDEX = 2;
    public static final int AM = 0;
    public static final int PM = 1;
    private static final int PULSE_ANIMATOR_DELAY = 300;
    private OnTimeSetListener mCallback;
    private DialogInterface.OnCancelListener mOnCancelListener;
    private DialogInterface.OnDismissListener mOnDismissListener;
    private HapticFeedbackController mHapticFeedbackController;
    private Button mCancelButton;
    private Button mOkButton;
    private TextView mHourView;
    private TextView mHourSpaceView;
    private TextView mMinuteView;
    private TextView mMinuteSpaceView;
    private TextView mSecondView;
    private TextView mSecondSpaceView;
    private TextView mAmPmTextView;
    private View mAmPmHitspace;
    private RadialPickerLayout mTimePicker;
    private int mSelectedColor;
    private int mUnselectedColor;
    private String mAmText;
    private String mPmText;
    private boolean mAllowAutoAdvance;
    private Timepoint mInitialTime;
    private boolean mIs24HourMode;
    private String mTitle;
    private boolean mThemeDark;
    private boolean mThemeDarkChanged;
    private boolean mVibrate;
    private int mAccentColor = -1;
    private boolean mDismissOnPause;
    private Timepoint[] mSelectableTimes;
    private Timepoint mMinTime;
    private Timepoint mMaxTime;
    private boolean mEnableSeconds;
    private boolean mEnableMinutes;
    private int mOkResid;
    private String mOkString;
    private int mCancelResid;
    private String mCancelString;
    private char mPlaceholderText;
    private String mDoublePlaceholderText;
    private String mDeletedKeyFormat;
    private boolean mInKbMode;
    private ArrayList<Integer> mTypedTimes;
    private Node mLegalTimesTree;
    private int mAmKeyCode;
    private int mPmKeyCode;
    private String mHourPickerDescription;
    private String mSelectHours;
    private String mMinutePickerDescription;
    private String mSelectMinutes;
    private String mSecondPickerDescription;
    private String mSelectSeconds;

    public static TimePickerDialog newInstance(OnTimeSetListener callback, int hourOfDay, int minute, int second, boolean is24HourMode) {
        TimePickerDialog ret = new TimePickerDialog();
        ret.initialize(callback, hourOfDay, minute, second, is24HourMode);
        return ret;
    }

    public static TimePickerDialog newInstance(OnTimeSetListener callback, int hourOfDay, int minute, boolean is24HourMode) {
        return TimePickerDialog.newInstance(callback, hourOfDay, minute, 0, is24HourMode);
    }

    public void initialize(OnTimeSetListener callback, int hourOfDay, int minute, int second, boolean is24HourMode) {
        this.mCallback = callback;
        this.mInitialTime = new Timepoint(hourOfDay, minute, second);
        this.mIs24HourMode = is24HourMode;
        this.mInKbMode = false;
        this.mTitle = "";
        this.mThemeDark = false;
        this.mThemeDarkChanged = false;
        this.mAccentColor = -1;
        this.mVibrate = true;
        this.mDismissOnPause = false;
        this.mEnableSeconds = false;
        this.mEnableMinutes = true;
        this.mOkResid = R.string.mdtp_ok;
        this.mCancelResid = R.string.mdtp_cancel;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setThemeDark(boolean dark) {
        this.mThemeDark = dark;
        this.mThemeDarkChanged = true;
    }

    public void setAccentColor(String color2) {
        this.mAccentColor = Color.parseColor((String)color2);
    }

    public void setAccentColor(@ColorInt int color2) {
        this.mAccentColor = Color.argb((int)255, (int)Color.red((int)color2), (int)Color.green((int)color2), (int)Color.blue((int)color2));
    }

    @Override
    public boolean isThemeDark() {
        return this.mThemeDark;
    }

    @Override
    public boolean is24HourMode() {
        return this.mIs24HourMode;
    }

    @Override
    public int getAccentColor() {
        return this.mAccentColor;
    }

    public void vibrate(boolean vibrate) {
        this.mVibrate = vibrate;
    }

    public void dismissOnPause(boolean dismissOnPause) {
        this.mDismissOnPause = dismissOnPause;
    }

    public void enableSeconds(boolean enableSeconds) {
        if (enableSeconds) {
            this.mEnableMinutes = true;
        }
        this.mEnableSeconds = enableSeconds;
    }

    public void enableMinutes(boolean enableMinutes) {
        if (!enableMinutes) {
            this.mEnableSeconds = false;
        }
        this.mEnableMinutes = enableMinutes;
    }

    public void setMinTime(int hour, int minute, int second) {
        this.setMinTime(new Timepoint(hour, minute, second));
    }

    public void setMinTime(Timepoint minTime) {
        if (this.mMaxTime != null && minTime.compareTo(this.mMaxTime) > 0) {
            throw new IllegalArgumentException("Minimum time must be smaller than the maximum time");
        }
        this.mMinTime = minTime;
    }

    public void setMaxTime(int hour, int minute, int second) {
        this.setMaxTime(new Timepoint(hour, minute, second));
    }

    public void setMaxTime(Timepoint maxTime) {
        if (this.mMinTime != null && maxTime.compareTo(this.mMinTime) < 0) {
            throw new IllegalArgumentException("Maximum time must be greater than the minimum time");
        }
        this.mMaxTime = maxTime;
    }

    public void setSelectableTimes(Timepoint[] selectableTimes) {
        this.mSelectableTimes = selectableTimes;
        Arrays.sort(this.mSelectableTimes);
    }

    public void setTimeInterval(@IntRange(from=1L, to=24L) int hourInterval, @IntRange(from=1L, to=60L) int minuteInterval, @IntRange(from=1L, to=60L) int secondInterval) {
        ArrayList<Timepoint> timepoints = new ArrayList<Timepoint>();
        for (int hour = 0; hour < 24; hour += hourInterval) {
            for (int minute = 0; minute < 60; minute += minuteInterval) {
                for (int second = 0; second < 60; second += secondInterval) {
                    timepoints.add(new Timepoint(hour, minute, second));
                }
            }
        }
        this.setSelectableTimes(timepoints.toArray(new Timepoint[timepoints.size()]));
    }

    public void setTimeInterval(@IntRange(from=1L, to=24L) int hourInterval, @IntRange(from=1L, to=60L) int minuteInterval) {
        this.setTimeInterval(hourInterval, minuteInterval, 1);
    }

    public void setTimeInterval(@IntRange(from=1L, to=24L) int hourInterval) {
        this.setTimeInterval(hourInterval, 1);
    }

    public void setOnTimeSetListener(OnTimeSetListener callback) {
        this.mCallback = callback;
    }

    public void setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        this.mOnCancelListener = onCancelListener;
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    public void setStartTime(int hourOfDay, int minute, int second) {
        this.mInitialTime = this.roundToNearest(new Timepoint(hourOfDay, minute, second));
        this.mInKbMode = false;
    }

    public void setStartTime(int hourOfDay, int minute) {
        this.setStartTime(hourOfDay, minute, 0);
    }

    public void setOkText(String okString) {
        this.mOkString = okString;
    }

    public void setOkText(@StringRes int okResid) {
        this.mOkString = null;
        this.mOkResid = okResid;
    }

    public void setCancelText(String cancelString) {
        this.mCancelString = cancelString;
    }

    public void setCancelText(@StringRes int cancelResid) {
        this.mCancelString = null;
        this.mCancelResid = cancelResid;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null && savedInstanceState.containsKey(KEY_INITIAL_TIME) && savedInstanceState.containsKey(KEY_IS_24_HOUR_VIEW)) {
            this.mInitialTime = (Timepoint)savedInstanceState.getParcelable(KEY_INITIAL_TIME);
            this.mIs24HourMode = savedInstanceState.getBoolean(KEY_IS_24_HOUR_VIEW);
            this.mInKbMode = savedInstanceState.getBoolean(KEY_IN_KB_MODE);
            this.mTitle = savedInstanceState.getString(KEY_TITLE);
            this.mThemeDark = savedInstanceState.getBoolean(KEY_THEME_DARK);
            this.mThemeDarkChanged = savedInstanceState.getBoolean(KEY_THEME_DARK_CHANGED);
            this.mAccentColor = savedInstanceState.getInt(KEY_ACCENT);
            this.mVibrate = savedInstanceState.getBoolean(KEY_VIBRATE);
            this.mDismissOnPause = savedInstanceState.getBoolean(KEY_DISMISS);
            this.mSelectableTimes = (Timepoint[])savedInstanceState.getParcelableArray(KEY_SELECTABLE_TIMES);
            this.mMinTime = (Timepoint)savedInstanceState.getParcelable(KEY_MIN_TIME);
            this.mMaxTime = (Timepoint)savedInstanceState.getParcelable(KEY_MAX_TIME);
            this.mEnableSeconds = savedInstanceState.getBoolean(KEY_ENABLE_SECONDS);
            this.mEnableMinutes = savedInstanceState.getBoolean(KEY_ENABLE_MINUTES);
            this.mOkResid = savedInstanceState.getInt(KEY_OK_RESID);
            this.mOkString = savedInstanceState.getString(KEY_OK_STRING);
            this.mCancelResid = savedInstanceState.getInt(KEY_CANCEL_RESID);
            this.mCancelString = savedInstanceState.getString(KEY_CANCEL_STRING);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.mdtp_time_picker_dialog, container, false);
        KeyboardListener keyboardListener = new KeyboardListener();
        view.findViewById(R.id.time_picker_dialog).setOnKeyListener((View.OnKeyListener)keyboardListener);
        if (this.mAccentColor == -1) {
            this.mAccentColor = Utils.getAccentColorFromThemeIfAvailable((Context)this.getActivity());
        }
        if (!this.mThemeDarkChanged) {
            this.mThemeDark = Utils.isDarkTheme((Context)this.getActivity(), this.mThemeDark);
        }
        Resources res = this.getResources();
        Activity context = this.getActivity();
        this.mHourPickerDescription = res.getString(R.string.mdtp_hour_picker_description);
        this.mSelectHours = res.getString(R.string.mdtp_select_hours);
        this.mMinutePickerDescription = res.getString(R.string.mdtp_minute_picker_description);
        this.mSelectMinutes = res.getString(R.string.mdtp_select_minutes);
        this.mSecondPickerDescription = res.getString(R.string.mdtp_second_picker_description);
        this.mSelectSeconds = res.getString(R.string.mdtp_select_seconds);
        this.mSelectedColor = ContextCompat.getColor((Context)context, (int)R.color.mdtp_white);
        this.mUnselectedColor = ContextCompat.getColor((Context)context, (int)R.color.mdtp_accent_color_focused);
        this.mHourView = (TextView)view.findViewById(R.id.hours);
        this.mHourView.setOnKeyListener((View.OnKeyListener)keyboardListener);
        this.mHourSpaceView = (TextView)view.findViewById(R.id.hour_space);
        this.mMinuteSpaceView = (TextView)view.findViewById(R.id.minutes_space);
        this.mMinuteView = (TextView)view.findViewById(R.id.minutes);
        this.mMinuteView.setOnKeyListener((View.OnKeyListener)keyboardListener);
        this.mSecondSpaceView = (TextView)view.findViewById(R.id.seconds_space);
        this.mSecondView = (TextView)view.findViewById(R.id.seconds);
        this.mSecondView.setOnKeyListener((View.OnKeyListener)keyboardListener);
        this.mAmPmTextView = (TextView)view.findViewById(R.id.ampm_label);
        this.mAmPmTextView.setOnKeyListener((View.OnKeyListener)keyboardListener);
        String[] amPmTexts = new DateFormatSymbols().getAmPmStrings();
        this.mAmText = amPmTexts[0];
        this.mPmText = amPmTexts[1];
        this.mHapticFeedbackController = new HapticFeedbackController((Context)this.getActivity());
        if (this.mTimePicker != null) {
            this.mInitialTime = new Timepoint(this.mTimePicker.getHours(), this.mTimePicker.getMinutes(), this.mTimePicker.getSeconds());
        }
        this.mInitialTime = this.roundToNearest(this.mInitialTime);
        this.mTimePicker = (RadialPickerLayout)view.findViewById(R.id.time_picker);
        this.mTimePicker.setOnValueSelectedListener(this);
        this.mTimePicker.setOnKeyListener(keyboardListener);
        this.mTimePicker.initialize((Context)this.getActivity(), this, this.mInitialTime, this.mIs24HourMode);
        int currentItemShowing = 0;
        if (savedInstanceState != null && savedInstanceState.containsKey(KEY_CURRENT_ITEM_SHOWING)) {
            currentItemShowing = savedInstanceState.getInt(KEY_CURRENT_ITEM_SHOWING);
        }
        this.setCurrentItemShowing(currentItemShowing, false, true, true);
        this.mTimePicker.invalidate();
        this.mHourView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TimePickerDialog.this.setCurrentItemShowing(0, true, false, true);
                TimePickerDialog.this.tryVibrate();
            }
        });
        this.mMinuteView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TimePickerDialog.this.setCurrentItemShowing(1, true, false, true);
                TimePickerDialog.this.tryVibrate();
            }
        });
        this.mSecondView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TimePickerDialog.this.setCurrentItemShowing(2, true, false, true);
                TimePickerDialog.this.tryVibrate();
            }
        });
        this.mOkButton = (Button)view.findViewById(R.id.ok);
        this.mOkButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TimePickerDialog.this.mInKbMode && TimePickerDialog.this.isTypedTimeFullyLegal()) {
                    TimePickerDialog.this.finishKbMode(false);
                } else {
                    TimePickerDialog.this.tryVibrate();
                }
                TimePickerDialog.this.notifyOnDateListener();
                TimePickerDialog.this.dismiss();
            }
        });
        this.mOkButton.setOnKeyListener((View.OnKeyListener)keyboardListener);
        this.mOkButton.setTypeface(TypefaceHelper.get((Context)context, "Roboto-Medium"));
        if (this.mOkString != null) {
            this.mOkButton.setText((CharSequence)this.mOkString);
        } else {
            this.mOkButton.setText(this.mOkResid);
        }
        this.mCancelButton = (Button)view.findViewById(R.id.cancel);
        this.mCancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TimePickerDialog.this.tryVibrate();
                if (TimePickerDialog.this.getDialog() != null) {
                    TimePickerDialog.this.getDialog().cancel();
                }
            }
        });
        this.mCancelButton.setTypeface(TypefaceHelper.get((Context)context, "Roboto-Medium"));
        if (this.mCancelString != null) {
            this.mCancelButton.setText((CharSequence)this.mCancelString);
        } else {
            this.mCancelButton.setText(this.mCancelResid);
        }
        this.mCancelButton.setVisibility(this.isCancelable() ? 0 : 8);
        this.mAmPmHitspace = view.findViewById(R.id.ampm_hitspace);
        if (this.mIs24HourMode) {
            this.mAmPmTextView.setVisibility(8);
        } else {
            this.mAmPmTextView.setVisibility(0);
            this.updateAmPmDisplay(this.mInitialTime.isAM() ? 0 : 1);
            this.mAmPmHitspace.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (TimePickerDialog.this.isAmDisabled() || TimePickerDialog.this.isPmDisabled()) {
                        return;
                    }
                    TimePickerDialog.this.tryVibrate();
                    int amOrPm = TimePickerDialog.this.mTimePicker.getIsCurrentlyAmOrPm();
                    if (amOrPm == 0) {
                        amOrPm = 1;
                    } else if (amOrPm == 1) {
                        amOrPm = 0;
                    }
                    TimePickerDialog.this.mTimePicker.setAmOrPm(amOrPm);
                }
            });
        }
        if (!this.mEnableSeconds) {
            this.mSecondView.setVisibility(8);
            view.findViewById(R.id.separator_seconds).setVisibility(8);
        }
        if (!this.mEnableMinutes) {
            this.mMinuteSpaceView.setVisibility(8);
            view.findViewById(R.id.separator).setVisibility(8);
        }
        if (this.mIs24HourMode && !this.mEnableSeconds && this.mEnableMinutes) {
            RelativeLayout.LayoutParams paramsSeparator = new RelativeLayout.LayoutParams(-2, -2);
            paramsSeparator.addRule(13);
            TextView separatorView = (TextView)view.findViewById(R.id.separator);
            separatorView.setLayoutParams((ViewGroup.LayoutParams)paramsSeparator);
        } else if (!this.mEnableMinutes && !this.mEnableSeconds) {
            RelativeLayout.LayoutParams paramsHour = new RelativeLayout.LayoutParams(-2, -2);
            paramsHour.addRule(13);
            this.mHourSpaceView.setLayoutParams((ViewGroup.LayoutParams)paramsHour);
            if (!this.mIs24HourMode) {
                RelativeLayout.LayoutParams paramsAmPm = new RelativeLayout.LayoutParams(-2, -2);
                paramsAmPm.addRule(1, R.id.hour_space);
                paramsAmPm.addRule(4, R.id.hour_space);
                this.mAmPmTextView.setLayoutParams((ViewGroup.LayoutParams)paramsAmPm);
            }
        } else if (this.mEnableSeconds) {
            RelativeLayout.LayoutParams paramsMinutes;
            View separator = view.findViewById(R.id.separator);
            RelativeLayout.LayoutParams paramsSeparator = new RelativeLayout.LayoutParams(-2, -2);
            paramsSeparator.addRule(0, R.id.minutes_space);
            paramsSeparator.addRule(15, -1);
            separator.setLayoutParams((ViewGroup.LayoutParams)paramsSeparator);
            if (!this.mIs24HourMode) {
                paramsMinutes = new RelativeLayout.LayoutParams(-2, -2);
                paramsMinutes.addRule(13);
                this.mMinuteSpaceView.setLayoutParams((ViewGroup.LayoutParams)paramsMinutes);
            } else {
                paramsMinutes = new RelativeLayout.LayoutParams(-2, -2);
                paramsMinutes.addRule(1, R.id.center_view);
                this.mMinuteSpaceView.setLayoutParams((ViewGroup.LayoutParams)paramsMinutes);
            }
        }
        this.mAllowAutoAdvance = true;
        this.setHour(this.mInitialTime.getHour(), true);
        this.setMinute(this.mInitialTime.getMinute());
        this.setSecond(this.mInitialTime.getSecond());
        this.mDoublePlaceholderText = res.getString(R.string.mdtp_time_placeholder);
        this.mDeletedKeyFormat = res.getString(R.string.mdtp_deleted_key);
        this.mPlaceholderText = this.mDoublePlaceholderText.charAt(0);
        this.mPmKeyCode = -1;
        this.mAmKeyCode = -1;
        this.generateLegalTimesTree();
        if (this.mInKbMode) {
            this.mTypedTimes = savedInstanceState.getIntegerArrayList(KEY_TYPED_TIMES);
            this.tryStartingKbMode(-1);
            this.mHourView.invalidate();
        } else if (this.mTypedTimes == null) {
            this.mTypedTimes = new ArrayList();
        }
        TextView timePickerHeader = (TextView)view.findViewById(R.id.time_picker_header);
        if (!this.mTitle.isEmpty()) {
            timePickerHeader.setVisibility(0);
            timePickerHeader.setText((CharSequence)this.mTitle.toUpperCase(Locale.getDefault()));
        }
        this.mOkButton.setTextColor(this.mAccentColor);
        this.mCancelButton.setTextColor(this.mAccentColor);
        timePickerHeader.setBackgroundColor(Utils.darkenColor(this.mAccentColor));
        view.findViewById(R.id.time_display_background).setBackgroundColor(this.mAccentColor);
        view.findViewById(R.id.time_display).setBackgroundColor(this.mAccentColor);
        if (this.getDialog() == null) {
            view.findViewById(R.id.done_background).setVisibility(8);
        }
        int circleBackground = ContextCompat.getColor((Context)context, (int)R.color.mdtp_circle_background);
        int backgroundColor = ContextCompat.getColor((Context)context, (int)R.color.mdtp_background_color);
        int darkBackgroundColor = ContextCompat.getColor((Context)context, (int)R.color.mdtp_light_gray);
        int lightGray = ContextCompat.getColor((Context)context, (int)R.color.mdtp_light_gray);
        this.mTimePicker.setBackgroundColor(this.mThemeDark ? lightGray : circleBackground);
        view.findViewById(R.id.time_picker_dialog).setBackgroundColor(this.mThemeDark ? darkBackgroundColor : backgroundColor);
        return view;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        ViewGroup viewGroup = (ViewGroup)this.getView();
        if (viewGroup != null) {
            viewGroup.removeAllViewsInLayout();
            View view = this.onCreateView(this.getActivity().getLayoutInflater(), viewGroup, null);
            viewGroup.addView(view);
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.requestWindowFeature(1);
        return dialog;
    }

    public void onResume() {
        super.onResume();
        this.mHapticFeedbackController.start();
    }

    public void onPause() {
        super.onPause();
        this.mHapticFeedbackController.stop();
        if (this.mDismissOnPause) {
            this.dismiss();
        }
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        if (this.mOnCancelListener != null) {
            this.mOnCancelListener.onCancel(dialog);
        }
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }

    @Override
    public void tryVibrate() {
        if (this.mVibrate) {
            this.mHapticFeedbackController.tryVibrate();
        }
    }

    private void updateAmPmDisplay(int amOrPm) {
        if (amOrPm == 0) {
            this.mAmPmTextView.setText((CharSequence)this.mAmText);
            Utils.tryAccessibilityAnnounce((View)this.mTimePicker, this.mAmText);
            this.mAmPmHitspace.setContentDescription((CharSequence)this.mAmText);
        } else if (amOrPm == 1) {
            this.mAmPmTextView.setText((CharSequence)this.mPmText);
            Utils.tryAccessibilityAnnounce((View)this.mTimePicker, this.mPmText);
            this.mAmPmHitspace.setContentDescription((CharSequence)this.mPmText);
        } else {
            this.mAmPmTextView.setText((CharSequence)this.mDoublePlaceholderText);
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        if (this.mTimePicker != null) {
            outState.putParcelable(KEY_INITIAL_TIME, (Parcelable)this.mTimePicker.getTime());
            outState.putBoolean(KEY_IS_24_HOUR_VIEW, this.mIs24HourMode);
            outState.putInt(KEY_CURRENT_ITEM_SHOWING, this.mTimePicker.getCurrentItemShowing());
            outState.putBoolean(KEY_IN_KB_MODE, this.mInKbMode);
            if (this.mInKbMode) {
                outState.putIntegerArrayList(KEY_TYPED_TIMES, this.mTypedTimes);
            }
            outState.putString(KEY_TITLE, this.mTitle);
            outState.putBoolean(KEY_THEME_DARK, this.mThemeDark);
            outState.putBoolean(KEY_THEME_DARK_CHANGED, this.mThemeDarkChanged);
            outState.putInt(KEY_ACCENT, this.mAccentColor);
            outState.putBoolean(KEY_VIBRATE, this.mVibrate);
            outState.putBoolean(KEY_DISMISS, this.mDismissOnPause);
            outState.putParcelableArray(KEY_SELECTABLE_TIMES, (Parcelable[])this.mSelectableTimes);
            outState.putParcelable(KEY_MIN_TIME, (Parcelable)this.mMinTime);
            outState.putParcelable(KEY_MAX_TIME, (Parcelable)this.mMaxTime);
            outState.putBoolean(KEY_ENABLE_SECONDS, this.mEnableSeconds);
            outState.putBoolean(KEY_ENABLE_MINUTES, this.mEnableMinutes);
            outState.putInt(KEY_OK_RESID, this.mOkResid);
            outState.putString(KEY_OK_STRING, this.mOkString);
            outState.putInt(KEY_CANCEL_RESID, this.mCancelResid);
            outState.putString(KEY_CANCEL_STRING, this.mCancelString);
        }
    }

    @Override
    public void onValueSelected(Timepoint newValue) {
        this.setHour(newValue.getHour(), false);
        this.mTimePicker.setContentDescription(this.mHourPickerDescription + ": " + newValue.getHour());
        this.setMinute(newValue.getMinute());
        this.mTimePicker.setContentDescription(this.mMinutePickerDescription + ": " + newValue.getMinute());
        this.setSecond(newValue.getSecond());
        this.mTimePicker.setContentDescription(this.mSecondPickerDescription + ": " + newValue.getSecond());
        if (!this.mIs24HourMode) {
            this.updateAmPmDisplay(newValue.isAM() ? 0 : 1);
        }
    }

    @Override
    public void advancePicker(int index) {
        if (!this.mAllowAutoAdvance) {
            return;
        }
        if (index == 0 && this.mEnableMinutes) {
            this.setCurrentItemShowing(1, true, true, false);
            String announcement = this.mSelectHours + ". " + this.mTimePicker.getMinutes();
            Utils.tryAccessibilityAnnounce((View)this.mTimePicker, announcement);
        } else if (index == 1 && this.mEnableSeconds) {
            this.setCurrentItemShowing(2, true, true, false);
            String announcement = this.mSelectMinutes + ". " + this.mTimePicker.getSeconds();
            Utils.tryAccessibilityAnnounce((View)this.mTimePicker, announcement);
        }
    }

    @Override
    public void enablePicker() {
        if (!this.isTypedTimeFullyLegal()) {
            this.mTypedTimes.clear();
        }
        this.finishKbMode(true);
    }

    public boolean isOutOfRange(Timepoint current) {
        if (this.mMinTime != null && this.mMinTime.compareTo(current) > 0) {
            return true;
        }
        if (this.mMaxTime != null && this.mMaxTime.compareTo(current) < 0) {
            return true;
        }
        if (this.mSelectableTimes != null) {
            return !Arrays.asList(this.mSelectableTimes).contains(current);
        }
        return false;
    }

    @Override
    public boolean isOutOfRange(Timepoint current, int index) {
        if (current == null) {
            return false;
        }
        if (index == 0) {
            if (this.mMinTime != null && this.mMinTime.getHour() > current.getHour()) {
                return true;
            }
            if (this.mMaxTime != null && this.mMaxTime.getHour() + 1 <= current.getHour()) {
                return true;
            }
            if (this.mSelectableTimes != null) {
                for (Timepoint t : this.mSelectableTimes) {
                    if (t.getHour() != current.getHour()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (index == 1) {
            Timepoint roundedMax;
            Timepoint roundedMin;
            if (this.mMinTime != null && (roundedMin = new Timepoint(this.mMinTime.getHour(), this.mMinTime.getMinute())).compareTo(current) > 0) {
                return true;
            }
            if (this.mMaxTime != null && (roundedMax = new Timepoint(this.mMaxTime.getHour(), this.mMaxTime.getMinute(), 59)).compareTo(current) < 0) {
                return true;
            }
            if (this.mSelectableTimes != null) {
                for (Timepoint t : this.mSelectableTimes) {
                    if (t.getHour() != current.getHour() || t.getMinute() != current.getMinute()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return this.isOutOfRange(current);
    }

    @Override
    public boolean isAmDisabled() {
        Timepoint midday = new Timepoint(12);
        if (this.mMinTime != null && this.mMinTime.compareTo(midday) > 0) {
            return true;
        }
        if (this.mSelectableTimes != null) {
            for (Timepoint t : this.mSelectableTimes) {
                if (t.compareTo(midday) >= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isPmDisabled() {
        Timepoint midday = new Timepoint(12);
        if (this.mMaxTime != null && this.mMaxTime.compareTo(midday) < 0) {
            return true;
        }
        if (this.mSelectableTimes != null) {
            for (Timepoint t : this.mSelectableTimes) {
                if (t.compareTo(midday) < 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Timepoint roundToNearest(Timepoint time) {
        return this.roundToNearest(time, Timepoint.TYPE.HOUR);
    }

    @Override
    public Timepoint roundToNearest(Timepoint time, Timepoint.TYPE type) {
        if (this.mMinTime != null && this.mMinTime.compareTo(time) > 0) {
            return this.mMinTime;
        }
        if (this.mMaxTime != null && this.mMaxTime.compareTo(time) < 0) {
            return this.mMaxTime;
        }
        if (this.mSelectableTimes != null) {
            int currentDistance = Integer.MAX_VALUE;
            Timepoint output = time;
            for (Timepoint t : this.mSelectableTimes) {
                if (type == Timepoint.TYPE.MINUTE && t.getHour() != time.getHour() || type == Timepoint.TYPE.SECOND && t.getHour() != time.getHour() && t.getMinute() != time.getMinute()) continue;
                int newDistance = Math.abs(t.compareTo(time));
                if (newDistance >= currentDistance) break;
                currentDistance = newDistance;
                output = t;
            }
            return output;
        }
        return time;
    }

    private void setHour(int value, boolean announce) {
        String format;
        if (this.mIs24HourMode) {
            format = "%02d";
        } else {
            format = "%d";
            if ((value %= 12) == 0) {
                value = 12;
            }
        }
        String text = String.format(format, value);
        this.mHourView.setText((CharSequence)text);
        this.mHourSpaceView.setText((CharSequence)text);
        if (announce) {
            Utils.tryAccessibilityAnnounce((View)this.mTimePicker, text);
        }
    }

    private void setMinute(int value) {
        if (value == 60) {
            value = 0;
        }
        String text = String.format(Locale.getDefault(), "%02d", value);
        Utils.tryAccessibilityAnnounce((View)this.mTimePicker, text);
        this.mMinuteView.setText((CharSequence)text);
        this.mMinuteSpaceView.setText((CharSequence)text);
    }

    private void setSecond(int value) {
        if (value == 60) {
            value = 0;
        }
        String text = String.format(Locale.getDefault(), "%02d", value);
        Utils.tryAccessibilityAnnounce((View)this.mTimePicker, text);
        this.mSecondView.setText((CharSequence)text);
        this.mSecondSpaceView.setText((CharSequence)text);
    }

    private void setCurrentItemShowing(int index, boolean animateCircle, boolean delayLabelAnimate, boolean announce) {
        TextView labelToAnimate;
        this.mTimePicker.setCurrentItemShowing(index, animateCircle);
        switch (index) {
            case 0: {
                int hours = this.mTimePicker.getHours();
                if (!this.mIs24HourMode) {
                    hours %= 12;
                }
                this.mTimePicker.setContentDescription(this.mHourPickerDescription + ": " + hours);
                if (announce) {
                    Utils.tryAccessibilityAnnounce((View)this.mTimePicker, this.mSelectHours);
                }
                labelToAnimate = this.mHourView;
                break;
            }
            case 1: {
                int minutes = this.mTimePicker.getMinutes();
                this.mTimePicker.setContentDescription(this.mMinutePickerDescription + ": " + minutes);
                if (announce) {
                    Utils.tryAccessibilityAnnounce((View)this.mTimePicker, this.mSelectMinutes);
                }
                labelToAnimate = this.mMinuteView;
                break;
            }
            default: {
                int seconds = this.mTimePicker.getSeconds();
                this.mTimePicker.setContentDescription(this.mSecondPickerDescription + ": " + seconds);
                if (announce) {
                    Utils.tryAccessibilityAnnounce((View)this.mTimePicker, this.mSelectSeconds);
                }
                labelToAnimate = this.mSecondView;
            }
        }
        int hourColor = index == 0 ? this.mSelectedColor : this.mUnselectedColor;
        int minuteColor = index == 1 ? this.mSelectedColor : this.mUnselectedColor;
        int secondColor = index == 2 ? this.mSelectedColor : this.mUnselectedColor;
        this.mHourView.setTextColor(hourColor);
        this.mMinuteView.setTextColor(minuteColor);
        this.mSecondView.setTextColor(secondColor);
        ObjectAnimator pulseAnimator = Utils.getPulseAnimator((View)labelToAnimate, 0.85f, 1.1f);
        if (delayLabelAnimate) {
            pulseAnimator.setStartDelay(300L);
        }
        pulseAnimator.start();
    }

    private boolean processKeyUp(int keyCode) {
        if (keyCode == 111 || keyCode == 4) {
            if (this.isCancelable()) {
                this.dismiss();
            }
            return true;
        }
        if (keyCode == 61) {
            if (this.mInKbMode) {
                if (this.isTypedTimeFullyLegal()) {
                    this.finishKbMode(true);
                }
                return true;
            }
        } else {
            if (keyCode == 66) {
                if (this.mInKbMode) {
                    if (!this.isTypedTimeFullyLegal()) {
                        return true;
                    }
                    this.finishKbMode(false);
                }
                if (this.mCallback != null) {
                    this.mCallback.onTimeSet(this.mTimePicker, this.mTimePicker.getHours(), this.mTimePicker.getMinutes(), this.mTimePicker.getSeconds());
                }
                this.dismiss();
                return true;
            }
            if (keyCode == 67) {
                if (this.mInKbMode && !this.mTypedTimes.isEmpty()) {
                    int deleted = this.deleteLastTypedKey();
                    String deletedKeyStr = deleted == this.getAmOrPmKeyCode(0) ? this.mAmText : (deleted == this.getAmOrPmKeyCode(1) ? this.mPmText : String.format("%d", TimePickerDialog.getValFromKeyCode(deleted)));
                    Utils.tryAccessibilityAnnounce((View)this.mTimePicker, String.format(this.mDeletedKeyFormat, deletedKeyStr));
                    this.updateDisplay(true);
                }
            } else if (keyCode == 7 || keyCode == 8 || keyCode == 9 || keyCode == 10 || keyCode == 11 || keyCode == 12 || keyCode == 13 || keyCode == 14 || keyCode == 15 || keyCode == 16 || !this.mIs24HourMode && (keyCode == this.getAmOrPmKeyCode(0) || keyCode == this.getAmOrPmKeyCode(1))) {
                if (!this.mInKbMode) {
                    if (this.mTimePicker == null) {
                        Log.e((String)TAG, (String)"Unable to initiate keyboard mode, TimePicker was null.");
                        return true;
                    }
                    this.mTypedTimes.clear();
                    this.tryStartingKbMode(keyCode);
                    return true;
                }
                if (this.addKeyIfLegal(keyCode)) {
                    this.updateDisplay(false);
                }
                return true;
            }
        }
        return false;
    }

    private void tryStartingKbMode(int keyCode) {
        if (this.mTimePicker.trySettingInputEnabled(false) && (keyCode == -1 || this.addKeyIfLegal(keyCode))) {
            this.mInKbMode = true;
            this.mOkButton.setEnabled(false);
            this.updateDisplay(false);
        }
    }

    private boolean addKeyIfLegal(int keyCode) {
        int textSize = 6;
        if (this.mEnableMinutes && !this.mEnableSeconds) {
            textSize = 4;
        }
        if (!this.mEnableMinutes && !this.mEnableSeconds) {
            textSize = 2;
        }
        if (this.mIs24HourMode && this.mTypedTimes.size() == textSize || !this.mIs24HourMode && this.isTypedTimeFullyLegal()) {
            return false;
        }
        this.mTypedTimes.add(keyCode);
        if (!this.isTypedTimeLegalSoFar()) {
            this.deleteLastTypedKey();
            return false;
        }
        int val = TimePickerDialog.getValFromKeyCode(keyCode);
        Utils.tryAccessibilityAnnounce((View)this.mTimePicker, String.format("%d", val));
        if (this.isTypedTimeFullyLegal()) {
            if (!this.mIs24HourMode && this.mTypedTimes.size() <= textSize - 1) {
                this.mTypedTimes.add(this.mTypedTimes.size() - 1, 7);
                this.mTypedTimes.add(this.mTypedTimes.size() - 1, 7);
            }
            this.mOkButton.setEnabled(true);
        }
        return true;
    }

    private boolean isTypedTimeLegalSoFar() {
        Node node = this.mLegalTimesTree;
        for (int keyCode : this.mTypedTimes) {
            if ((node = node.canReach(keyCode)) != null) continue;
            return false;
        }
        return true;
    }

    private boolean isTypedTimeFullyLegal() {
        if (this.mIs24HourMode) {
            int[] values = this.getEnteredTime(null);
            return values[0] >= 0 && values[1] >= 0 && values[1] < 60 && values[2] >= 0 && values[2] < 60;
        }
        return this.mTypedTimes.contains(this.getAmOrPmKeyCode(0)) || this.mTypedTimes.contains(this.getAmOrPmKeyCode(1));
    }

    private int deleteLastTypedKey() {
        int deleted = this.mTypedTimes.remove(this.mTypedTimes.size() - 1);
        if (!this.isTypedTimeFullyLegal()) {
            this.mOkButton.setEnabled(false);
        }
        return deleted;
    }

    private void finishKbMode(boolean updateDisplays) {
        this.mInKbMode = false;
        if (!this.mTypedTimes.isEmpty()) {
            int[] values = this.getEnteredTime(null);
            this.mTimePicker.setTime(new Timepoint(values[0], values[1], values[2]));
            if (!this.mIs24HourMode) {
                this.mTimePicker.setAmOrPm(values[3]);
            }
            this.mTypedTimes.clear();
        }
        if (updateDisplays) {
            this.updateDisplay(false);
            this.mTimePicker.trySettingInputEnabled(true);
        }
    }

    private void updateDisplay(boolean allowEmptyDisplay) {
        if (!allowEmptyDisplay && this.mTypedTimes.isEmpty()) {
            int hour = this.mTimePicker.getHours();
            int minute = this.mTimePicker.getMinutes();
            int second = this.mTimePicker.getSeconds();
            this.setHour(hour, true);
            this.setMinute(minute);
            this.setSecond(second);
            if (!this.mIs24HourMode) {
                this.updateAmPmDisplay(hour < 12 ? 0 : 1);
            }
            this.setCurrentItemShowing(this.mTimePicker.getCurrentItemShowing(), true, true, true);
            this.mOkButton.setEnabled(true);
        } else {
            Boolean[] enteredZeros = new Boolean[]{false, false, false};
            int[] values = this.getEnteredTime(enteredZeros);
            String hourFormat = enteredZeros[0] != false ? "%02d" : "%2d";
            String minuteFormat = enteredZeros[1] != false ? "%02d" : "%2d";
            String secondFormat = enteredZeros[1] != false ? "%02d" : "%2d";
            String hourStr = values[0] == -1 ? this.mDoublePlaceholderText : String.format(hourFormat, values[0]).replace(' ', this.mPlaceholderText);
            String minuteStr = values[1] == -1 ? this.mDoublePlaceholderText : String.format(minuteFormat, values[1]).replace(' ', this.mPlaceholderText);
            String secondStr = values[2] == -1 ? this.mDoublePlaceholderText : String.format(secondFormat, values[1]).replace(' ', this.mPlaceholderText);
            this.mHourView.setText((CharSequence)hourStr);
            this.mHourSpaceView.setText((CharSequence)hourStr);
            this.mHourView.setTextColor(this.mUnselectedColor);
            this.mMinuteView.setText((CharSequence)minuteStr);
            this.mMinuteSpaceView.setText((CharSequence)minuteStr);
            this.mMinuteView.setTextColor(this.mUnselectedColor);
            this.mSecondView.setText((CharSequence)secondStr);
            this.mSecondSpaceView.setText((CharSequence)secondStr);
            this.mSecondView.setTextColor(this.mUnselectedColor);
            if (!this.mIs24HourMode) {
                this.updateAmPmDisplay(values[3]);
            }
        }
    }

    private static int getValFromKeyCode(int keyCode) {
        switch (keyCode) {
            case 7: {
                return 0;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 3;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 5;
            }
            case 13: {
                return 6;
            }
            case 14: {
                return 7;
            }
            case 15: {
                return 8;
            }
            case 16: {
                return 9;
            }
        }
        return -1;
    }

    private int[] getEnteredTime(Boolean[] enteredZeros) {
        int amOrPm = -1;
        int startIndex = 1;
        if (!this.mIs24HourMode && this.isTypedTimeFullyLegal()) {
            int keyCode = this.mTypedTimes.get(this.mTypedTimes.size() - 1);
            if (keyCode == this.getAmOrPmKeyCode(0)) {
                amOrPm = 0;
            } else if (keyCode == this.getAmOrPmKeyCode(1)) {
                amOrPm = 1;
            }
            startIndex = 2;
        }
        int minute = -1;
        int hour = -1;
        int second = 0;
        int shift = this.mEnableSeconds ? 2 : 0;
        for (int i = startIndex; i <= this.mTypedTimes.size(); ++i) {
            int val = TimePickerDialog.getValFromKeyCode(this.mTypedTimes.get(this.mTypedTimes.size() - i));
            if (this.mEnableSeconds) {
                if (i == startIndex) {
                    second = val;
                } else if (i == startIndex + 1) {
                    second += 10 * val;
                    if (enteredZeros != null && val == 0) {
                        enteredZeros[2] = true;
                    }
                }
            }
            if (this.mEnableMinutes) {
                if (i == startIndex + shift) {
                    minute = val;
                    continue;
                }
                if (i == startIndex + shift + 1) {
                    minute += 10 * val;
                    if (enteredZeros == null || val != 0) continue;
                    enteredZeros[1] = true;
                    continue;
                }
                if (i == startIndex + shift + 2) {
                    hour = val;
                    continue;
                }
                if (i != startIndex + shift + 3) continue;
                hour += 10 * val;
                if (enteredZeros == null || val != 0) continue;
                enteredZeros[0] = true;
                continue;
            }
            if (i == startIndex + shift) {
                hour = val;
                continue;
            }
            if (i != startIndex + shift + 1) continue;
            hour += 10 * val;
            if (enteredZeros == null || val != 0) continue;
            enteredZeros[0] = true;
        }
        return new int[]{hour, minute, second, amOrPm};
    }

    private int getAmOrPmKeyCode(int amOrPm) {
        if (this.mAmKeyCode == -1 || this.mPmKeyCode == -1) {
            KeyCharacterMap kcm = KeyCharacterMap.load((int)-1);
            for (int i = 0; i < Math.max(this.mAmText.length(), this.mPmText.length()); ++i) {
                char pmChar;
                char amChar = this.mAmText.toLowerCase(Locale.getDefault()).charAt(i);
                if (amChar == (pmChar = this.mPmText.toLowerCase(Locale.getDefault()).charAt(i))) continue;
                KeyEvent[] events = kcm.getEvents(new char[]{amChar, pmChar});
                if (events != null && events.length == 4) {
                    this.mAmKeyCode = events[0].getKeyCode();
                    this.mPmKeyCode = events[2].getKeyCode();
                    break;
                }
                Log.e((String)TAG, (String)"Unable to find keycodes for AM and PM.");
                break;
            }
        }
        if (amOrPm == 0) {
            return this.mAmKeyCode;
        }
        if (amOrPm == 1) {
            return this.mPmKeyCode;
        }
        return -1;
    }

    private void generateLegalTimesTree() {
        int k0 = 7;
        int k1 = 8;
        int k2 = 9;
        int k3 = 10;
        int k4 = 11;
        int k5 = 12;
        int k6 = 13;
        int k7 = 14;
        int k8 = 15;
        int k9 = 16;
        this.mLegalTimesTree = new Node(new int[0]);
        if (!this.mEnableMinutes && this.mIs24HourMode) {
            Node firstDigit = new Node(k0, k1);
            this.mLegalTimesTree.addChild(firstDigit);
            Node secondDigit = new Node(k0, k1, k2, k3, k4, k5, k6, k7, k8, k9);
            firstDigit.addChild(secondDigit);
            firstDigit = new Node(k2);
            this.mLegalTimesTree.addChild(firstDigit);
            secondDigit = new Node(k0, k1, k2, k3);
            firstDigit.addChild(secondDigit);
            return;
        }
        if (!this.mEnableMinutes && !this.mIs24HourMode) {
            Node ampm = new Node(this.getAmOrPmKeyCode(0), this.getAmOrPmKeyCode(1));
            Node firstDigit = new Node(k1);
            this.mLegalTimesTree.addChild(firstDigit);
            firstDigit.addChild(ampm);
            Node secondDigit = new Node(k0, k1, k2);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(ampm);
            firstDigit = new Node(k2, k3, k4, k5, k6, k7, k8, k9);
            this.mLegalTimesTree.addChild(firstDigit);
            firstDigit.addChild(ampm);
            return;
        }
        if (this.mIs24HourMode) {
            Node minuteFirstDigit = new Node(k0, k1, k2, k3, k4, k5);
            Node minuteSecondDigit = new Node(k0, k1, k2, k3, k4, k5, k6, k7, k8, k9);
            minuteFirstDigit.addChild(minuteSecondDigit);
            if (this.mEnableSeconds) {
                Node secondsFirstDigit = new Node(k0, k1, k2, k3, k4, k5);
                Node secondsSecondDigit = new Node(k0, k1, k2, k3, k4, k5, k6, k7, k8, k9);
                secondsFirstDigit.addChild(secondsSecondDigit);
                minuteSecondDigit.addChild(secondsFirstDigit);
            }
            Node firstDigit = new Node(k0, k1);
            this.mLegalTimesTree.addChild(firstDigit);
            Node secondDigit = new Node(k0, k1, k2, k3, k4, k5);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteFirstDigit);
            Node thirdDigit = new Node(k6, k7, k8, k9);
            secondDigit.addChild(thirdDigit);
            secondDigit = new Node(k6, k7, k8, k9);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteFirstDigit);
            firstDigit = new Node(k2);
            this.mLegalTimesTree.addChild(firstDigit);
            secondDigit = new Node(k0, k1, k2, k3);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteFirstDigit);
            secondDigit = new Node(k4, k5);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteSecondDigit);
            firstDigit = new Node(k3, k4, k5, k6, k7, k8, k9);
            this.mLegalTimesTree.addChild(firstDigit);
            firstDigit.addChild(minuteFirstDigit);
        } else {
            Node ampm = new Node(this.getAmOrPmKeyCode(0), this.getAmOrPmKeyCode(1));
            Node secondsFirstDigit = new Node(k0, k1, k2, k3, k4, k5);
            Node secondsSecondDigit = new Node(k0, k1, k2, k3, k4, k5, k6, k7, k8, k9);
            secondsSecondDigit.addChild(ampm);
            secondsFirstDigit.addChild(secondsSecondDigit);
            Node firstDigit = new Node(k1);
            this.mLegalTimesTree.addChild(firstDigit);
            firstDigit.addChild(ampm);
            Node secondDigit = new Node(k0, k1, k2);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(ampm);
            Node thirdDigit = new Node(k0, k1, k2, k3, k4, k5);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
            Node fourthDigit = new Node(k0, k1, k2, k3, k4, k5, k6, k7, k8, k9);
            thirdDigit.addChild(fourthDigit);
            fourthDigit.addChild(ampm);
            if (this.mEnableSeconds) {
                fourthDigit.addChild(secondsFirstDigit);
            }
            thirdDigit = new Node(k6, k7, k8, k9);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
            if (this.mEnableSeconds) {
                thirdDigit.addChild(secondsFirstDigit);
            }
            secondDigit = new Node(k3, k4, k5);
            firstDigit.addChild(secondDigit);
            thirdDigit = new Node(k0, k1, k2, k3, k4, k5, k6, k7, k8, k9);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
            if (this.mEnableSeconds) {
                thirdDigit.addChild(secondsFirstDigit);
            }
            firstDigit = new Node(k2, k3, k4, k5, k6, k7, k8, k9);
            this.mLegalTimesTree.addChild(firstDigit);
            firstDigit.addChild(ampm);
            secondDigit = new Node(k0, k1, k2, k3, k4, k5);
            firstDigit.addChild(secondDigit);
            thirdDigit = new Node(k0, k1, k2, k3, k4, k5, k6, k7, k8, k9);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
            if (this.mEnableSeconds) {
                thirdDigit.addChild(secondsFirstDigit);
            }
        }
    }

    public void notifyOnDateListener() {
        if (this.mCallback != null) {
            this.mCallback.onTimeSet(this.mTimePicker, this.mTimePicker.getHours(), this.mTimePicker.getMinutes(), this.mTimePicker.getSeconds());
        }
    }

    private class KeyboardListener
    implements View.OnKeyListener {
        private KeyboardListener() {
        }

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (event.getAction() == 1) {
                return TimePickerDialog.this.processKeyUp(keyCode);
            }
            return false;
        }
    }

    private static class Node {
        private int[] mLegalKeys;
        private ArrayList<Node> mChildren;

        public Node(int ... legalKeys) {
            this.mLegalKeys = legalKeys;
            this.mChildren = new ArrayList();
        }

        public void addChild(Node child) {
            this.mChildren.add(child);
        }

        public boolean containsKey(int key) {
            for (int legalKey : this.mLegalKeys) {
                if (legalKey != key) continue;
                return true;
            }
            return false;
        }

        public Node canReach(int key) {
            if (this.mChildren == null) {
                return null;
            }
            for (Node child : this.mChildren) {
                if (!child.containsKey(key)) continue;
                return child;
            }
            return null;
        }
    }

    public static interface OnTimeSetListener {
        public void onTimeSet(RadialPickerLayout var1, int var2, int var3, int var4);
    }
}

