/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker.time;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.View;
import com.wdullaer.materialdatetimepicker.R;
import com.wdullaer.materialdatetimepicker.time.TimePickerController;

public class CircleView
extends View {
    private static final String TAG = "CircleView";
    private final Paint mPaint = new Paint();
    private boolean mIs24HourMode;
    private int mCircleColor;
    private int mDotColor;
    private float mCircleRadiusMultiplier;
    private float mAmPmCircleRadiusMultiplier;
    private boolean mIsInitialized = false;
    private boolean mDrawValuesReady;
    private int mXCenter;
    private int mYCenter;
    private int mCircleRadius;

    public CircleView(Context context) {
        super(context);
    }

    public void initialize(Context context, TimePickerController controller) {
        if (this.mIsInitialized) {
            Log.e((String)TAG, (String)"CircleView may only be initialized once.");
            return;
        }
        Resources res = context.getResources();
        int colorRes = controller.isThemeDark() ? R.color.mdtp_circle_background_dark_theme : R.color.mdtp_circle_color;
        this.mCircleColor = ContextCompat.getColor((Context)context, (int)colorRes);
        this.mDotColor = controller.getAccentColor();
        this.mPaint.setAntiAlias(true);
        this.mIs24HourMode = controller.is24HourMode();
        if (this.mIs24HourMode) {
            this.mCircleRadiusMultiplier = Float.parseFloat(res.getString(R.string.mdtp_circle_radius_multiplier_24HourMode));
        } else {
            this.mCircleRadiusMultiplier = Float.parseFloat(res.getString(R.string.mdtp_circle_radius_multiplier));
            this.mAmPmCircleRadiusMultiplier = Float.parseFloat(res.getString(R.string.mdtp_ampm_circle_radius_multiplier));
        }
        this.mIsInitialized = true;
    }

    public void onDraw(Canvas canvas) {
        int viewWidth = this.getWidth();
        if (viewWidth == 0 || !this.mIsInitialized) {
            return;
        }
        if (!this.mDrawValuesReady) {
            this.mXCenter = this.getWidth() / 2;
            this.mYCenter = this.getHeight() / 2;
            this.mCircleRadius = (int)((float)Math.min(this.mXCenter, this.mYCenter) * this.mCircleRadiusMultiplier);
            if (!this.mIs24HourMode) {
                int amPmCircleRadius = (int)((float)this.mCircleRadius * this.mAmPmCircleRadiusMultiplier);
                this.mYCenter = (int)((double)this.mYCenter - (double)amPmCircleRadius * 0.75);
            }
            this.mDrawValuesReady = true;
        }
        this.mPaint.setColor(this.mCircleColor);
        canvas.drawCircle((float)this.mXCenter, (float)this.mYCenter, (float)this.mCircleRadius, this.mPaint);
        this.mPaint.setColor(this.mDotColor);
        canvas.drawCircle((float)this.mXCenter, (float)this.mYCenter, 8.0f, this.mPaint);
    }
}

