/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker.time;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.FrameLayout;
import com.wdullaer.materialdatetimepicker.HapticFeedbackController;
import com.wdullaer.materialdatetimepicker.R;
import com.wdullaer.materialdatetimepicker.time.AmPmCirclesView;
import com.wdullaer.materialdatetimepicker.time.CircleView;
import com.wdullaer.materialdatetimepicker.time.RadialSelectorView;
import com.wdullaer.materialdatetimepicker.time.RadialTextsView;

public class RadialPickerLayout
extends FrameLayout
implements View.OnTouchListener {
    private static final String TAG = "RadialPickerLayout";
    private final int TOUCH_SLOP;
    private final int TAP_TIMEOUT;
    private static final int VISIBLE_DEGREES_STEP_SIZE = 30;
    private static final int HOUR_VALUE_TO_DEGREES_STEP_SIZE = 30;
    private static final int MINUTE_VALUE_TO_DEGREES_STEP_SIZE = 6;
    private static final int HOUR_INDEX = 0;
    private static final int MINUTE_INDEX = 1;
    private static final int AMPM_INDEX = 2;
    private static final int ENABLE_PICKER_INDEX = 3;
    private static final int AM = 0;
    private static final int PM = 1;
    private int mLastValueSelected;
    private HapticFeedbackController mHapticFeedbackController;
    private OnValueSelectedListener mListener;
    private boolean mTimeInitialized;
    private int mCurrentHoursOfDay;
    private int mCurrentMinutes;
    private boolean mIs24HourMode;
    private boolean mHideAmPm;
    private int mCurrentItemShowing;
    private CircleView mCircleView;
    private AmPmCirclesView mAmPmCirclesView;
    private RadialTextsView mHourRadialTextsView;
    private RadialTextsView mMinuteRadialTextsView;
    private RadialSelectorView mHourRadialSelectorView;
    private RadialSelectorView mMinuteRadialSelectorView;
    private View mGrayBox;
    private int[] mSnapPrefer30sMap;
    private boolean mInputEnabled;
    private int mIsTouchingAmOrPm = -1;
    private boolean mDoingMove;
    private boolean mDoingTouch;
    private int mDownDegrees;
    private float mDownX;
    private float mDownY;
    private AccessibilityManager mAccessibilityManager;
    private AnimatorSet mTransition;
    private Handler mHandler = new Handler();

    public RadialPickerLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOnTouchListener(this);
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.TOUCH_SLOP = vc.getScaledTouchSlop();
        this.TAP_TIMEOUT = ViewConfiguration.getTapTimeout();
        this.mDoingMove = false;
        this.mCircleView = new CircleView(context);
        this.addView(this.mCircleView);
        this.mAmPmCirclesView = new AmPmCirclesView(context);
        this.addView(this.mAmPmCirclesView);
        this.mHourRadialSelectorView = new RadialSelectorView(context);
        this.addView(this.mHourRadialSelectorView);
        this.mMinuteRadialSelectorView = new RadialSelectorView(context);
        this.addView(this.mMinuteRadialSelectorView);
        this.mHourRadialTextsView = new RadialTextsView(context);
        this.addView(this.mHourRadialTextsView);
        this.mMinuteRadialTextsView = new RadialTextsView(context);
        this.addView(this.mMinuteRadialTextsView);
        this.preparePrefer30sMap();
        this.mLastValueSelected = -1;
        this.mInputEnabled = true;
        this.mGrayBox = new View(context);
        this.mGrayBox.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mGrayBox.setBackgroundColor(this.getResources().getColor(R.color.mdtp_transparent_black));
        this.mGrayBox.setVisibility(4);
        this.addView(this.mGrayBox);
        this.mAccessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        this.mTimeInitialized = false;
    }

    public void setOnValueSelectedListener(OnValueSelectedListener listener) {
        this.mListener = listener;
    }

    public void initialize(Context context, HapticFeedbackController hapticFeedbackController, int initialHoursOfDay, int initialMinutes, boolean is24HourMode) {
        if (this.mTimeInitialized) {
            Log.e((String)TAG, (String)"Time has already been initialized.");
            return;
        }
        this.mHapticFeedbackController = hapticFeedbackController;
        this.mIs24HourMode = is24HourMode;
        this.mHideAmPm = this.mAccessibilityManager.isTouchExplorationEnabled() ? true : this.mIs24HourMode;
        this.mCircleView.initialize(context, this.mHideAmPm);
        this.mCircleView.invalidate();
        if (!this.mHideAmPm) {
            this.mAmPmCirclesView.initialize(context, initialHoursOfDay < 12 ? 0 : 1);
            this.mAmPmCirclesView.invalidate();
        }
        Resources res = context.getResources();
        int[] hours = new int[]{12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        int[] hours_24 = new int[]{0, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
        int[] minutes = new int[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
        String[] hoursTexts = new String[12];
        String[] innerHoursTexts = new String[12];
        String[] minutesTexts = new String[12];
        for (int i = 0; i < 12; ++i) {
            hoursTexts[i] = is24HourMode ? String.format("%02d", hours_24[i]) : String.format("%d", hours[i]);
            innerHoursTexts[i] = String.format("%d", hours[i]);
            minutesTexts[i] = String.format("%02d", minutes[i]);
        }
        this.mHourRadialTextsView.initialize(res, hoursTexts, (String[])(is24HourMode ? innerHoursTexts : null), this.mHideAmPm, true);
        this.mHourRadialTextsView.setSelection(is24HourMode ? initialHoursOfDay : initialHoursOfDay % 12);
        this.mHourRadialTextsView.invalidate();
        this.mMinuteRadialTextsView.initialize(res, minutesTexts, null, this.mHideAmPm, false);
        this.mMinuteRadialTextsView.setSelection(initialMinutes);
        this.mMinuteRadialTextsView.invalidate();
        this.setValueForItem(0, initialHoursOfDay);
        this.setValueForItem(1, initialMinutes);
        int hourDegrees = initialHoursOfDay % 12 * 30;
        this.mHourRadialSelectorView.initialize(context, this.mHideAmPm, is24HourMode, true, hourDegrees, this.isHourInnerCircle(initialHoursOfDay));
        int minuteDegrees = initialMinutes * 6;
        this.mMinuteRadialSelectorView.initialize(context, this.mHideAmPm, false, false, minuteDegrees, false);
        this.mTimeInitialized = true;
    }

    void setTheme(Context context, boolean themeDark) {
        this.mCircleView.setTheme(context, themeDark);
        this.mAmPmCirclesView.setTheme(context, themeDark);
        this.mHourRadialTextsView.setTheme(context, themeDark);
        this.mMinuteRadialTextsView.setTheme(context, themeDark);
        this.mHourRadialSelectorView.setTheme(context, themeDark);
        this.mMinuteRadialSelectorView.setTheme(context, themeDark);
    }

    public void setTime(int hours, int minutes) {
        this.setItem(0, hours);
        this.setItem(1, minutes);
    }

    private void setItem(int index, int value) {
        if (index == 0) {
            this.setValueForItem(0, value);
            int hourDegrees = value % 12 * 30;
            this.mHourRadialSelectorView.setSelection(hourDegrees, this.isHourInnerCircle(value), false);
            this.mHourRadialSelectorView.invalidate();
            this.mHourRadialTextsView.setSelection(value);
            this.mHourRadialTextsView.invalidate();
        } else if (index == 1) {
            this.setValueForItem(1, value);
            int minuteDegrees = value * 6;
            this.mMinuteRadialSelectorView.setSelection(minuteDegrees, false, false);
            this.mMinuteRadialSelectorView.invalidate();
            this.mMinuteRadialTextsView.setSelection(value);
            this.mHourRadialTextsView.invalidate();
        }
    }

    private boolean isHourInnerCircle(int hourOfDay) {
        return this.mIs24HourMode && hourOfDay <= 12 && hourOfDay != 0;
    }

    public int getHours() {
        return this.mCurrentHoursOfDay;
    }

    public int getMinutes() {
        return this.mCurrentMinutes;
    }

    private int getCurrentlyShowingValue() {
        int currentIndex = this.getCurrentItemShowing();
        if (currentIndex == 0) {
            return this.mCurrentHoursOfDay;
        }
        if (currentIndex == 1) {
            return this.mCurrentMinutes;
        }
        return -1;
    }

    public int getIsCurrentlyAmOrPm() {
        if (this.mCurrentHoursOfDay < 12) {
            return 0;
        }
        if (this.mCurrentHoursOfDay < 24) {
            return 1;
        }
        return -1;
    }

    private void setValueForItem(int index, int value) {
        if (index == 0) {
            this.mCurrentHoursOfDay = value;
        } else if (index == 1) {
            this.mCurrentMinutes = value;
        } else if (index == 2) {
            if (value == 0) {
                this.mCurrentHoursOfDay %= 12;
            } else if (value == 1) {
                this.mCurrentHoursOfDay = this.mCurrentHoursOfDay % 12 + 12;
            }
        }
    }

    public void setAmOrPm(int amOrPm) {
        this.mAmPmCirclesView.setAmOrPm(amOrPm);
        this.mAmPmCirclesView.invalidate();
        this.setValueForItem(2, amOrPm);
    }

    private void preparePrefer30sMap() {
        this.mSnapPrefer30sMap = new int[361];
        int snappedOutputDegrees = 0;
        int count = 1;
        int expectedCount = 8;
        for (int degrees = 0; degrees < 361; ++degrees) {
            this.mSnapPrefer30sMap[degrees] = snappedOutputDegrees;
            if (count == expectedCount) {
                expectedCount = (snappedOutputDegrees += 6) == 360 ? 7 : (snappedOutputDegrees % 30 == 0 ? 14 : 4);
                count = 1;
                continue;
            }
            ++count;
        }
    }

    private int snapPrefer30s(int degrees) {
        if (this.mSnapPrefer30sMap == null) {
            return -1;
        }
        return this.mSnapPrefer30sMap[degrees];
    }

    private static int snapOnly30s(int degrees, int forceHigherOrLower) {
        int stepSize = 30;
        int floor = degrees / stepSize * stepSize;
        int ceiling = floor + stepSize;
        if (forceHigherOrLower == 1) {
            degrees = ceiling;
        } else if (forceHigherOrLower == -1) {
            if (degrees == floor) {
                floor -= stepSize;
            }
            degrees = floor;
        } else {
            degrees = degrees - floor < ceiling - degrees ? floor : ceiling;
        }
        return degrees;
    }

    private int reselectSelector(int degrees, boolean isInnerCircle, boolean forceToVisibleValue, boolean forceDrawDot) {
        int stepSize;
        RadialSelectorView radialSelectorView;
        if (degrees == -1) {
            return -1;
        }
        int currentShowing = this.getCurrentItemShowing();
        boolean allowFineGrained = !forceToVisibleValue && currentShowing == 1;
        degrees = allowFineGrained ? this.snapPrefer30s(degrees) : RadialPickerLayout.snapOnly30s(degrees, 0);
        if (currentShowing == 0) {
            radialSelectorView = this.mHourRadialSelectorView;
            stepSize = 30;
        } else {
            radialSelectorView = this.mMinuteRadialSelectorView;
            stepSize = 6;
        }
        radialSelectorView.setSelection(degrees, isInnerCircle, forceDrawDot);
        radialSelectorView.invalidate();
        if (currentShowing == 0) {
            if (this.mIs24HourMode) {
                if (degrees == 0 && isInnerCircle) {
                    degrees = 360;
                } else if (degrees == 360 && !isInnerCircle) {
                    degrees = 0;
                }
            } else if (degrees == 0) {
                degrees = 360;
            }
        } else if (degrees == 360 && currentShowing == 1) {
            degrees = 0;
        }
        int value = degrees / stepSize;
        if (currentShowing == 0 && this.mIs24HourMode && !isInnerCircle && degrees != 0) {
            value += 12;
        }
        if (this.getCurrentItemShowing() == 0) {
            this.mHourRadialTextsView.setSelection(value);
            this.mHourRadialTextsView.invalidate();
        } else if (this.getCurrentItemShowing() == 1) {
            this.mMinuteRadialTextsView.setSelection(value);
            this.mMinuteRadialTextsView.invalidate();
        }
        return value;
    }

    private int getDegreesFromCoords(float pointX, float pointY, boolean forceLegal, Boolean[] isInnerCircle) {
        int currentItem = this.getCurrentItemShowing();
        if (currentItem == 0) {
            return this.mHourRadialSelectorView.getDegreesFromCoords(pointX, pointY, forceLegal, isInnerCircle);
        }
        if (currentItem == 1) {
            return this.mMinuteRadialSelectorView.getDegreesFromCoords(pointX, pointY, forceLegal, isInnerCircle);
        }
        return -1;
    }

    public int getCurrentItemShowing() {
        if (this.mCurrentItemShowing != 0 && this.mCurrentItemShowing != 1) {
            Log.e((String)TAG, (String)("Current item showing was unfortunately set to " + this.mCurrentItemShowing));
            return -1;
        }
        return this.mCurrentItemShowing;
    }

    public void setCurrentItemShowing(int index, boolean animate) {
        if (index != 0 && index != 1) {
            Log.e((String)TAG, (String)("TimePicker does not support view at index " + index));
            return;
        }
        int lastIndex = this.getCurrentItemShowing();
        this.mCurrentItemShowing = index;
        if (animate && index != lastIndex) {
            ObjectAnimator[] anims = new ObjectAnimator[4];
            if (index == 1) {
                anims[0] = this.mHourRadialTextsView.getDisappearAnimator();
                anims[1] = this.mHourRadialSelectorView.getDisappearAnimator();
                anims[2] = this.mMinuteRadialTextsView.getReappearAnimator();
                anims[3] = this.mMinuteRadialSelectorView.getReappearAnimator();
            } else if (index == 0) {
                anims[0] = this.mHourRadialTextsView.getReappearAnimator();
                anims[1] = this.mHourRadialSelectorView.getReappearAnimator();
                anims[2] = this.mMinuteRadialTextsView.getDisappearAnimator();
                anims[3] = this.mMinuteRadialSelectorView.getDisappearAnimator();
            }
            if (this.mTransition != null && this.mTransition.isRunning()) {
                this.mTransition.end();
            }
            this.mTransition = new AnimatorSet();
            this.mTransition.playTogether((Animator[])anims);
            this.mTransition.start();
        } else {
            int hourAlpha = index == 0 ? 255 : 0;
            int minuteAlpha = index == 1 ? 255 : 0;
            this.mHourRadialTextsView.setAlpha(hourAlpha);
            this.mHourRadialSelectorView.setAlpha(hourAlpha);
            this.mMinuteRadialTextsView.setAlpha(minuteAlpha);
            this.mMinuteRadialSelectorView.setAlpha(minuteAlpha);
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        float eventX = event.getX();
        float eventY = event.getY();
        final Boolean[] isInnerCircle = new Boolean[]{false};
        switch (event.getAction()) {
            case 0: {
                if (!this.mInputEnabled) {
                    return true;
                }
                this.mDownX = eventX;
                this.mDownY = eventY;
                this.mLastValueSelected = -1;
                this.mDoingMove = false;
                this.mDoingTouch = true;
                this.mIsTouchingAmOrPm = !this.mHideAmPm ? this.mAmPmCirclesView.getIsTouchingAmOrPm(eventX, eventY) : -1;
                if (this.mIsTouchingAmOrPm == 0 || this.mIsTouchingAmOrPm == 1) {
                    this.mHapticFeedbackController.tryVibrate();
                    this.mDownDegrees = -1;
                    this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            RadialPickerLayout.this.mAmPmCirclesView.setAmOrPmPressed(RadialPickerLayout.this.mIsTouchingAmOrPm);
                            RadialPickerLayout.this.mAmPmCirclesView.invalidate();
                        }
                    }, (long)this.TAP_TIMEOUT);
                } else {
                    boolean forceLegal = this.mAccessibilityManager.isTouchExplorationEnabled();
                    this.mDownDegrees = this.getDegreesFromCoords(eventX, eventY, forceLegal, isInnerCircle);
                    if (this.mDownDegrees != -1) {
                        this.mHapticFeedbackController.tryVibrate();
                        this.mHandler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                RadialPickerLayout.this.mDoingMove = true;
                                int value = RadialPickerLayout.this.reselectSelector(RadialPickerLayout.this.mDownDegrees, isInnerCircle[0], false, true);
                                RadialPickerLayout.this.mLastValueSelected = value;
                                RadialPickerLayout.this.mListener.onValueSelected(RadialPickerLayout.this.getCurrentItemShowing(), value, false);
                            }
                        }, (long)this.TAP_TIMEOUT);
                    }
                }
                return true;
            }
            case 2: {
                int value;
                if (!this.mInputEnabled) {
                    Log.e((String)TAG, (String)"Input was disabled, but received ACTION_MOVE.");
                    return true;
                }
                float dY = Math.abs(eventY - this.mDownY);
                float dX = Math.abs(eventX - this.mDownX);
                if (!this.mDoingMove && dX <= (float)this.TOUCH_SLOP && dY <= (float)this.TOUCH_SLOP) break;
                if (this.mIsTouchingAmOrPm == 0 || this.mIsTouchingAmOrPm == 1) {
                    this.mHandler.removeCallbacksAndMessages(null);
                    int isTouchingAmOrPm = this.mAmPmCirclesView.getIsTouchingAmOrPm(eventX, eventY);
                    if (isTouchingAmOrPm == this.mIsTouchingAmOrPm) break;
                    this.mAmPmCirclesView.setAmOrPmPressed(-1);
                    this.mAmPmCirclesView.invalidate();
                    this.mIsTouchingAmOrPm = -1;
                    break;
                }
                if (this.mDownDegrees == -1) break;
                this.mDoingMove = true;
                this.mHandler.removeCallbacksAndMessages(null);
                int degrees = this.getDegreesFromCoords(eventX, eventY, true, isInnerCircle);
                if (degrees != -1 && (value = this.reselectSelector(degrees, isInnerCircle[0], false, true)) != this.mLastValueSelected) {
                    this.mHapticFeedbackController.tryVibrate();
                    this.mLastValueSelected = value;
                    this.mListener.onValueSelected(this.getCurrentItemShowing(), value, false);
                }
                return true;
            }
            case 1: {
                int degrees;
                if (!this.mInputEnabled) {
                    Log.d((String)TAG, (String)"Input was disabled, but received ACTION_UP.");
                    this.mListener.onValueSelected(3, 1, false);
                    return true;
                }
                this.mHandler.removeCallbacksAndMessages(null);
                this.mDoingTouch = false;
                if (this.mIsTouchingAmOrPm == 0 || this.mIsTouchingAmOrPm == 1) {
                    int isTouchingAmOrPm = this.mAmPmCirclesView.getIsTouchingAmOrPm(eventX, eventY);
                    this.mAmPmCirclesView.setAmOrPmPressed(-1);
                    this.mAmPmCirclesView.invalidate();
                    if (isTouchingAmOrPm == this.mIsTouchingAmOrPm) {
                        this.mAmPmCirclesView.setAmOrPm(isTouchingAmOrPm);
                        if (this.getIsCurrentlyAmOrPm() != isTouchingAmOrPm) {
                            this.mListener.onValueSelected(2, this.mIsTouchingAmOrPm, false);
                            this.setValueForItem(2, isTouchingAmOrPm);
                        }
                    }
                    this.mIsTouchingAmOrPm = -1;
                    break;
                }
                if (this.mDownDegrees != -1 && (degrees = this.getDegreesFromCoords(eventX, eventY, this.mDoingMove, isInnerCircle)) != -1) {
                    int value = this.reselectSelector(degrees, isInnerCircle[0], !this.mDoingMove, false);
                    if (this.getCurrentItemShowing() == 0 && !this.mIs24HourMode) {
                        int amOrPm = this.getIsCurrentlyAmOrPm();
                        if (amOrPm == 0 && value == 12) {
                            value = 0;
                        } else if (amOrPm == 1 && value != 12) {
                            value += 12;
                        }
                    }
                    this.setValueForItem(this.getCurrentItemShowing(), value);
                    this.mListener.onValueSelected(this.getCurrentItemShowing(), value, true);
                }
                this.mDoingMove = false;
                return true;
            }
        }
        return false;
    }

    public boolean trySettingInputEnabled(boolean inputEnabled) {
        if (this.mDoingTouch && !inputEnabled) {
            return false;
        }
        this.mInputEnabled = inputEnabled;
        this.mGrayBox.setVisibility(inputEnabled ? 4 : 0);
        return true;
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.addAction(4096);
        info.addAction(8192);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        if (event.getEventType() == 32) {
            event.getText().clear();
            Time time = new Time();
            time.hour = this.getHours();
            time.minute = this.getMinutes();
            long millis = time.normalize(true);
            int flags = 1;
            if (this.mIs24HourMode) {
                flags |= 0x80;
            }
            String timeString = DateUtils.formatDateTime((Context)this.getContext(), (long)millis, (int)flags);
            event.getText().add(timeString);
            return true;
        }
        return super.dispatchPopulateAccessibilityEvent(event);
    }

    @SuppressLint(value={"NewApi"})
    public boolean performAccessibilityAction(int action, Bundle arguments) {
        if (super.performAccessibilityAction(action, arguments)) {
            return true;
        }
        int changeMultiplier = 0;
        if (action == 4096) {
            changeMultiplier = 1;
        } else if (action == 8192) {
            changeMultiplier = -1;
        }
        if (changeMultiplier != 0) {
            int value = this.getCurrentlyShowingValue();
            int stepSize = 0;
            int currentItemShowing = this.getCurrentItemShowing();
            if (currentItemShowing == 0) {
                stepSize = 30;
                value %= 12;
            } else if (currentItemShowing == 1) {
                stepSize = 6;
            }
            int degrees = value * stepSize;
            degrees = RadialPickerLayout.snapOnly30s(degrees, changeMultiplier);
            value = degrees / stepSize;
            int maxValue = 0;
            int minValue = 0;
            if (currentItemShowing == 0) {
                if (this.mIs24HourMode) {
                    maxValue = 23;
                } else {
                    maxValue = 12;
                    minValue = 1;
                }
            } else {
                maxValue = 55;
            }
            if (value > maxValue) {
                value = minValue;
            } else if (value < minValue) {
                value = maxValue;
            }
            this.setItem(currentItemShowing, value);
            this.mListener.onValueSelected(currentItemShowing, value, false);
            return true;
        }
        return false;
    }

    public static interface OnValueSelectedListener {
        public void onValueSelected(int var1, int var2, boolean var3);
    }
}

