/*
 * Decompiled with CFR 0.152.
 */
package com.wdeo3601.pdfview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.pdf.PdfRenderer;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.LruCache;
import android.util.Range;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.jakewharton.disklrucache.DiskLruCache;
import com.wdeo3601.pdfview.PDFView$WhenMappings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b#\u0018\u0000 \u007f2\u00020\u0001:\u0019\u007f\u0080\u0001\u0081\u0001\u0082\u0001\u0083\u0001\u0084\u0001\u0085\u0001\u0086\u0001\u0087\u0001\u0088\u0001\u0089\u0001\u008a\u0001\u008b\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010?\u001a\u00020@H\u0002J\b\u0010A\u001a\u00020@H\u0002J\b\u0010B\u001a\u00020@H\u0002J)\u0010C\u001a\u00020@2\u0006\u0010D\u001a\u00020\n2\u0012\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020G0F\"\u00020GH\u0002\u00a2\u0006\u0002\u0010HJ(\u0010I\u001a\u00020\u000e2\u0006\u0010J\u001a\u00020\u000e2\u0006\u0010K\u001a\u00020\u000e2\u0006\u0010L\u001a\u00020\u000e2\u0006\u0010M\u001a\u00020\u000eH\u0002J\u0010\u0010N\u001a\u00020\u00072\u0006\u0010O\u001a\u00020\u0007H\u0002J\u0010\u0010P\u001a\u00020@2\u0006\u0010Q\u001a\u00020RH\u0002J\u0010\u0010S\u001a\u00020@2\u0006\u0010Q\u001a\u00020RH\u0002J\u0010\u0010T\u001a\u00020@2\u0006\u0010Q\u001a\u00020RH\u0002J\u0010\u0010U\u001a\u00020@2\u0006\u0010Q\u001a\u00020RH\u0002J\u0010\u0010V\u001a\u00020\n2\u0006\u0010W\u001a\u00020\u0007H\u0002J\u000e\u0010X\u001a\b\u0012\u0004\u0012\u00020\u000e0YH\u0002J\u000e\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u000e0YH\u0002J\u0012\u0010[\u001a\u0004\u0018\u00010(2\u0006\u0010W\u001a\u00020\u0007H\u0002J\u0012\u0010\\\u001a\u0004\u0018\u00010(2\u0006\u0010]\u001a\u00020\nH\u0002J\u0012\u0010^\u001a\u0004\u0018\u00010(2\u0006\u0010]\u001a\u00020\nH\u0002J\u000e\u0010_\u001a\u00020@2\u0006\u0010`\u001a\u00020\fJ\u0010\u0010a\u001a\u00020\n2\u0006\u0010b\u001a\u00020\nH\u0002J\u0010\u0010c\u001a\u00020@2\u0006\u0010Q\u001a\u00020RH\u0014J\u0018\u0010d\u001a\u00020@2\u0006\u0010e\u001a\u00020\u00072\u0006\u0010f\u001a\u00020\u0007H\u0014J\u0010\u0010g\u001a\u00020\f2\u0006\u0010h\u001a\u00020iH\u0016J\u0010\u0010j\u001a\u00020\f2\u0006\u0010h\u001a\u00020iH\u0002J\u0018\u0010k\u001a\u00020@2\u0006\u0010W\u001a\u00020\u00072\u0006\u0010l\u001a\u00020(H\u0002J\u0018\u0010m\u001a\u00020@2\u0006\u0010]\u001a\u00020\n2\u0006\u0010l\u001a\u00020(H\u0002J\u0018\u0010n\u001a\u00020@2\u0006\u0010]\u001a\u00020\n2\u0006\u0010l\u001a\u00020(H\u0002J\u000e\u0010o\u001a\u00020@2\u0006\u0010p\u001a\u00020\u000eJ\u000e\u0010q\u001a\u00020@2\u0006\u0010r\u001a\u00020\u0007J\u000e\u0010s\u001a\u00020@2\u0006\u0010t\u001a\u00020/J\u000e\u0010u\u001a\u00020@2\u0006\u0010v\u001a\u00020\nJ\u000e\u0010w\u001a\u00020@2\u0006\u0010x\u001a\u00020\nJ\u0018\u0010y\u001a\u00020@2\u0006\u0010z\u001a\u00020\u000e2\u0006\u0010{\u001a\u00020\u000eH\u0002J\b\u0010|\u001a\u00020@H\u0002J\b\u0010}\u001a\u00020@H\u0002J\b\u0010~\u001a\u00020@H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\b\u0012\u0004\u0012\u0002040\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010;\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008c\u0001"}, d2={"Lcom/wdeo3601/pdfview/PDFView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "TAG", "", "mCanZoom", "", "mCanvasScale", "", "mCanvasTranslate", "Landroid/graphics/PointF;", "mCreateLoadingPagesFuture", "Ljava/util/concurrent/Future;", "mCreateScalingPagesFuture", "mCurrentPageIndex", "mDividerHeight", "mDividerPaint", "Landroid/graphics/Paint;", "mFlingAnim", "Landroid/animation/ValueAnimator;", "mGestureDetector", "Landroid/view/GestureDetector;", "getMGestureDetector", "()Landroid/view/GestureDetector;", "mGestureDetector$delegate", "Lkotlin/Lazy;", "mInitPageFramesFuture", "mLoadingPages", "", "Lcom/wdeo3601/pdfview/PDFView$DrawingPage;", "mLoadingPagesBitmapDiskCache", "Lcom/jakewharton/disklrucache/DiskLruCache;", "mLoadingPagesBitmapMemoryCache", "Landroid/util/LruCache;", "Landroid/graphics/Bitmap;", "mMaxScale", "mMinScale", "mMultiFingerCenterPointStart", "mMultiFingerDistanceStart", "mOffscreenPageLimit", "mOnPageChangedListener", "Lcom/wdeo3601/pdfview/PDFView$OnPageChangedListener;", "mPDFHandler", "Lcom/wdeo3601/pdfview/PDFView$PDFHandler;", "mPDFPaint", "mPagePlaceHolders", "Lcom/wdeo3601/pdfview/PDFView$PageRect;", "mPdfName", "mPdfRenderer", "Landroid/graphics/pdf/PdfRenderer;", "mPdfTotalHeight", "mPdfTotalWidth", "mScaleStart", "mScalingPages", "mTouchState", "Lcom/wdeo3601/pdfview/PDFView$TouchState;", "mZoomTranslateStart", "calculateCurrentPageIndex", "", "clearScalingPages", "closePdfRenderer", "debug", "message", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "distance", "x0", "x1", "y0", "y1", "dp2px", "dp", "drawEdgeDivider", "canvas", "Landroid/graphics/Canvas;", "drawLoadingPages", "drawPlaceHolderAndDivider", "drawScalingPages", "getCachedKey", "pageIndex", "getCanTranslateXRange", "Landroid/util/Range;", "getCanTranslateYRange", "getLoadingPagesBitmapFromCache", "getLoadingPagesBitmapFromMemory", "key", "getLoadingPagesBitmapToDisk", "isCanZoom", "canZoom", "md5", "value", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "onZoomTouchEvent", "putLoadingPagesBitmapToCache", "bitmap", "putLoadingPagesBitmapToDisk", "putLoadingPagesBitmapToMemory", "setMaxScale", "maxScale", "setOffscreenPageLimit", "limit", "setOnPageChangedListener", "listener", "showPdfFromPath", "filePath", "showPdfFromUrl", "fileUrl", "startFlingAnim", "distanceX", "distanceY", "stopFlingAnimIfNeeded", "submitCreateLoadingPagesTask", "submitCreateScalingPagesTask", "Companion", "CreateScalingPageBitmapTask", "DrawingPage", "InitPdfFramesTask", "OnPDFGestureListener", "OnPageChangedListener", "PDFFlingAnimUpdateListener", "PDFHandler", "PageRect", "PdfDownloadTask", "PdfFlingAnimListenerAdapter", "PdfPageToBitmapTask", "TouchState", "pdfview_release"})
public final class PDFView
extends View {
    private final String TAG;
    private PdfRenderer mPdfRenderer;
    private String mPdfName;
    private final List<PageRect> mPagePlaceHolders;
    private final List<DrawingPage> mLoadingPages;
    private List<DrawingPage> mScalingPages;
    private float mPdfTotalWidth;
    private float mPdfTotalHeight;
    private final Lazy mGestureDetector$delegate;
    private final PDFHandler mPDFHandler;
    private final Paint mPDFPaint;
    private final Paint mDividerPaint;
    private final float mDividerHeight;
    private float mCanvasScale;
    private PointF mCanvasTranslate;
    private PointF mMultiFingerCenterPointStart;
    private float mScaleStart;
    private float mMultiFingerDistanceStart;
    private PointF mZoomTranslateStart;
    private boolean mCanZoom;
    private float mMaxScale;
    private float mMinScale;
    private ValueAnimator mFlingAnim;
    private TouchState mTouchState;
    private int mCurrentPageIndex;
    private Future<?> mCreateLoadingPagesFuture;
    private Future<?> mCreateScalingPagesFuture;
    private Future<?> mInitPageFramesFuture;
    private int mOffscreenPageLimit;
    private final LruCache<String, Bitmap> mLoadingPagesBitmapMemoryCache;
    private final DiskLruCache mLoadingPagesBitmapDiskCache;
    private OnPageChangedListener mOnPageChangedListener;
    private static final ExecutorService EXECUTOR_SERVICE;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    private final GestureDetector getMGestureDetector() {
        Lazy lazy = this.mGestureDetector$delegate;
        PDFView pDFView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (GestureDetector)lazy.getValue();
    }

    public final void showPdfFromUrl(@NotNull String fileUrl) {
        Intrinsics.checkParameterIsNotNull((Object)fileUrl, (String)"fileUrl");
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            File file = new File(stringBuilder.append(context.getFilesDir()).append(File.separator).append(this.md5(fileUrl)).append(".pdf").toString());
            String filePath = file.getPath();
            if (file.exists()) {
                String string = filePath;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"filePath");
                this.showPdfFromPath(string);
            } else {
                String string = filePath;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"filePath");
                EXECUTOR_SERVICE.submit(new PdfDownloadTask(this, fileUrl, string));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void showPdfFromPath(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        try {
            File file = new File(filePath);
            ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
            this.closePdfRenderer();
            this.mPdfRenderer = new PdfRenderer(parcelFileDescriptor);
            this.mPdfName = file.getName();
            this.mInitPageFramesFuture = null;
            this.invalidate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void setOffscreenPageLimit(int limit) {
        if (limit < 1) {
            throw (Throwable)new IllegalArgumentException("limit must >= 1");
        }
        if (limit != this.mOffscreenPageLimit) {
            this.mOffscreenPageLimit = limit;
        }
    }

    public final void setOnPageChangedListener(@NotNull OnPageChangedListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.mOnPageChangedListener = listener;
    }

    public final void isCanZoom(boolean canZoom) {
        this.mCanZoom = canZoom;
    }

    public final void setMaxScale(float maxScale) {
        float f;
        float f2 = 20.0f;
        PDFView pDFView = this;
        boolean bl = false;
        pDFView.mMaxScale = f = Math.min(maxScale, f2);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int parentWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int parentHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        boolean resizeWidth = widthSpecMode != 0x40000000;
        boolean resizeHeight = heightSpecMode != 0x40000000;
        int width = parentWidth;
        int height = parentHeight;
        width = RangesKt.coerceAtLeast((int)width, (int)this.getSuggestedMinimumWidth());
        height = RangesKt.coerceAtLeast((int)height, (int)this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(width, height);
        if (this.mInitPageFramesFuture == null) {
            this.mInitPageFramesFuture = EXECUTOR_SERVICE.submit(new InitPdfFramesTask(this));
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.mPagePlaceHolders.isEmpty()) {
            return;
        }
        canvas.save();
        canvas.translate(this.mCanvasTranslate.x, this.mCanvasTranslate.y);
        canvas.scale(this.mCanvasScale, this.mCanvasScale);
        this.drawPlaceHolderAndDivider(canvas);
        this.drawLoadingPages(canvas);
        this.drawEdgeDivider(canvas);
        this.drawScalingPages(canvas);
    }

    /*
     * WARNING - void declaration
     */
    private final void drawPlaceHolderAndDivider(Canvas canvas) {
        Iterable $this$forEachIndexed$iv = this.mPagePlaceHolders;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void pageRect;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            PageRect pageRect2 = (PageRect)item$iv;
            int index = n2;
            boolean bl2 = false;
            RectF fillWidthRect = pageRect.getFillWidthRect();
            canvas.drawRect(fillWidthRect, this.mPDFPaint);
            if (index >= CollectionsKt.getLastIndex(this.mPagePlaceHolders)) continue;
            canvas.drawRect((float)this.getPaddingLeft(), fillWidthRect.bottom, (float)this.getMeasuredWidth() - (float)this.getPaddingRight(), fillWidthRect.bottom + this.mDividerHeight, this.mDividerPaint);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawLoadingPages(Canvas canvas) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.mLoadingPages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            void $this$mapTo$iv$iv;
            DrawingPage page = (DrawingPage)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = this.mScalingPages;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DrawingPage drawingPage = (DrawingPage)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Integer n = it.getPageIndex();
                collection.add(n);
            }
            boolean isScaling = ((List)destination$iv$iv2).contains(page.getPageIndex());
            PageRect pageRect = page.getPageRect();
            boolean bl3 = (pageRect != null ? pageRect.getFillWidthRect() : null) != null && page.getBitmap() != null && !isScaling;
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DrawingPage it = (DrawingPage)element$iv;
            boolean bl = false;
            PageRect pageRect = it.getPageRect();
            if (pageRect == null) {
                Intrinsics.throwNpe();
            }
            float fillWidthScale = pageRect.getFillWidthScale();
            RectF fillWidthRect = it.getPageRect().getFillWidthRect();
            canvas.save();
            canvas.translate(fillWidthRect.left, fillWidthRect.top);
            canvas.scale(fillWidthScale, fillWidthScale);
            Bitmap bitmap = it.getBitmap();
            if (bitmap == null) {
                Intrinsics.throwNpe();
            }
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.mPDFPaint);
            canvas.restore();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawScalingPages(Canvas canvas) {
        void $this$filterTo$iv$iv;
        canvas.restore();
        Iterable $this$filter$iv = this.mScalingPages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DrawingPage it = (DrawingPage)element$iv$iv;
            boolean bl = false;
            PageRect pageRect = it.getPageRect();
            if (!((pageRect != null ? pageRect.getFillWidthRect() : null) != null && it.getBitmap() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DrawingPage it = (DrawingPage)element$iv;
            boolean bl = false;
            PageRect pageRect = it.getPageRect();
            if (pageRect == null) {
                Intrinsics.throwNpe();
            }
            RectF fillWidthRect = pageRect.getFillWidthRect();
            Bitmap bitmap = it.getBitmap();
            if (bitmap == null) {
                Intrinsics.throwNpe();
            }
            canvas.drawBitmap(bitmap, fillWidthRect.left, fillWidthRect.top, this.mPDFPaint);
        }
    }

    private final void drawEdgeDivider(Canvas canvas) {
        RectF firstPageRect = ((PageRect)CollectionsKt.first(this.mPagePlaceHolders)).getFillWidthRect();
        RectF lastPageRect = ((PageRect)CollectionsKt.last(this.mPagePlaceHolders)).getFillWidthRect();
        canvas.drawRect((float)this.getPaddingLeft(), firstPageRect.top, (float)this.getPaddingLeft() + this.mDividerHeight, lastPageRect.bottom, this.mDividerPaint);
        canvas.drawRect((float)this.getWidth() - (float)this.getPaddingLeft() - this.mDividerHeight, firstPageRect.top, (float)this.getWidth() - (float)this.getPaddingLeft(), lastPageRect.bottom, this.mDividerPaint);
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.clearScalingPages();
        boolean handled = false;
        switch (event.getActionMasked()) {
            case 0: {
                this.debug("onTouchEvent-ACTION_DOWN", new Object[0]);
                this.mTouchState = TouchState.SINGLE_POINTER;
                this.stopFlingAnimIfNeeded();
                this.getMGestureDetector().onTouchEvent(event);
                handled = true;
                break;
            }
            case 5: {
                this.debug("onTouchEvent-ACTION_POINTER_DOWN", new Object[0]);
                this.mTouchState = TouchState.MULTI_POINTER;
                this.stopFlingAnimIfNeeded();
                handled = this.onZoomTouchEvent(event);
                break;
            }
            case 2: {
                boolean bl;
                this.debug("onTouchEvent-ACTION_MOVE", new Object[0]);
                switch (PDFView$WhenMappings.$EnumSwitchMapping$0[this.mTouchState.ordinal()]) {
                    case 1: {
                        bl = this.getMGestureDetector().onTouchEvent(event);
                        break;
                    }
                    case 2: {
                        bl = this.onZoomTouchEvent(event);
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                handled = bl;
                break;
            }
            case 1: {
                boolean bl;
                this.debug("onTouchEvent-ACTION_UP", new Object[0]);
                switch (PDFView$WhenMappings.$EnumSwitchMapping$1[this.mTouchState.ordinal()]) {
                    case 1: {
                        boolean isFling = this.getMGestureDetector().onTouchEvent(event);
                        if (!isFling) {
                            this.submitCreateLoadingPagesTask();
                            this.submitCreateScalingPagesTask();
                        }
                        bl = true;
                        break;
                    }
                    case 2: {
                        bl = this.onZoomTouchEvent(event);
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                handled = bl;
                this.mTouchState = TouchState.IDLE;
                break;
            }
        }
        return handled || super.onTouchEvent(event);
    }

    private final boolean onZoomTouchEvent(MotionEvent event) {
        if (!this.mCanZoom) {
            return false;
        }
        switch (event.getActionMasked()) {
            case 5: {
                this.debug("onZoomTouchEvent-ACTION_POINTER_DOWN", new Object[0]);
                this.mMultiFingerDistanceStart = this.distance(event.getX(0), event.getX(1), event.getY(0), event.getY(1));
                this.mScaleStart = this.mCanvasScale;
                this.mMultiFingerCenterPointStart.set((event.getX(0) + event.getX(1)) / (float)2, (event.getY(0) + event.getY(1)) / (float)2);
                this.mZoomTranslateStart.set(this.mCanvasTranslate);
                return this.mCanZoom;
            }
            case 2: {
                Float f;
                Float f2;
                float f3;
                float tempScale;
                this.debug("onZoomTouchEvent-ACTION_MOVE", new Object[0]);
                if (event.getPointerCount() < 2) {
                    return false;
                }
                float multiFingerDistanceEnd = this.distance(event.getX(0), event.getX(1), event.getY(0), event.getY(1));
                float f4 = tempScale = multiFingerDistanceEnd / this.mMultiFingerDistanceStart * this.mScaleStart;
                float f5 = this.mMinScale;
                float f6 = f4;
                if (f6 >= 0.0f && f6 <= f5) {
                    f3 = this.mMinScale;
                } else {
                    f5 = this.mMinScale;
                    float f7 = this.mMaxScale;
                    f6 = f4;
                    f3 = f6 >= f5 && f6 <= f7 ? tempScale : this.mMaxScale;
                }
                this.mCanvasScale = f3;
                float centerPointEndX = (event.getX(0) + event.getX(1)) / (float)2;
                float centerPointEndY = (event.getY(0) + event.getY(1)) / (float)2;
                float vLeftStart = this.mMultiFingerCenterPointStart.x - this.mZoomTranslateStart.x;
                float vTopStart = this.mMultiFingerCenterPointStart.y - this.mZoomTranslateStart.y;
                float vLeftNow = vLeftStart * (this.mCanvasScale / this.mScaleStart);
                float vTopNow = vTopStart * (this.mCanvasScale / this.mScaleStart);
                Range<Float> canTranslateXRange = this.getCanTranslateXRange();
                Range<Float> canTranslateYRange = this.getCanTranslateYRange();
                float tempTranslateX = centerPointEndX - vLeftNow;
                float tempTranslateY = centerPointEndY - vTopNow;
                if (canTranslateXRange.contains((Comparable)Float.valueOf(tempTranslateX))) {
                    f2 = Float.valueOf(tempTranslateX);
                } else {
                    Comparable comparable = canTranslateXRange.getUpper();
                    Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"canTranslateXRange.upper");
                    f2 = tempTranslateX > ((Number)((Object)comparable)).floatValue() ? (Float)canTranslateXRange.getUpper() : (Float)canTranslateXRange.getLower();
                }
                Float nextTranslateX = f2;
                if (canTranslateYRange.contains((Comparable)Float.valueOf(tempTranslateY))) {
                    f = Float.valueOf(tempTranslateY);
                } else {
                    Comparable comparable = canTranslateYRange.getUpper();
                    Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"canTranslateYRange.upper");
                    f = tempTranslateY > ((Number)((Object)comparable)).floatValue() ? (Float)canTranslateYRange.getUpper() : (Float)canTranslateYRange.getLower();
                }
                Float nextTranslateY = f;
                Float f8 = nextTranslateX;
                Intrinsics.checkExpressionValueIsNotNull((Object)f8, (String)"nextTranslateX");
                float f9 = f8.floatValue();
                Float f10 = nextTranslateY;
                Intrinsics.checkExpressionValueIsNotNull((Object)f10, (String)"nextTranslateY");
                this.mCanvasTranslate.set(f9, f10.floatValue());
                this.invalidate();
                this.calculateCurrentPageIndex();
                return true;
            }
            case 1: {
                this.debug("onZoomTouchEvent-ACTION_UP", new Object[0]);
                this.submitCreateLoadingPagesTask();
                this.submitCreateScalingPagesTask();
                return true;
            }
        }
        return false;
    }

    private final void closePdfRenderer() {
        if (this.mPdfRenderer != null) {
            PdfRenderer pdfRenderer = this.mPdfRenderer;
            if (pdfRenderer != null) {
                pdfRenderer.close();
            }
            this.mPdfRenderer = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateCurrentPageIndex() {
        float translateY = this.mCanvasTranslate.y;
        int n = 0;
        int n2 = ((Collection)this.mPagePlaceHolders).size();
        while (n < n2) {
            void index;
            RectF pageRect = this.mPagePlaceHolders.get((int)index).getFillWidthRect();
            double offset = (double)this.getMeasuredHeight() * 0.4;
            boolean bl = false;
            if ((double)Math.abs(translateY) + offset > (double)(pageRect.top * this.mCanvasScale)) {
                bl = false;
                if ((double)Math.abs(translateY) + offset <= (double)((pageRect.bottom + this.mDividerHeight) * this.mCanvasScale)) {
                    if (index != this.mCurrentPageIndex) {
                        OnPageChangedListener onPageChangedListener = this.mOnPageChangedListener;
                        if (onPageChangedListener != null) {
                            onPageChangedListener.onPageChanged((int)index, this.mPagePlaceHolders.size());
                        }
                    }
                    this.mCurrentPageIndex = index;
                    this.debug("calculateCurrentPageIndex-mCurrentPageIndex:" + this.mCurrentPageIndex, new Object[0]);
                    return;
                }
            }
            ++index;
        }
        this.debug("calculateCurrentPageIndex-LoopFinish:" + this.mCurrentPageIndex, new Object[0]);
    }

    private final void startFlingAnim(float distanceX, float distanceY) {
        ValueAnimator valueAnimator;
        float f;
        boolean bl = false;
        float f2 = f = Math.abs(distanceX);
        boolean bl2 = false;
        float f3 = f = Math.abs(distanceY);
        boolean bl3 = false;
        f = Math.max(f2, f3);
        long animDuration = (long)(f / (float)20);
        long l = animDuration;
        long l2 = l;
        if (0L <= l2 && (long)100 > l2) {
            animDuration = 400L;
        } else {
            l2 = l;
            if ((long)100 <= l2 && (long)600 > l2) {
                animDuration = 600L;
            }
        }
        this.debug("startFlingAnim--distanceX-" + distanceX + "--distanceY-" + distanceY + "--animDuration-" + animDuration, new Object[0]);
        ValueAnimator valueAnimator2 = new ValueAnimator();
        PDFView pDFView = this;
        boolean bl4 = false;
        boolean bl5 = false;
        ValueAnimator $this$apply = valueAnimator2;
        boolean bl6 = false;
        $this$apply.setFloatValues(new float[]{0.0f, 1.0f});
        $this$apply.setDuration(animDuration);
        $this$apply.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        $this$apply.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new PDFFlingAnimUpdateListener(this, distanceX, distanceY));
        $this$apply.addListener((Animator.AnimatorListener)new PdfFlingAnimListenerAdapter(this));
        $this$apply.start();
        pDFView.mFlingAnim = valueAnimator = valueAnimator2;
    }

    private final void submitCreateLoadingPagesTask() {
        Future<?> future = this.mCreateLoadingPagesFuture;
        if (future == null || !future.isDone()) {
            Future<?> future2 = this.mCreateLoadingPagesFuture;
            if (future2 != null) {
                future2.cancel(true);
            }
        }
        this.mCreateLoadingPagesFuture = EXECUTOR_SERVICE.submit(new PdfPageToBitmapTask(this));
    }

    private final void submitCreateScalingPagesTask() {
        if (this.mCanvasScale == 1.0f) {
            return;
        }
        Future<?> future = this.mCreateScalingPagesFuture;
        if (future == null || !future.isDone()) {
            Future<?> future2 = this.mCreateScalingPagesFuture;
            if (future2 != null) {
                future2.cancel(true);
            }
        }
        this.mCreateScalingPagesFuture = EXECUTOR_SERVICE.submit(new CreateScalingPageBitmapTask(this));
    }

    private final void clearScalingPages() {
        Future<?> future = this.mCreateScalingPagesFuture;
        if (future == null || !future.isDone()) {
            Future<?> future2 = this.mCreateScalingPagesFuture;
            if (future2 != null) {
                future2.cancel(true);
            }
        }
        this.mScalingPages.clear();
        this.invalidate();
    }

    private final void stopFlingAnimIfNeeded() {
        block0: {
            ValueAnimator valueAnimator = this.mFlingAnim;
            if (valueAnimator == null) break block0;
            valueAnimator.cancel();
        }
    }

    private final Range<Float> getCanTranslateXRange() {
        float f = -(this.mCanvasScale * this.mPdfTotalWidth - (float)this.getWidth());
        float f2 = 0.0f;
        boolean bl = false;
        float f3 = Math.min(f, f2);
        Comparable comparable = Float.valueOf(0.0f);
        Comparable comparable2 = Float.valueOf(f3);
        return new Range(comparable2, comparable);
    }

    private final Range<Float> getCanTranslateYRange() {
        float f = -(this.mCanvasScale * this.mPdfTotalHeight - (float)this.getHeight());
        float f2 = 0.0f;
        boolean bl = false;
        float f3 = Math.min(f, f2);
        Comparable comparable = Float.valueOf(0.0f);
        Comparable comparable2 = Float.valueOf(f3);
        return new Range(comparable2, comparable);
    }

    private final void debug(String message, Object ... args) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string = this.TAG;
        boolean bl = false;
        String string2 = String.format(message, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String string3 = string2;
        Log.d((String)string, (String)string3);
    }

    private final float distance(float x0, float x1, float y0, float y1) {
        float x = x0 - x1;
        float y = y0 - y1;
        double d = (double)(x * x) + (double)y * (double)y;
        boolean bl = false;
        return (float)Math.sqrt(d);
    }

    private final int dp2px(int dp) {
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return (int)((double)(resources.getDisplayMetrics().density * (float)dp) + 0.5);
    }

    private final Bitmap getLoadingPagesBitmapFromCache(int pageIndex) {
        String key = this.getCachedKey(pageIndex);
        Bitmap bitmap = this.getLoadingPagesBitmapFromMemory(key);
        if (bitmap == null) {
            bitmap = this.getLoadingPagesBitmapToDisk(key);
        }
        return bitmap;
    }

    private final Bitmap getLoadingPagesBitmapFromMemory(String key) {
        return (Bitmap)this.mLoadingPagesBitmapMemoryCache.get((Object)key);
    }

    private final Bitmap getLoadingPagesBitmapToDisk(String key) {
        try {
            BitmapFactory.Options options;
            DiskLruCache.Snapshot snapShot = this.mLoadingPagesBitmapDiskCache.get(key);
            if (snapShot == null) {
                return null;
            }
            InputStream inputStream = snapShot.getInputStream(0);
            if (inputStream == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.io.FileInputStream");
            }
            FileInputStream fileInputStream = (FileInputStream)inputStream;
            FileDescriptor fileDescriptor = fileInputStream.getFD();
            Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)(options = new BitmapFactory.Options()));
            if (bitmap != null) {
                this.putLoadingPagesBitmapToMemory(key, bitmap);
            }
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final void putLoadingPagesBitmapToCache(int pageIndex, Bitmap bitmap) {
        String key = this.getCachedKey(pageIndex);
        this.putLoadingPagesBitmapToMemory(key, bitmap);
        this.putLoadingPagesBitmapToDisk(key, bitmap);
    }

    private final void putLoadingPagesBitmapToMemory(String key, Bitmap bitmap) {
        this.mLoadingPagesBitmapMemoryCache.put((Object)key, (Object)bitmap);
    }

    private final void putLoadingPagesBitmapToDisk(String key, Bitmap bitmap) {
        try {
            DiskLruCache.Editor edit = this.mLoadingPagesBitmapDiskCache.edit(key);
            OutputStream outputStream = edit.newOutputStream(0);
            bitmap.compress(Bitmap.CompressFormat.WEBP, 100, outputStream);
            edit.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final String getCachedKey(int pageIndex) {
        String string;
        try {
            string = this.md5(this.mPdfName + '_' + pageIndex);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            String string2 = this.mPdfName;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string3 = string2;
            int n = string3 != null ? string3.hashCode() : 0;
            string = stringBuilder.append(n).append('_').append(pageIndex).toString();
        }
        String cacheKey = string;
        this.debug("getCachedKey--pageIndex:" + pageIndex + "--cacheKey:" + cacheKey, new Object[0]);
        return cacheKey;
    }

    private final String md5(String value) {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        String string = value;
        MessageDigest messageDigest2 = messageDigest;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        messageDigest2.update(byArray2);
        String string3 = new BigInteger(1, messageDigest.digest()).toString(16);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"BigInteger(1, messageDigest.digest()).toString(16)");
        return string3;
    }

    @JvmOverloads
    public PDFView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        String string = PDFView.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PDFView::class.java.simpleName");
        this.TAG = string;
        PDFView pDFView = this;
        boolean bl = false;
        pDFView.mPagePlaceHolders = list = (List)new ArrayList();
        pDFView = this;
        bl = false;
        pDFView.mLoadingPages = list = (List)new ArrayList();
        pDFView = this;
        bl = false;
        pDFView.mScalingPages = list = (List)new ArrayList();
        this.mGestureDetector$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GestureDetector>(this, context){
            final /* synthetic */ PDFView this$0;
            final /* synthetic */ Context $context;

            @NotNull
            public final GestureDetector invoke() {
                return new GestureDetector(this.$context, (GestureDetector.OnGestureListener)new OnPDFGestureListener(this.this$0));
            }
            {
                this.this$0 = pDFView;
                this.$context = context;
                super(0);
            }
        }));
        this.mDividerHeight = this.dp2px(8);
        this.mCanvasScale = 1.0f;
        this.mCanvasTranslate = new PointF();
        this.mMultiFingerCenterPointStart = new PointF();
        this.mScaleStart = this.mCanvasScale;
        this.mZoomTranslateStart = new PointF();
        this.mCanZoom = true;
        this.mMaxScale = 10.0f;
        this.mMinScale = 1.0f;
        this.mTouchState = TouchState.IDLE;
        this.mOffscreenPageLimit = 2;
        this.mPDFHandler = new PDFHandler(this);
        this.mLoadingPagesBitmapMemoryCache = new LruCache(this.mOffscreenPageLimit * 2 + 1);
        DiskLruCache diskLruCache = DiskLruCache.open((File)context.getCacheDir(), (int)1, (int)1, (long)0x6400000L);
        Intrinsics.checkExpressionValueIsNotNull((Object)diskLruCache, (String)"DiskLruCache.open(contex\u2026 1, 1, 1024 * 1024 * 100)");
        this.mLoadingPagesBitmapDiskCache = diskLruCache;
        this.mPDFPaint = new Paint();
        this.mPDFPaint.setColor(-1);
        this.mPDFPaint.setAntiAlias(true);
        this.mPDFPaint.setFilterBitmap(true);
        this.mPDFPaint.setDither(true);
        this.mDividerPaint = new Paint();
        this.mDividerPaint.setColor(-7829368);
        this.mDividerPaint.setAntiAlias(true);
    }

    public /* synthetic */ PDFView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public PDFView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public PDFView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        Companion = new Companion(null);
        EXECUTOR_SERVICE = Executors.newFixedThreadPool(3);
    }

    public static final /* synthetic */ float access$getMPdfTotalHeight$p(PDFView $this) {
        return $this.mPdfTotalHeight;
    }

    public static final /* synthetic */ float access$getMPdfTotalWidth$p(PDFView $this) {
        return $this.mPdfTotalWidth;
    }

    public static final /* synthetic */ void access$setMOnPageChangedListener$p(PDFView $this, OnPageChangedListener onPageChangedListener) {
        $this.mOnPageChangedListener = onPageChangedListener;
    }

    public static final /* synthetic */ void access$setMCurrentPageIndex$p(PDFView $this, int n) {
        $this.mCurrentPageIndex = n;
    }

    public static final /* synthetic */ void access$setMScalingPages$p(PDFView $this, List list) {
        $this.mScalingPages = list;
    }

    public static final /* synthetic */ void access$setMCanvasTranslate$p(PDFView $this, PointF pointF) {
        $this.mCanvasTranslate = pointF;
    }

    public static final /* synthetic */ void access$setMPdfRenderer$p(PDFView $this, PdfRenderer pdfRenderer) {
        $this.mPdfRenderer = pdfRenderer;
    }

    public static final /* synthetic */ void access$setMOffscreenPageLimit$p(PDFView $this, int n) {
        $this.mOffscreenPageLimit = n;
    }

    public static final /* synthetic */ void access$setMCanvasScale$p(PDFView $this, float f) {
        $this.mCanvasScale = f;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/wdeo3601/pdfview/PDFView$TouchState;", "", "(Ljava/lang/String;I)V", "SINGLE_POINTER", "MULTI_POINTER", "IDLE", "pdfview_release"})
    private static final class TouchState
    extends Enum<TouchState> {
        public static final /* enum */ TouchState SINGLE_POINTER;
        public static final /* enum */ TouchState MULTI_POINTER;
        public static final /* enum */ TouchState IDLE;
        private static final /* synthetic */ TouchState[] $VALUES;

        static {
            TouchState[] touchStateArray = new TouchState[3];
            TouchState[] touchStateArray2 = touchStateArray;
            touchStateArray[0] = SINGLE_POINTER = new TouchState();
            touchStateArray[1] = MULTI_POINTER = new TouchState();
            touchStateArray[2] = IDLE = new TouchState();
            $VALUES = touchStateArray;
        }

        public static TouchState[] values() {
            return (TouchState[])$VALUES.clone();
        }

        public static TouchState valueOf(String string) {
            return Enum.valueOf(TouchState.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/wdeo3601/pdfview/PDFView$PDFHandler;", "Landroid/os/Handler;", "pdfView", "Lcom/wdeo3601/pdfview/PDFView;", "(Lcom/wdeo3601/pdfview/PDFView;)V", "mWeakReference", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "handleMessage", "", "msg", "Landroid/os/Message;", "Companion", "pdfview_release"})
    private static final class PDFHandler
    extends Handler {
        private final WeakReference<PDFView> mWeakReference;
        public static final int MESSAGE_INIT_PDF_PLACE_HOLDER = 1;
        public static final int MESSAGE_CREATE_LOADING_PDF_BITMAP = 2;
        public static final int MESSAGE_CREATE_SCALED_BITMAP = 3;
        public static final int MESSAGE_PDF_DOWNLOAD_SUCCESS = 4;
        public static final Companion Companion = new Companion(null);

        public void handleMessage(@NotNull Message msg) {
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            super.handleMessage(msg);
            PDFView pDFView = (PDFView)((Object)this.mWeakReference.get());
            if (pDFView == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pDFView), (String)"mWeakReference.get() ?: return");
            PDFView pdfView = pDFView;
            switch (msg.what) {
                case 4: {
                    pdfView.requestLayout();
                    Object object = msg.obj;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    pdfView.showPdfFromPath((String)object);
                    break;
                }
                case 1: {
                    pdfView.debug("handleMessage-MESSAGE_INIT_PDF_PLACE_HOLDER", new Object[0]);
                    ArrayList tempPagePlaceHolders = msg.getData().getParcelableArrayList("list");
                    Collection collection = tempPagePlaceHolders;
                    boolean bl = false;
                    boolean bl2 = false;
                    if (collection == null || collection.isEmpty()) break;
                    pdfView.mPdfTotalHeight = ((PageRect)CollectionsKt.last((List)((List)tempPagePlaceHolders))).getFillWidthRect().bottom;
                    pdfView.mPdfTotalWidth = pdfView.getWidth();
                    pdfView.mPagePlaceHolders.addAll(tempPagePlaceHolders);
                    pdfView.invalidate();
                    pdfView.submitCreateLoadingPagesTask();
                    OnPageChangedListener onPageChangedListener = pdfView.mOnPageChangedListener;
                    if (onPageChangedListener != null) {
                        onPageChangedListener.onPageChanged(pdfView.mCurrentPageIndex, tempPagePlaceHolders.size());
                    }
                    break;
                }
                case 2: {
                    pdfView.debug("handleMessage-MESSAGE_CREATE_LOADING_PDF_BITMAP-currentPageIndex:" + pdfView.mCurrentPageIndex, new Object[0]);
                    int calculatedPageIndex = msg.getData().getInt("index");
                    ArrayList tempLoadingPages = msg.getData().getParcelableArrayList("list");
                    if (pdfView.mCurrentPageIndex != calculatedPageIndex) {
                        return;
                    }
                    Collection collection = tempLoadingPages;
                    boolean bl = false;
                    boolean bl3 = false;
                    if (collection == null || collection.isEmpty()) break;
                    pdfView.mLoadingPages.clear();
                    pdfView.mLoadingPages.addAll(tempLoadingPages);
                    pdfView.invalidate();
                    break;
                }
                case 3: {
                    int calculatedPageIndex = msg.getData().getInt("index");
                    ArrayList tempScalingPages = msg.getData().getParcelableArrayList("list");
                    if (pdfView.mCurrentPageIndex != calculatedPageIndex) {
                        return;
                    }
                    Collection collection = tempScalingPages;
                    boolean bl = false;
                    boolean bl4 = false;
                    if (collection == null || collection.isEmpty()) break;
                    pdfView.mScalingPages.clear();
                    pdfView.mScalingPages.addAll(tempScalingPages);
                    pdfView.invalidate();
                    break;
                }
            }
        }

        public PDFHandler(@NotNull PDFView pdfView) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)pdfView), (String)"pdfView");
            this.mWeakReference = new WeakReference<PDFView>(pdfView);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/wdeo3601/pdfview/PDFView$PDFHandler$Companion;", "", "()V", "MESSAGE_CREATE_LOADING_PDF_BITMAP", "", "MESSAGE_CREATE_SCALED_BITMAP", "MESSAGE_INIT_PDF_PLACE_HOLDER", "MESSAGE_PDF_DOWNLOAD_SUCCESS", "pdfview_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J,\u0010\u0010\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0012\u0010\u0013\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000bH\u0016R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/wdeo3601/pdfview/PDFView$OnPDFGestureListener;", "Landroid/view/GestureDetector$SimpleOnGestureListener;", "pdfView", "Lcom/wdeo3601/pdfview/PDFView;", "(Lcom/wdeo3601/pdfview/PDFView;)V", "mWeakReference", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "onFling", "", "e1", "Landroid/view/MotionEvent;", "e2", "velocityX", "", "velocityY", "onScroll", "distanceX", "distanceY", "onSingleTapConfirmed", "e", "pdfview_release"})
    private static final class OnPDFGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private final WeakReference<PDFView> mWeakReference;

        public boolean onSingleTapConfirmed(@Nullable MotionEvent e) {
            block0: {
                PDFView pDFView = (PDFView)((Object)this.mWeakReference.get());
                if (pDFView == null) break block0;
                pDFView.performClick();
            }
            return true;
        }

        public boolean onScroll(@Nullable MotionEvent e1, @Nullable MotionEvent e2, float distanceX, float distanceY) {
            Float f;
            Float f2;
            PDFView pDFView = (PDFView)((Object)this.mWeakReference.get());
            if (pDFView == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pDFView), (String)"mWeakReference.get() ?: return false");
            PDFView pdfView = pDFView;
            Range canTranslateXRange = pdfView.getCanTranslateXRange();
            Range canTranslateYRange = pdfView.getCanTranslateYRange();
            float tempTranslateX = ((PDFView)pdfView).mCanvasTranslate.x - distanceX;
            float tempTranslateY = ((PDFView)pdfView).mCanvasTranslate.y - distanceY;
            if (canTranslateXRange.contains((Comparable)Float.valueOf(tempTranslateX))) {
                f2 = Float.valueOf(tempTranslateX);
            } else {
                Comparable comparable = canTranslateXRange.getUpper();
                Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"canTranslateXRange.upper");
                f2 = tempTranslateX > ((Number)((Object)comparable)).floatValue() ? (Float)canTranslateXRange.getUpper() : (Float)canTranslateXRange.getLower();
            }
            Float nextTranslateX = f2;
            if (canTranslateYRange.contains((Comparable)Float.valueOf(tempTranslateY))) {
                f = Float.valueOf(tempTranslateY);
            } else {
                Comparable comparable = canTranslateYRange.getUpper();
                Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"canTranslateYRange.upper");
                f = tempTranslateY > ((Number)((Object)comparable)).floatValue() ? (Float)canTranslateYRange.getUpper() : (Float)canTranslateYRange.getLower();
            }
            Float nextTranslateY = f;
            PointF pointF = pdfView.mCanvasTranslate;
            Float f3 = nextTranslateX;
            Intrinsics.checkExpressionValueIsNotNull((Object)f3, (String)"nextTranslateX");
            float f4 = f3.floatValue();
            Float f5 = nextTranslateY;
            Intrinsics.checkExpressionValueIsNotNull((Object)f5, (String)"nextTranslateY");
            pointF.set(f4, f5.floatValue());
            pdfView.invalidate();
            pdfView.calculateCurrentPageIndex();
            pdfView.debug("onScroll-distanceX:" + distanceX + "-distanceY:" + distanceY, new Object[0]);
            return false;
        }

        public boolean onFling(@Nullable MotionEvent e1, @Nullable MotionEvent e2, float velocityX, float velocityY) {
            block9: {
                Float f;
                Float f2;
                PDFView pdfView;
                block11: {
                    block10: {
                        PDFView pDFView = (PDFView)((Object)this.mWeakReference.get());
                        if (pDFView == null) {
                            return false;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pDFView), (String)"mWeakReference.get() ?: return false");
                        pdfView = pDFView;
                        PDFView pDFView2 = (PDFView)((Object)this.mWeakReference.get());
                        if (pDFView2 != null) {
                            pDFView2.debug("onFling-velocityX:" + velocityX + "-velocityY:" + velocityY, new Object[0]);
                        }
                        if (e1 == null || e2 == null) break block9;
                        float f3 = e1.getX() - e2.getX();
                        boolean bl = false;
                        if (Math.abs(f3) > (float)100) break block10;
                        f3 = e1.getY() - e2.getY();
                        bl = false;
                        if (!(Math.abs(f3) > (float)100)) break block9;
                    }
                    boolean bl = false;
                    if (Math.abs(velocityX) > (float)500) break block11;
                    bl = false;
                    if (!(Math.abs(velocityY) > (float)500)) break block9;
                }
                Range canTranslateXRange = pdfView.getCanTranslateXRange();
                Range canTranslateYRange = pdfView.getCanTranslateYRange();
                float tempTranslateX = ((PDFView)pdfView).mCanvasTranslate.x + velocityX * 0.75f;
                float tempTranslateY = ((PDFView)pdfView).mCanvasTranslate.y + velocityY * 0.75f;
                if (canTranslateXRange.contains((Comparable)Float.valueOf(tempTranslateX))) {
                    f2 = Float.valueOf(tempTranslateX);
                } else {
                    Comparable comparable = canTranslateXRange.getUpper();
                    Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"canTranslateXRange.upper");
                    f2 = tempTranslateX > ((Number)((Object)comparable)).floatValue() ? (Float)canTranslateXRange.getUpper() : (Float)canTranslateXRange.getLower();
                }
                Float endTranslateX = f2;
                if (canTranslateYRange.contains((Comparable)Float.valueOf(tempTranslateY))) {
                    f = Float.valueOf(tempTranslateY);
                } else {
                    Comparable comparable = canTranslateYRange.getUpper();
                    Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"canTranslateYRange.upper");
                    f = tempTranslateY > ((Number)((Object)comparable)).floatValue() ? (Float)canTranslateYRange.getUpper() : (Float)canTranslateYRange.getLower();
                }
                Float endTranslateY = f;
                float distanceX = endTranslateX.floatValue() - ((PDFView)pdfView).mCanvasTranslate.x;
                float distanceY = endTranslateY.floatValue() - ((PDFView)pdfView).mCanvasTranslate.y;
                pdfView.startFlingAnim(distanceX, distanceY);
                return true;
            }
            return super.onFling(e1, e2, velocityX, velocityY);
        }

        public OnPDFGestureListener(@NotNull PDFView pdfView) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)pdfView), (String)"pdfView");
            this.mWeakReference = new WeakReference<PDFView>(pdfView);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00030\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/wdeo3601/pdfview/PDFView$PDFFlingAnimUpdateListener;", "Landroid/animation/ValueAnimator$AnimatorUpdateListener;", "pdfView", "Lcom/wdeo3601/pdfview/PDFView;", "distanceX", "", "distanceY", "(Lcom/wdeo3601/pdfview/PDFView;FF)V", "lastCanvasTranslate", "Landroid/graphics/PointF;", "mWeakReference", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "onAnimationUpdate", "", "animation", "Landroid/animation/ValueAnimator;", "pdfview_release"})
    private static final class PDFFlingAnimUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private final WeakReference<PDFView> mWeakReference;
        private final PointF lastCanvasTranslate;
        private final float distanceX;
        private final float distanceY;

        public void onAnimationUpdate(@NotNull ValueAnimator animation) {
            Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            PDFView pDFView = (PDFView)((Object)this.mWeakReference.get());
            if (pDFView == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pDFView), (String)"mWeakReference.get() ?: return");
            PDFView pdfView = pDFView;
            Object object = animation.getAnimatedValue();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
            }
            float percent = ((Float)object).floatValue();
            ((PDFView)pdfView).mCanvasTranslate.x = this.lastCanvasTranslate.x + this.distanceX * percent;
            ((PDFView)pdfView).mCanvasTranslate.y = this.lastCanvasTranslate.y + this.distanceY * percent;
            pdfView.invalidate();
            pdfView.calculateCurrentPageIndex();
        }

        public PDFFlingAnimUpdateListener(@NotNull PDFView pdfView, float distanceX, float distanceY) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)pdfView), (String)"pdfView");
            this.distanceX = distanceX;
            this.distanceY = distanceY;
            this.mWeakReference = new WeakReference<PDFView>(pdfView);
            this.lastCanvasTranslate = new PointF(((PDFView)pdfView).mCanvasTranslate.x, ((PDFView)pdfView).mCanvasTranslate.y);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\r\u001a\u00020\tH\u0002R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/wdeo3601/pdfview/PDFView$PdfFlingAnimListenerAdapter;", "Landroid/animation/AnimatorListenerAdapter;", "pdfView", "Lcom/wdeo3601/pdfview/PDFView;", "(Lcom/wdeo3601/pdfview/PDFView;)V", "mWeakReference", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "onAnimationCancel", "", "animation", "Landroid/animation/Animator;", "onAnimationEnd", "preLoadPdf", "pdfview_release"})
    private static final class PdfFlingAnimListenerAdapter
    extends AnimatorListenerAdapter {
        private final WeakReference<PDFView> mWeakReference;

        public void onAnimationCancel(@Nullable Animator animation) {
            this.preLoadPdf();
        }

        public void onAnimationEnd(@Nullable Animator animation) {
            this.preLoadPdf();
        }

        private final void preLoadPdf() {
            PDFView pDFView = (PDFView)((Object)this.mWeakReference.get());
            if (pDFView == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pDFView), (String)"mWeakReference.get() ?: return");
            PDFView pdfView = pDFView;
            pdfView.submitCreateLoadingPagesTask();
            pdfView.submitCreateScalingPagesTask();
        }

        public PdfFlingAnimListenerAdapter(@NotNull PDFView pdfView) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)pdfView), (String)"pdfView");
            this.mWeakReference = new WeakReference<PDFView>(pdfView);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/wdeo3601/pdfview/PDFView$PdfPageToBitmapTask;", "Ljava/lang/Runnable;", "pdfView", "Lcom/wdeo3601/pdfview/PDFView;", "(Lcom/wdeo3601/pdfview/PDFView;)V", "mWeakReference", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "run", "", "pdfview_release"})
    private static final class PdfPageToBitmapTask
    implements Runnable {
        private final WeakReference<PDFView> mWeakReference;

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            PDFView pDFView = (PDFView)((Object)this.mWeakReference.get());
            if (pDFView == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pDFView), (String)"mWeakReference.get() ?: return");
            PDFView pdfView = pDFView;
            boolean bl = false;
            ArrayList<DrawingPage> tempLoadingPages = new ArrayList<DrawingPage>();
            PdfRenderer pdfRenderer = pdfView.mPdfRenderer;
            if (pdfRenderer == null) {
                return;
            }
            PdfRenderer pdfRenderer2 = pdfRenderer;
            List pagePlaceHolders = pdfView.mPagePlaceHolders;
            int currentPageIndex = pdfView.mCurrentPageIndex;
            int n = 0;
            int n2 = currentPageIndex - pdfView.mOffscreenPageLimit;
            int n3 = 0;
            int startLoadingIndex = Math.max(n, n2);
            n2 = currentPageIndex + pdfView.mOffscreenPageLimit;
            n3 = CollectionsKt.getLastIndex((List)pagePlaceHolders);
            boolean bl2 = false;
            int endLoadingIndex = Math.min(n2, n3);
            n2 = startLoadingIndex;
            n3 = endLoadingIndex;
            if (n2 <= n3) {
                while (true) {
                    void index;
                    PageRect pageRect = (PageRect)pagePlaceHolders.get((int)index);
                    RectF fillWidthRect = pageRect.getFillWidthRect();
                    Bitmap bitmap = pdfView.getLoadingPagesBitmapFromCache((int)index);
                    if (bitmap == null) {
                        PdfRenderer.Page page = pdfRenderer2.openPage((int)index);
                        bitmap = Bitmap.createBitmap((int)((int)(fillWidthRect.width() / pageRect.getFillWidthScale())), (int)((int)(fillWidthRect.height() / pageRect.getFillWidthScale())), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        page.render(bitmap, null, null, 1);
                        page.close();
                        Bitmap bitmap2 = bitmap;
                        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
                        pdfView.putLoadingPagesBitmapToCache((int)index, bitmap2);
                    }
                    tempLoadingPages.add(new DrawingPage(pageRect, bitmap, (int)index));
                    if (index == n3) break;
                    ++index;
                }
            }
            Message message = new Message();
            message.what = 2;
            message.getData().putInt("index", currentPageIndex);
            message.getData().putParcelableArrayList("list", tempLoadingPages);
            pdfView.mPDFHandler.sendMessage(message);
        }

        public PdfPageToBitmapTask(@NotNull PDFView pdfView) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)pdfView), (String)"pdfView");
            this.mWeakReference = new WeakReference<PDFView>(pdfView);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/wdeo3601/pdfview/PDFView$CreateScalingPageBitmapTask;", "Ljava/lang/Runnable;", "pdfView", "Lcom/wdeo3601/pdfview/PDFView;", "(Lcom/wdeo3601/pdfview/PDFView;)V", "mWeakReference", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "run", "", "pdfview_release"})
    private static final class CreateScalingPageBitmapTask
    implements Runnable {
        private final WeakReference<PDFView> mWeakReference;

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            int n;
            float f;
            int index22;
            boolean bl;
            float f2;
            PDFView pDFView = (PDFView)((Object)this.mWeakReference.get());
            if (pDFView == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pDFView), (String)"mWeakReference.get() ?: return");
            PDFView pdfView = pDFView;
            PdfRenderer pdfRenderer = pdfView.mPdfRenderer;
            if (pdfRenderer == null) {
                return;
            }
            PdfRenderer pdfRenderer2 = pdfRenderer;
            List pagePlaceHolders = pdfView.mPagePlaceHolders;
            int currentPageIndex = pdfView.mCurrentPageIndex;
            float currentTranslateY = ((PDFView)pdfView).mCanvasTranslate.y;
            float currentPageTop = ((PageRect)pagePlaceHolders.get((int)currentPageIndex)).getFillWidthRect().top;
            pdfView.debug("CreateScalingPageBitmapTask--currentTranslateY:" + currentTranslateY + "-currentPageTop:" + currentPageTop, new Object[0]);
            boolean bl2 = false;
            ArrayList<DrawingPage> tempScalingPages = new ArrayList<DrawingPage>();
            int startIndex = currentPageIndex;
            CreateScalingPageBitmapTask createScalingPageBitmapTask = this;
            boolean bl3 = false;
            int n2 = 0;
            CreateScalingPageBitmapTask $this$run22 = createScalingPageBitmapTask;
            boolean bl4 = false;
            int n3 = currentPageIndex;
            int n4 = 0;
            while (n3 >= 0) {
                void index;
                float f3 = currentTranslateY;
                f2 = ((PageRect)pagePlaceHolders.get((int)index)).getFillWidthRect().bottom * pdfView.mCanvasScale;
                bl = false;
                float f4 = Math.abs(f3);
                if (f2 < f4) break;
                startIndex = index--;
            }
            int endIndex = startIndex;
            CreateScalingPageBitmapTask createScalingPageBitmapTask2 = this;
            n2 = 0;
            boolean $this$run22 = false;
            CreateScalingPageBitmapTask $this$run = createScalingPageBitmapTask2;
            boolean bl5 = false;
            n4 = startIndex;
            int n5 = CollectionsKt.getLastIndex((List)pagePlaceHolders);
            if (n4 <= n5) {
                while (true) {
                    f2 = currentTranslateY;
                    float f5 = ((PageRect)pagePlaceHolders.get((int)index22)).getFillWidthRect().top * pdfView.mCanvasScale;
                    boolean bl6 = false;
                    f = Math.abs(f2);
                    if (f5 > f + (float)pdfView.getMeasuredHeight() - (float)pdfView.getPaddingTop() - (float)pdfView.getPaddingBottom()) break;
                    endIndex = index22;
                    if (index22 == n5) break;
                    ++index22;
                }
            }
            if ((n = startIndex) <= (n2 = endIndex)) {
                while (true) {
                    void index;
                    PageRect placeHolderPageRect = (PageRect)pagePlaceHolders.get((int)index);
                    RectF fillWidthRect = placeHolderPageRect.getFillWidthRect();
                    float f6 = fillWidthRect.top * pdfView.mCanvasScale;
                    index22 = 0;
                    float f7 = Math.abs(currentTranslateY);
                    float index22 = f6 - f7;
                    float f8 = 0.0f;
                    boolean bl7 = false;
                    float scalingRectTop = Math.max(index22, f8);
                    f6 = fillWidthRect.bottom * pdfView.mCanvasScale;
                    boolean bl8 = false;
                    f7 = Math.abs(currentTranslateY);
                    float f9 = f6 - f7;
                    float f10 = (float)(pdfView.getMeasuredHeight() - pdfView.getPaddingTop()) - (float)pdfView.getPaddingBottom();
                    bl = false;
                    float scalingRectBottom = Math.min(f9, f10);
                    if (!(scalingRectBottom <= scalingRectTop)) {
                        RectF scalingRect = new RectF(0.0f, scalingRectTop, (float)(pdfView.getMeasuredWidth() - pdfView.getPaddingLeft()) - (float)pdfView.getPaddingRight(), scalingRectBottom);
                        Bitmap bitmap = Bitmap.createBitmap((int)((int)scalingRect.width()), (int)((int)scalingRect.height()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        Matrix matrix = new Matrix();
                        float scale = placeHolderPageRect.getFillWidthScale() * pdfView.mCanvasScale;
                        matrix.postScale(scale, scale);
                        f = fillWidthRect.top * pdfView.mCanvasScale + currentTranslateY;
                        float f11 = 0.0f;
                        f7 = ((PDFView)pdfView).mCanvasTranslate.x + ((float)pdfView.getPaddingLeft() + pdfView.mDividerHeight) * pdfView.mCanvasScale;
                        Matrix matrix2 = matrix;
                        boolean bl9 = false;
                        float f12 = Math.min(f, f11);
                        matrix2.postTranslate(f7, f12);
                        PdfRenderer.Page page = pdfRenderer2.openPage((int)index);
                        page.render(bitmap, null, matrix, 1);
                        page.close();
                        tempScalingPages.add(new DrawingPage(new PageRect(0.0f, scalingRect, 1, null), bitmap, (int)index));
                    }
                    if (index == n2) break;
                    ++index;
                }
            }
            Message message = new Message();
            message.what = 3;
            message.getData().putInt("index", currentPageIndex);
            message.getData().putParcelableArrayList("list", tempScalingPages);
            pdfView.mPDFHandler.sendMessage(message);
        }

        public CreateScalingPageBitmapTask(@NotNull PDFView pdfView) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)pdfView), (String)"pdfView");
            this.mWeakReference = new WeakReference<PDFView>(pdfView);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/wdeo3601/pdfview/PDFView$InitPdfFramesTask;", "Ljava/lang/Runnable;", "pdfView", "Lcom/wdeo3601/pdfview/PDFView;", "(Lcom/wdeo3601/pdfview/PDFView;)V", "mWeakReference", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "run", "", "pdfview_release"})
    private static final class InitPdfFramesTask
    implements Runnable {
        private final WeakReference<PDFView> mWeakReference;

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            PDFView pDFView = (PDFView)((Object)this.mWeakReference.get());
            if (pDFView == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pDFView), (String)"mWeakReference.get() ?: return");
            PDFView pdfView = pDFView;
            PdfRenderer pdfRenderer = pdfView.mPdfRenderer;
            if (pdfRenderer == null) {
                throw (Throwable)new NullPointerException("pdfRenderer is null!");
            }
            PdfRenderer pdfRenderer2 = pdfRenderer;
            boolean bl = false;
            ArrayList<PageRect> tempPagePlaceHolders = new ArrayList<PageRect>();
            float pdfTotalHeight = 0.0f;
            float left = (float)pdfView.getPaddingLeft() + pdfView.mDividerHeight;
            float right = (float)pdfView.getMeasuredWidth() - (float)pdfView.getPaddingRight() - pdfView.mDividerHeight;
            float fillWidthScale = 0.0f;
            float scaledHeight = 0.0f;
            int n = 0;
            int n2 = pdfRenderer2.getPageCount();
            while (n < n2) {
                void index;
                PdfRenderer.Page page;
                PdfRenderer.Page page2 = page = pdfRenderer2.openPage((int)index);
                Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"page");
                fillWidthScale = (right - left) / (float)page2.getWidth();
                scaledHeight = (float)page.getHeight() * fillWidthScale;
                if (index != false) {
                    pdfTotalHeight += pdfView.mDividerHeight;
                }
                RectF rect = new RectF(left, pdfTotalHeight, right, pdfTotalHeight + scaledHeight);
                pdfTotalHeight = rect.bottom;
                tempPagePlaceHolders.add(new PageRect(fillWidthScale, rect));
                page.close();
                ++index;
            }
            Message message = new Message();
            message.what = 1;
            message.getData().putParcelableArrayList("list", tempPagePlaceHolders);
            pdfView.mPDFHandler.sendMessage(message);
        }

        public InitPdfFramesTask(@NotNull PDFView pdfView) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)pdfView), (String)"pdfView");
            this.mWeakReference = new WeakReference<PDFView>(pdfView);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/wdeo3601/pdfview/PDFView$PdfDownloadTask;", "Ljava/lang/Runnable;", "pdfView", "Lcom/wdeo3601/pdfview/PDFView;", "fileUrl", "", "filePath", "(Lcom/wdeo3601/pdfview/PDFView;Ljava/lang/String;Ljava/lang/String;)V", "mWeakReference", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "run", "", "pdfview_release"})
    private static final class PdfDownloadTask
    implements Runnable {
        private final WeakReference<PDFView> mWeakReference;
        private final String fileUrl;
        private final String filePath;

        @Override
        public void run() {
            PDFView pDFView = (PDFView)((Object)this.mWeakReference.get());
            if (pDFView == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pDFView), (String)"mWeakReference.get() ?: return");
            PDFView pdfView = pDFView;
            try {
                URLConnection uRLConnection = new URL(this.fileUrl).openConnection();
                if (uRLConnection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
                }
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                InputStream inputStream = httpURLConnection.getInputStream();
                byte[] buffer = new byte[1024];
                int len = 0;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                len = inputStream.read(buffer);
                while (len != -1) {
                    bos.write(buffer, 0, len);
                    len = inputStream.read(buffer);
                }
                bos.close();
                inputStream.close();
                File file = new File(this.filePath);
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(bos.toByteArray());
                fos.close();
                Message message = new Message();
                message.what = 4;
                message.obj = this.filePath;
                pdfView.mPDFHandler.sendMessage(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public PdfDownloadTask(@NotNull PDFView pdfView, @NotNull String fileUrl, @NotNull String filePath) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)pdfView), (String)"pdfView");
            Intrinsics.checkParameterIsNotNull((Object)fileUrl, (String)"fileUrl");
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            this.fileUrl = fileUrl;
            this.filePath = filePath;
            this.mWeakReference = new WeakReference<PDFView>(pdfView);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B!\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010\u0014\u001a\u00020\nH\u00c6\u0003J+\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\b\u0010\u0016\u001a\u00020\nH\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\nH\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/wdeo3601/pdfview/PDFView$DrawingPage;", "Landroid/os/Parcelable;", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "pageRect", "Lcom/wdeo3601/pdfview/PDFView$PageRect;", "bitmap", "Landroid/graphics/Bitmap;", "pageIndex", "", "(Lcom/wdeo3601/pdfview/PDFView$PageRect;Landroid/graphics/Bitmap;I)V", "getBitmap", "()Landroid/graphics/Bitmap;", "getPageIndex", "()I", "getPageRect", "()Lcom/wdeo3601/pdfview/PDFView$PageRect;", "component1", "component2", "component3", "copy", "describeContents", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "flags", "CREATOR", "pdfview_release"})
    private static final class DrawingPage
    implements Parcelable {
        @Nullable
        private final PageRect pageRect;
        @Nullable
        private final Bitmap bitmap;
        private final int pageIndex;
        public static final CREATOR CREATOR = new CREATOR(null);

        public void writeToParcel(@NotNull Parcel parcel, int flags) {
            Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
            parcel.writeParcelable((Parcelable)this.pageRect, flags);
            parcel.writeParcelable((Parcelable)this.bitmap, flags);
            parcel.writeInt(this.pageIndex);
        }

        public int describeContents() {
            return 0;
        }

        @Nullable
        public final PageRect getPageRect() {
            return this.pageRect;
        }

        @Nullable
        public final Bitmap getBitmap() {
            return this.bitmap;
        }

        public final int getPageIndex() {
            return this.pageIndex;
        }

        public DrawingPage(@Nullable PageRect pageRect, @Nullable Bitmap bitmap, int pageIndex) {
            this.pageRect = pageRect;
            this.bitmap = bitmap;
            this.pageIndex = pageIndex;
        }

        public DrawingPage(@NotNull Parcel parcel) {
            Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
            this((PageRect)parcel.readParcelable(PageRect.class.getClassLoader()), (Bitmap)parcel.readParcelable(Bitmap.class.getClassLoader()), parcel.readInt());
        }

        @Nullable
        public final PageRect component1() {
            return this.pageRect;
        }

        @Nullable
        public final Bitmap component2() {
            return this.bitmap;
        }

        public final int component3() {
            return this.pageIndex;
        }

        @NotNull
        public final DrawingPage copy(@Nullable PageRect pageRect, @Nullable Bitmap bitmap, int pageIndex) {
            return new DrawingPage(pageRect, bitmap, pageIndex);
        }

        public static /* synthetic */ DrawingPage copy$default(DrawingPage drawingPage, PageRect pageRect, Bitmap bitmap, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                pageRect = drawingPage.pageRect;
            }
            if ((n2 & 2) != 0) {
                bitmap = drawingPage.bitmap;
            }
            if ((n2 & 4) != 0) {
                n = drawingPage.pageIndex;
            }
            return drawingPage.copy(pageRect, bitmap, n);
        }

        @NotNull
        public String toString() {
            return "DrawingPage(pageRect=" + this.pageRect + ", bitmap=" + this.bitmap + ", pageIndex=" + this.pageIndex + ")";
        }

        public int hashCode() {
            PageRect pageRect = this.pageRect;
            Bitmap bitmap = this.bitmap;
            return ((pageRect != null ? pageRect.hashCode() : 0) * 31 + (bitmap != null ? bitmap.hashCode() : 0)) * 31 + this.pageIndex;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DrawingPage)) break block3;
                    DrawingPage drawingPage = (DrawingPage)object;
                    if (!Intrinsics.areEqual((Object)this.pageRect, (Object)drawingPage.pageRect) || !Intrinsics.areEqual((Object)this.bitmap, (Object)drawingPage.bitmap) || this.pageIndex != drawingPage.pageIndex) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001d\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/wdeo3601/pdfview/PDFView$DrawingPage$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lcom/wdeo3601/pdfview/PDFView$DrawingPage;", "()V", "createFromParcel", "parcel", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lcom/wdeo3601/pdfview/PDFView$DrawingPage;", "pdfview_release"})
        public static final class CREATOR
        implements Parcelable.Creator<DrawingPage> {
            @NotNull
            public DrawingPage createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
                return new DrawingPage(parcel);
            }

            @NotNull
            public DrawingPage[] newArray(int size) {
                return new DrawingPage[size];
            }

            private CREATOR() {
            }

            public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/wdeo3601/pdfview/PDFView$PageRect;", "Landroid/os/Parcelable;", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "fillWidthScale", "", "fillWidthRect", "Landroid/graphics/RectF;", "(FLandroid/graphics/RectF;)V", "getFillWidthRect", "()Landroid/graphics/RectF;", "getFillWidthScale", "()F", "describeContents", "", "writeToParcel", "", "flags", "CREATOR", "pdfview_release"})
    private static final class PageRect
    implements Parcelable {
        private final float fillWidthScale;
        @NotNull
        private final RectF fillWidthRect;
        public static final CREATOR CREATOR = new CREATOR(null);

        public void writeToParcel(@NotNull Parcel parcel, int flags) {
            Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
            parcel.writeFloat(this.fillWidthScale);
            parcel.writeParcelable((Parcelable)this.fillWidthRect, flags);
        }

        public int describeContents() {
            return 0;
        }

        public final float getFillWidthScale() {
            return this.fillWidthScale;
        }

        @NotNull
        public final RectF getFillWidthRect() {
            return this.fillWidthRect;
        }

        public PageRect(float fillWidthScale, @NotNull RectF fillWidthRect) {
            Intrinsics.checkParameterIsNotNull((Object)fillWidthRect, (String)"fillWidthRect");
            this.fillWidthScale = fillWidthScale;
            this.fillWidthRect = fillWidthRect;
        }

        public /* synthetic */ PageRect(float f, RectF rectF, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                f = 1.0f;
            }
            this(f, rectF);
        }

        public PageRect(@NotNull Parcel parcel) {
            Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
            float f = parcel.readFloat();
            RectF rectF = (RectF)parcel.readParcelable(RectF.class.getClassLoader());
            if (rectF == null) {
                rectF = new RectF();
            }
            this(f, rectF);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001d\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/wdeo3601/pdfview/PDFView$PageRect$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lcom/wdeo3601/pdfview/PDFView$PageRect;", "()V", "createFromParcel", "parcel", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lcom/wdeo3601/pdfview/PDFView$PageRect;", "pdfview_release"})
        public static final class CREATOR
        implements Parcelable.Creator<PageRect> {
            @NotNull
            public PageRect createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
                return new PageRect(parcel);
            }

            @NotNull
            public PageRect[] newArray(int size) {
                return new PageRect[size];
            }

            private CREATOR() {
            }

            public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/wdeo3601/pdfview/PDFView$OnPageChangedListener;", "", "onPageChanged", "", "currentPageIndex", "", "totalPageCount", "pdfview_release"})
    public static interface OnPageChangedListener {
        public void onPageChanged(int var1, int var2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/wdeo3601/pdfview/PDFView$Companion;", "", "()V", "EXECUTOR_SERVICE", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "pdfview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

