/*
 * Decompiled with CFR 0.152.
 */
package com.darsh.multipleimageselect.activities;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.provider.MediaStore;
import android.util.DisplayMetrics;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.widget.Toolbar;
import com.darsh.multipleimageselect.R;
import com.darsh.multipleimageselect.activities.HelperActivity;
import com.darsh.multipleimageselect.adapters.CustomImageSelectAdapter;
import com.darsh.multipleimageselect.helpers.Constants;
import com.darsh.multipleimageselect.models.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;

public class ImageSelectActivity
extends HelperActivity {
    private ArrayList<Image> images;
    private String album;
    private TextView errorDisplay;
    private ProgressBar progressBar;
    private GridView gridView;
    private CustomImageSelectAdapter adapter;
    private ActionBar actionBar;
    private ActionMode actionMode;
    private int countSelected;
    private ContentObserver observer;
    private Handler handler;
    private Thread thread;
    private final String[] projection = new String[]{"_id", "_display_name", "_data"};
    private ActionMode.Callback callback = new ActionMode.Callback(){

        public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
            MenuInflater menuInflater = mode.getMenuInflater();
            menuInflater.inflate(R.menu.menu_contextual_action_bar, menu2);
            ImageSelectActivity.this.actionMode = mode;
            ImageSelectActivity.this.countSelected = 0;
            return true;
        }

        public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
            return false;
        }

        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            int i = item.getItemId();
            if (i == R.id.menu_item_add_image) {
                ImageSelectActivity.this.sendIntent();
                return true;
            }
            return false;
        }

        public void onDestroyActionMode(ActionMode mode) {
            if (ImageSelectActivity.this.countSelected > 0) {
                ImageSelectActivity.this.deselectAll();
            }
            ImageSelectActivity.this.actionMode = null;
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        Intent intent;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_image_select);
        this.setView(this.findViewById(R.id.layout_image_select));
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        this.actionBar = this.getSupportActionBar();
        if (this.actionBar != null) {
            this.actionBar.setDisplayHomeAsUpEnabled(true);
            this.actionBar.setHomeAsUpIndicator(R.drawable.ic_arrow_back);
            this.actionBar.setDisplayShowTitleEnabled(true);
            this.actionBar.setTitle(R.string.image_view);
        }
        if ((intent = this.getIntent()) == null) {
            this.finish();
        }
        this.album = intent.getStringExtra("album");
        this.errorDisplay = (TextView)this.findViewById(R.id.text_view_error);
        this.errorDisplay.setVisibility(4);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progress_bar_image_select);
        this.gridView = (GridView)this.findViewById(R.id.grid_view_image_select);
        this.gridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (ImageSelectActivity.this.actionMode == null) {
                    ImageSelectActivity.this.actionMode = ImageSelectActivity.this.startActionMode(ImageSelectActivity.this.callback);
                }
                ImageSelectActivity.this.toggleSelection(position);
                ImageSelectActivity.this.actionMode.setTitle((CharSequence)(ImageSelectActivity.this.countSelected + " " + ImageSelectActivity.this.getString(R.string.selected)));
                if (ImageSelectActivity.this.countSelected == 0) {
                    ImageSelectActivity.this.actionMode.finish();
                }
            }
        });
    }

    protected void onStart() {
        super.onStart();
        this.handler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1001: {
                        ImageSelectActivity.this.loadImages();
                        break;
                    }
                    case 2001: {
                        ImageSelectActivity.this.progressBar.setVisibility(0);
                        ImageSelectActivity.this.gridView.setVisibility(4);
                        break;
                    }
                    case 2002: {
                        if (ImageSelectActivity.this.adapter == null) {
                            ImageSelectActivity.this.adapter = new CustomImageSelectAdapter(ImageSelectActivity.this.getApplicationContext(), ImageSelectActivity.this.images);
                            ImageSelectActivity.this.gridView.setAdapter((ListAdapter)ImageSelectActivity.this.adapter);
                            ImageSelectActivity.this.progressBar.setVisibility(4);
                            ImageSelectActivity.this.gridView.setVisibility(0);
                            ImageSelectActivity.this.orientationBasedUI(ImageSelectActivity.this.getResources().getConfiguration().orientation);
                            break;
                        }
                        ImageSelectActivity.this.adapter.notifyDataSetChanged();
                        if (ImageSelectActivity.this.actionMode == null) break;
                        ImageSelectActivity.this.countSelected = msg.arg1;
                        ImageSelectActivity.this.actionMode.setTitle((CharSequence)(ImageSelectActivity.this.countSelected + " " + ImageSelectActivity.this.getString(R.string.selected)));
                        break;
                    }
                    case 2005: {
                        ImageSelectActivity.this.progressBar.setVisibility(4);
                        ImageSelectActivity.this.errorDisplay.setVisibility(0);
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }
        };
        this.observer = new ContentObserver(this.handler){

            public void onChange(boolean selfChange) {
                ImageSelectActivity.this.loadImages();
            }
        };
        this.getContentResolver().registerContentObserver(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, false, this.observer);
        this.checkPermission();
    }

    protected void onStop() {
        super.onStop();
        this.stopThread();
        this.getContentResolver().unregisterContentObserver(this.observer);
        this.observer = null;
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
            this.handler = null;
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.actionBar != null) {
            this.actionBar.setHomeAsUpIndicator(null);
        }
        this.images = null;
        if (this.adapter != null) {
            this.adapter.releaseResources();
        }
        this.gridView.setOnItemClickListener(null);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.orientationBasedUI(newConfig.orientation);
    }

    private void orientationBasedUI(int orientation) {
        WindowManager windowManager = (WindowManager)this.getApplicationContext().getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(metrics);
        if (this.adapter != null) {
            int size = orientation == 1 ? metrics.widthPixels / 3 : metrics.widthPixels / 5;
            this.adapter.setLayoutParams(size);
        }
        this.gridView.setNumColumns(orientation == 1 ? 3 : 5);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return false;
    }

    private void toggleSelection(int position) {
        if (!this.images.get((int)position).isSelected && this.countSelected >= Constants.limit) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)String.format(this.getString(R.string.limit_exceeded), Constants.limit), (int)0).show();
            return;
        }
        boolean bl = this.images.get((int)position).isSelected = !this.images.get((int)position).isSelected;
        this.countSelected = this.images.get((int)position).isSelected ? ++this.countSelected : --this.countSelected;
        this.adapter.notifyDataSetChanged();
    }

    private void deselectAll() {
        int l = this.images.size();
        for (int i = 0; i < l; ++i) {
            this.images.get((int)i).isSelected = false;
        }
        this.countSelected = 0;
        this.adapter.notifyDataSetChanged();
    }

    private ArrayList<Image> getSelected() {
        ArrayList<Image> selectedImages = new ArrayList<Image>();
        int l = this.images.size();
        for (int i = 0; i < l; ++i) {
            if (!this.images.get((int)i).isSelected) continue;
            selectedImages.add(this.images.get(i));
        }
        return selectedImages;
    }

    private void sendIntent() {
        Intent intent = new Intent();
        intent.putParcelableArrayListExtra("images", this.getSelected());
        this.setResult(-1, intent);
        this.finish();
    }

    private void loadImages() {
        this.startThread(new ImageLoaderRunnable());
    }

    private void startThread(Runnable runnable) {
        this.stopThread();
        this.thread = new Thread(runnable);
        this.thread.start();
    }

    private void stopThread() {
        if (this.thread == null || !this.thread.isAlive()) {
            return;
        }
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void sendMessage(int what) {
        this.sendMessage(what, 0);
    }

    private void sendMessage(int what, int arg1) {
        if (this.handler == null) {
            return;
        }
        Message message = this.handler.obtainMessage();
        message.what = what;
        message.arg1 = arg1;
        message.sendToTarget();
    }

    @Override
    protected void permissionGranted() {
        this.sendMessage(1001);
    }

    @Override
    protected void hideViews() {
        this.progressBar.setVisibility(4);
        this.gridView.setVisibility(4);
    }

    private class ImageLoaderRunnable
    implements Runnable {
        private ImageLoaderRunnable() {
        }

        @Override
        public void run() {
            Cursor cursor;
            File file;
            Process.setThreadPriority((int)10);
            if (ImageSelectActivity.this.adapter == null) {
                ImageSelectActivity.this.sendMessage(2001);
            }
            HashSet<Long> selectedImages = new HashSet<Long>();
            if (ImageSelectActivity.this.images != null) {
                int l = ImageSelectActivity.this.images.size();
                for (int i = 0; i < l; ++i) {
                    Image image = (Image)ImageSelectActivity.this.images.get(i);
                    file = new File(image.path);
                    if (!file.exists() || !image.isSelected) continue;
                    selectedImages.add(image.id);
                }
            }
            if ((cursor = ImageSelectActivity.this.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, ImageSelectActivity.this.projection, "bucket_display_name =?", new String[]{ImageSelectActivity.this.album}, "date_added")) == null) {
                ImageSelectActivity.this.sendMessage(2005);
                return;
            }
            int tempCountSelected = 0;
            ArrayList<Image> temp = new ArrayList<Image>(cursor.getCount());
            if (cursor.moveToLast()) {
                do {
                    if (Thread.interrupted()) {
                        return;
                    }
                    long id2 = cursor.getLong(cursor.getColumnIndex(ImageSelectActivity.this.projection[0]));
                    String name = cursor.getString(cursor.getColumnIndex(ImageSelectActivity.this.projection[1]));
                    String path = cursor.getString(cursor.getColumnIndex(ImageSelectActivity.this.projection[2]));
                    boolean isSelected = selectedImages.contains(id2);
                    if (isSelected) {
                        ++tempCountSelected;
                    }
                    if (!(file = new File(path)).exists()) continue;
                    temp.add(new Image(id2, name, path, isSelected));
                } while (cursor.moveToPrevious());
            }
            cursor.close();
            if (ImageSelectActivity.this.images == null) {
                ImageSelectActivity.this.images = new ArrayList();
            }
            ImageSelectActivity.this.images.clear();
            ImageSelectActivity.this.images.addAll(temp);
            ImageSelectActivity.this.sendMessage(2002, tempCountSelected);
        }
    }
}

