/*
 * Decompiled with CFR 0.152.
 */
package com.darsh.multipleimageselect.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.darsh.multipleimageselect.R;
import com.google.android.material.snackbar.Snackbar;

public class HelperActivity
extends AppCompatActivity {
    protected View view;
    private final int maxLines = 4;
    private final String[] permissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};

    protected void checkPermission() {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            this.permissionGranted();
        } else {
            ActivityCompat.requestPermissions((Activity)this, (String[])this.permissions, (int)1000);
        }
    }

    private void requestPermission() {
        if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE")) {
            this.showRequestPermissionRationale();
        } else {
            this.showAppPermissionSettings();
        }
    }

    private void showRequestPermissionRationale() {
        Snackbar snackbar = Snackbar.make((View)this.view, (CharSequence)this.getString(R.string.permission_info), (int)-2).setAction((CharSequence)this.getString(R.string.permission_ok), new View.OnClickListener(){

            public void onClick(View v) {
                ActivityCompat.requestPermissions((Activity)HelperActivity.this, (String[])HelperActivity.this.permissions, (int)1000);
            }
        });
        snackbar.show();
    }

    private void showAppPermissionSettings() {
        Snackbar snackbar = Snackbar.make((View)this.view, (CharSequence)this.getString(R.string.permission_force), (int)-2).setAction((CharSequence)this.getString(R.string.permission_settings), new View.OnClickListener(){

            public void onClick(View v) {
                Uri uri = Uri.fromParts((String)HelperActivity.this.getString(R.string.permission_package), (String)HelperActivity.this.getPackageName(), null);
                Intent intent = new Intent();
                intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                intent.addFlags(0x40000000);
                intent.setData(uri);
                HelperActivity.this.startActivityForResult(intent, 1000);
            }
        });
        snackbar.show();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode != 1000 || grantResults.length == 0 || grantResults[0] == -1) {
            this.permissionDenied();
        } else {
            this.permissionGranted();
        }
    }

    protected void permissionGranted() {
    }

    private void permissionDenied() {
        this.hideViews();
        this.requestPermission();
    }

    protected void hideViews() {
    }

    protected void setView(View view) {
        this.view = view;
    }
}

