/*
 * Decompiled with CFR 0.152.
 */
package com.darsh.multipleimageselect.activities;

import android.content.Intent;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.provider.MediaStore;
import android.util.DisplayMetrics;
import android.view.MenuItem;
import android.view.View;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.widget.Toolbar;
import com.darsh.multipleimageselect.R;
import com.darsh.multipleimageselect.activities.HelperActivity;
import com.darsh.multipleimageselect.activities.ImageSelectActivity;
import com.darsh.multipleimageselect.adapters.CustomAlbumSelectAdapter;
import com.darsh.multipleimageselect.helpers.Constants;
import com.darsh.multipleimageselect.models.Album;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;

public class AlbumSelectActivity
extends HelperActivity {
    private ArrayList<Album> albums;
    private TextView errorDisplay;
    private ProgressBar progressBar;
    private GridView gridView;
    private CustomAlbumSelectAdapter adapter;
    private ActionBar actionBar;
    private ContentObserver observer;
    private Handler handler;
    private Thread thread;
    private final String[] projection = new String[]{"bucket_id", "bucket_display_name", "_data"};

    protected void onCreate(Bundle savedInstanceState) {
        Intent intent;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_album_select);
        this.setView(this.findViewById(R.id.layout_album_select));
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        this.actionBar = this.getSupportActionBar();
        if (this.actionBar != null) {
            this.actionBar.setDisplayHomeAsUpEnabled(true);
            this.actionBar.setHomeAsUpIndicator(R.drawable.ic_arrow_back);
            this.actionBar.setDisplayShowTitleEnabled(true);
            this.actionBar.setTitle(R.string.album_view);
        }
        if ((intent = this.getIntent()) == null) {
            this.finish();
        }
        Constants.limit = intent.getIntExtra("limit", 10);
        this.errorDisplay = (TextView)this.findViewById(R.id.text_view_error);
        this.errorDisplay.setVisibility(4);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progress_bar_album_select);
        this.gridView = (GridView)this.findViewById(R.id.grid_view_album_select);
        this.gridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                Intent intent = new Intent(AlbumSelectActivity.this.getApplicationContext(), ImageSelectActivity.class);
                intent.putExtra("album", ((Album)((AlbumSelectActivity)AlbumSelectActivity.this).albums.get((int)position)).name);
                AlbumSelectActivity.this.startActivityForResult(intent, 2000);
            }
        });
    }

    protected void onStart() {
        super.onStart();
        this.handler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1001: {
                        AlbumSelectActivity.this.loadAlbums();
                        break;
                    }
                    case 2001: {
                        AlbumSelectActivity.this.progressBar.setVisibility(0);
                        AlbumSelectActivity.this.gridView.setVisibility(4);
                        break;
                    }
                    case 2002: {
                        if (AlbumSelectActivity.this.adapter == null) {
                            AlbumSelectActivity.this.adapter = new CustomAlbumSelectAdapter(AlbumSelectActivity.this.getApplicationContext(), AlbumSelectActivity.this.albums);
                            AlbumSelectActivity.this.gridView.setAdapter((ListAdapter)AlbumSelectActivity.this.adapter);
                            AlbumSelectActivity.this.progressBar.setVisibility(4);
                            AlbumSelectActivity.this.gridView.setVisibility(0);
                            AlbumSelectActivity.this.orientationBasedUI(AlbumSelectActivity.this.getResources().getConfiguration().orientation);
                            break;
                        }
                        AlbumSelectActivity.this.adapter.notifyDataSetChanged();
                        break;
                    }
                    case 2005: {
                        AlbumSelectActivity.this.progressBar.setVisibility(4);
                        AlbumSelectActivity.this.errorDisplay.setVisibility(0);
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }
        };
        this.observer = new ContentObserver(this.handler){

            public void onChange(boolean selfChange, Uri uri) {
                AlbumSelectActivity.this.loadAlbums();
            }
        };
        this.getContentResolver().registerContentObserver(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, false, this.observer);
        this.checkPermission();
    }

    protected void onStop() {
        super.onStop();
        this.stopThread();
        this.getContentResolver().unregisterContentObserver(this.observer);
        this.observer = null;
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
            this.handler = null;
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.actionBar != null) {
            this.actionBar.setHomeAsUpIndicator(null);
        }
        this.albums = null;
        if (this.adapter != null) {
            this.adapter.releaseResources();
        }
        this.gridView.setOnItemClickListener(null);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.orientationBasedUI(newConfig.orientation);
    }

    private void orientationBasedUI(int orientation) {
        WindowManager windowManager = (WindowManager)this.getApplicationContext().getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(metrics);
        if (this.adapter != null) {
            int size = orientation == 1 ? metrics.widthPixels / 2 : metrics.widthPixels / 4;
            this.adapter.setLayoutParams(size);
        }
        this.gridView.setNumColumns(orientation == 1 ? 2 : 4);
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.setResult(0);
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 2000 && resultCode == -1 && data != null) {
            this.setResult(-1, data);
            this.finish();
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return false;
    }

    private void loadAlbums() {
        this.startThread(new AlbumLoaderRunnable());
    }

    private void startThread(Runnable runnable) {
        this.stopThread();
        this.thread = new Thread(runnable);
        this.thread.start();
    }

    private void stopThread() {
        if (this.thread == null || !this.thread.isAlive()) {
            return;
        }
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void sendMessage(int what) {
        if (this.handler == null) {
            return;
        }
        Message message = this.handler.obtainMessage();
        message.what = what;
        message.sendToTarget();
    }

    @Override
    protected void permissionGranted() {
        Message message = this.handler.obtainMessage();
        message.what = 1001;
        message.sendToTarget();
    }

    @Override
    protected void hideViews() {
        this.progressBar.setVisibility(4);
        this.gridView.setVisibility(4);
    }

    private class AlbumLoaderRunnable
    implements Runnable {
        private AlbumLoaderRunnable() {
        }

        @Override
        public void run() {
            Cursor cursor;
            Process.setThreadPriority((int)10);
            if (AlbumSelectActivity.this.adapter == null) {
                AlbumSelectActivity.this.sendMessage(2001);
            }
            if ((cursor = AlbumSelectActivity.this.getApplicationContext().getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, AlbumSelectActivity.this.projection, null, null, "date_added")) == null) {
                AlbumSelectActivity.this.sendMessage(2005);
                return;
            }
            ArrayList<Album> temp = new ArrayList<Album>(cursor.getCount());
            HashSet<Long> albumSet = new HashSet<Long>();
            if (cursor.moveToLast()) {
                do {
                    File file;
                    if (Thread.interrupted()) {
                        return;
                    }
                    long albumId = cursor.getLong(cursor.getColumnIndex(AlbumSelectActivity.this.projection[0]));
                    String album = cursor.getString(cursor.getColumnIndex(AlbumSelectActivity.this.projection[1]));
                    String image = cursor.getString(cursor.getColumnIndex(AlbumSelectActivity.this.projection[2]));
                    if (albumSet.contains(albumId) || !(file = new File(image)).exists()) continue;
                    temp.add(new Album(album, image));
                    albumSet.add(albumId);
                } while (cursor.moveToPrevious());
            }
            cursor.close();
            if (AlbumSelectActivity.this.albums == null) {
                AlbumSelectActivity.this.albums = new ArrayList();
            }
            AlbumSelectActivity.this.albums.clear();
            AlbumSelectActivity.this.albums.addAll(temp);
            AlbumSelectActivity.this.sendMessage(2002);
        }
    }
}

