/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.integrations.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.wavefront.common.MetricsToTimeseries;
import com.wavefront.common.Pair;
import com.wavefront.integrations.metrics.SocketMetricsProcessor;
import com.wavefront.metrics.MetricTranslator;
import com.yammer.metrics.core.Clock;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.VirtualMachineMetrics;
import com.yammer.metrics.reporting.AbstractPollingReporter;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class WavefrontYammerMetricsReporter
extends AbstractPollingReporter {
    protected static final Logger logger = Logger.getLogger(WavefrontYammerMetricsReporter.class.getCanonicalName());
    private SocketMetricsProcessor socketMetricProcessor;
    private MetricTranslator metricTranslator;
    private int metricsGeneratedLastPass = 0;
    private final boolean includeJvmMetrics;
    private final boolean clearMetrics;
    private static final Clock clock = Clock.defaultClock();
    private static final VirtualMachineMetrics vm = VirtualMachineMetrics.getInstance();

    public WavefrontYammerMetricsReporter(MetricsRegistry metricsRegistry, String name, String hostname, int port, int wavefrontHistogramPort, Supplier<Long> timeSupplier) throws IOException {
        this(metricsRegistry, name, hostname, port, wavefrontHistogramPort, timeSupplier, false, null, false, false);
    }

    public WavefrontYammerMetricsReporter(MetricsRegistry metricsRegistry, String name, String hostname, int port, int wavefrontHistogramPort, Supplier<Long> timeSupplier, boolean prependGroupName, @Nullable MetricTranslator metricTranslator, boolean includeJvmMetrics, boolean clearMetrics) throws IOException {
        super(metricsRegistry, name);
        this.metricTranslator = metricTranslator;
        this.socketMetricProcessor = new SocketMetricsProcessor(hostname, port, wavefrontHistogramPort, timeSupplier, prependGroupName, clearMetrics);
        this.includeJvmMetrics = includeJvmMetrics;
        this.clearMetrics = clearMetrics;
    }

    private void registerGauge(String metricName, final Supplier<Double> t) {
        this.getMetricsRegistry().newGauge(new MetricName("", "", MetricsToTimeseries.sanitize((String)metricName)), (Gauge)new Gauge<Double>(){

            public Double value() {
                return (Double)t.get();
            }
        });
    }

    private void registerGauges(String base, Map<String, Supplier<Double>> metrics) {
        for (Map.Entry<String, Supplier<Double>> entry : metrics.entrySet()) {
            this.registerGauge(base + "." + entry.getKey(), entry.getValue());
        }
    }

    private void setJavaMetrics() {
        this.registerGauges("jvm.memory", MetricsToTimeseries.memoryMetrics((VirtualMachineMetrics)vm));
        this.registerGauges("jvm.buffers.direct", MetricsToTimeseries.buffersMetrics((VirtualMachineMetrics.BufferPoolStats)((VirtualMachineMetrics.BufferPoolStats)vm.getBufferPoolStats().get("direct"))));
        this.registerGauges("jvm.buffers.mapped", MetricsToTimeseries.buffersMetrics((VirtualMachineMetrics.BufferPoolStats)((VirtualMachineMetrics.BufferPoolStats)vm.getBufferPoolStats().get("mapped"))));
        this.registerGauges("jvm.thread-states", MetricsToTimeseries.threadStateMetrics((VirtualMachineMetrics)vm));
        this.registerGauges("jvm", MetricsToTimeseries.vmMetrics((VirtualMachineMetrics)vm));
        this.registerGauge("current_time", () -> clock.time());
        for (Map.Entry entry : vm.garbageCollectors().entrySet()) {
            this.registerGauges("jvm.garbage-collectors." + (String)entry.getKey(), MetricsToTimeseries.gcMetrics((VirtualMachineMetrics.GarbageCollectorStats)((VirtualMachineMetrics.GarbageCollectorStats)entry.getValue())));
        }
    }

    @VisibleForTesting
    int getMetricsGeneratedLastPass() {
        return this.metricsGeneratedLastPass;
    }

    public void run() {
        this.metricsGeneratedLastPass = 0;
        try {
            if (this.includeJvmMetrics) {
                this.setJavaMetrics();
            }
            for (Map.Entry entry : this.getMetricsRegistry().groupedMetrics().entrySet()) {
                for (Map.Entry subEntry : ((SortedMap)entry.getValue()).entrySet()) {
                    MetricName metricName = (MetricName)subEntry.getKey();
                    Metric metric = (Metric)subEntry.getValue();
                    if (this.metricTranslator != null) {
                        Pair pair = (Pair)this.metricTranslator.apply((Object)Pair.of((Object)metricName, (Object)metric));
                        if (pair == null) continue;
                        metricName = (MetricName)pair._1;
                        metric = (Metric)pair._2;
                    }
                    metric.processWith((MetricProcessor)this.socketMetricProcessor, metricName, null);
                    ++this.metricsGeneratedLastPass;
                }
            }
            this.socketMetricProcessor.flush();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cannot report point to Wavefront! Trying again next iteration.", e);
        }
    }
}

