/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.integrations.metrics;

import com.wavefront.common.MetricsToTimeseries;
import com.wavefront.common.TaggedMetricName;
import com.wavefront.metrics.ReconnectingSocket;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.Sampling;
import com.yammer.metrics.core.Summarizable;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.WavefrontHistogram;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class SocketMetricsProcessor
implements MetricProcessor<Void> {
    protected static final Logger logger = Logger.getLogger(SocketMetricsProcessor.class.getCanonicalName());
    private ReconnectingSocket metricsSocket;
    private ReconnectingSocket histogramsSocket;
    private final Supplier<Long> timeSupplier;
    private final boolean prependGroupName;
    private final boolean clear;

    SocketMetricsProcessor(String hostname, int port, int wavefrontHistogramPort, Supplier<Long> timeSupplier, boolean prependGroupName) throws IOException {
        this(hostname, port, wavefrontHistogramPort, timeSupplier, prependGroupName, false);
    }

    SocketMetricsProcessor(String hostname, int port, int wavefrontHistogramPort, Supplier<Long> timeSupplier, boolean prependGroupName, boolean clear) throws IOException {
        this.timeSupplier = timeSupplier;
        this.metricsSocket = new ReconnectingSocket(hostname, port);
        this.histogramsSocket = new ReconnectingSocket(hostname, wavefrontHistogramPort);
        this.prependGroupName = prependGroupName;
        this.clear = clear;
    }

    private String getName(MetricName name) {
        if (this.prependGroupName && name.getGroup() != null && !name.getGroup().equals("")) {
            return name.getGroup() + "." + name.getName();
        }
        return name.getName();
    }

    private String tagsForMetricName(MetricName metricName) {
        if (metricName instanceof TaggedMetricName) {
            TaggedMetricName taggedMetricName = (TaggedMetricName)metricName;
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : taggedMetricName.getTags().entrySet()) {
                sb.append(" ").append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append("\"");
            }
            return sb.toString();
        }
        return "";
    }

    private void writeMetric(MetricName metricName, String nameSuffix, double value) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(this.getName(metricName));
        if (nameSuffix != null && !nameSuffix.equals("")) {
            sb.append(".").append(nameSuffix);
        }
        sb.append("\" ").append(value).append(this.tagsForMetricName(metricName));
        this.metricsSocket.write(sb.append("\n").toString());
    }

    private void writeMetered(MetricName name, Metered metered) throws Exception {
        for (Map.Entry entry : MetricsToTimeseries.explodeMetered((Metered)metered).entrySet()) {
            this.writeMetric(name, (String)entry.getKey(), (Double)entry.getValue());
        }
    }

    private void writeSummarizable(MetricName name, Summarizable summarizable) throws Exception {
        for (Map.Entry entry : MetricsToTimeseries.explodeSummarizable((Summarizable)summarizable).entrySet()) {
            this.writeMetric(name, (String)entry.getKey(), (Double)entry.getValue());
        }
    }

    private void writeSampling(MetricName name, Sampling sampling) throws Exception {
        for (Map.Entry entry : MetricsToTimeseries.explodeSampling((Sampling)sampling).entrySet()) {
            this.writeMetric(name, (String)entry.getKey(), (Double)entry.getValue());
        }
    }

    public void processMeter(MetricName name, Metered meter, Void context) throws Exception {
        this.writeMetered(name, meter);
    }

    public void processCounter(MetricName name, Counter counter, Void context) throws Exception {
        this.writeMetric(name, null, counter.count());
    }

    public void processHistogram(MetricName name, Histogram histogram, Void context) throws Exception {
        if (histogram instanceof WavefrontHistogram) {
            StringBuilder sb = new StringBuilder();
            sb.append("!M ").append(this.timeSupplier.get() / 1000L);
            WavefrontHistogram wavefrontHistogram = (WavefrontHistogram)histogram;
            for (WavefrontHistogram.MinuteBin minuteBin : wavefrontHistogram.bins(this.clear)) {
                sb.append(" #").append(minuteBin.getDist().size()).append(" ").append(minuteBin.getDist().quantile(0.5));
            }
            sb.append(" \"").append(this.getName(name)).append("\"").append(this.tagsForMetricName(name)).append("\n");
            this.histogramsSocket.write(sb.toString());
        } else {
            this.writeMetric(name, "count", histogram.count());
            this.writeSampling(name, (Sampling)histogram);
            this.writeSummarizable(name, (Summarizable)histogram);
            if (this.clear) {
                histogram.clear();
            }
        }
    }

    public void processTimer(MetricName name, Timer timer, Void context) throws Exception {
        MetricName rateName;
        MetricName samplingName;
        if (name instanceof TaggedMetricName) {
            TaggedMetricName taggedMetricName = (TaggedMetricName)name;
            samplingName = new TaggedMetricName(taggedMetricName.getGroup(), taggedMetricName.getName() + ".duration", taggedMetricName.getTags());
            rateName = new TaggedMetricName(taggedMetricName.getGroup(), taggedMetricName.getName() + ".rate", taggedMetricName.getTags());
        } else {
            samplingName = new MetricName(name.getGroup(), name.getType(), name.getName() + ".duration");
            rateName = new MetricName(name.getGroup(), name.getType(), name.getName() + ".rate");
        }
        this.writeSummarizable(samplingName, (Summarizable)timer);
        this.writeSampling(samplingName, (Sampling)timer);
        this.writeMetered(rateName, (Metered)timer);
        if (this.clear) {
            timer.clear();
        }
    }

    public void processGauge(MetricName name, Gauge<?> gauge, Void context) throws Exception {
        this.writeMetric(name, null, Double.valueOf(gauge.value().toString()));
    }

    public void flush() throws IOException {
        this.metricsSocket.flush();
        this.histogramsSocket.flush();
    }
}

