/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.integrations.metrics;

import com.google.common.base.Joiner;
import com.wavefront.common.TaggedMetricName;
import com.wavefront.integrations.metrics.WavefrontYammerMetricsReporter;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.WavefrontHistogram;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class Main {
    public static void main(String[] args) throws IOException, InterruptedException {
        System.out.println("Args: " + Joiner.on((String)", ").join((Object[])args));
        if (args.length != 2) {
            System.out.println("Usage: java -jar this.jar <metricsPort> <histogramsPort>");
            return;
        }
        int port = Integer.parseInt(args[0]);
        int histoPort = Integer.parseInt(args[1]);
        MetricsRegistry metricsRegistry = new MetricsRegistry();
        WavefrontYammerMetricsReporter wavefrontYammerMetricsReporter = new WavefrontYammerMetricsReporter(metricsRegistry, "wavefrontYammerMetrics", "localhost", port, histoPort, System::currentTimeMillis);
        wavefrontYammerMetricsReporter.start(5L, TimeUnit.SECONDS);
        Counter counter = metricsRegistry.newCounter((MetricName)new TaggedMetricName("group", "mycounter", new String[]{"tag1", "value1"}));
        Histogram histogram = metricsRegistry.newHistogram((MetricName)new TaggedMetricName("group2", "myhisto"), false);
        WavefrontHistogram wavefrontHistogram = WavefrontHistogram.get((MetricsRegistry)metricsRegistry, (MetricName)new TaggedMetricName("group", "mywavefronthisto", new String[]{"tag2", "value2"}));
        while (true) {
            counter.inc();
            histogram.update(counter.count());
            wavefrontHistogram.update(counter.count());
            Thread.sleep(1000L);
        }
    }
}

