/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.logging;

import com.wavefront.java_sdk.com.google.common.cache.Cache;
import com.wavefront.java_sdk.com.google.common.cache.CacheBuilder;
import com.wavefront.sdk.common.logging.DelegatingLogger;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class MessageSuppressingLogger
extends DelegatingLogger {
    private final Cache<String, Long> cache;
    private final long suppressMillis;

    public MessageSuppressingLogger(Logger delegate, long suppressTime, TimeUnit timeUnit) {
        super(delegate);
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(2L * suppressTime, timeUnit).build();
        this.suppressMillis = timeUnit.toMillis(suppressTime);
    }

    public void log(String messageKey, Level level, String message) {
        this.cache.asMap().compute(messageKey, (key, prevTime) -> this.logMessageAndComputeTimestamp(message, level, (Long)prevTime));
    }

    public void reset(String key) {
        this.cache.invalidate(key);
    }

    @Override
    public void log(Level level, String message) {
        this.cache.asMap().compute(message, (key, prevTime) -> this.logMessageAndComputeTimestamp(message, level, (Long)prevTime));
    }

    @Override
    void inferCaller(LogRecord logRecord) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        boolean lookingForLogger = true;
        for (StackTraceElement frame : stackTraceElements) {
            String cname = frame.getClassName();
            if (lookingForLogger) {
                if (!cname.endsWith("Logger")) continue;
                lookingForLogger = false;
                continue;
            }
            if (cname.endsWith("Logger") || cname.startsWith("java.lang.reflect.") || cname.startsWith("sun.reflect.") || cname.startsWith("com.wavefront.java_sdk.com.google.common.cache.LocalCache")) continue;
            logRecord.setSourceClassName(cname);
            logRecord.setSourceMethodName(frame.getMethodName());
            return;
        }
    }

    private Long logMessageAndComputeTimestamp(String message, Level level, Long prevTime) {
        long currentTime = System.currentTimeMillis();
        if (prevTime == null) {
            return currentTime;
        }
        if (currentTime - prevTime > this.suppressMillis) {
            this.log(new LogRecord(level, message));
            return currentTime;
        }
        return prevTime;
    }
}

