/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.metrics;

import com.wavefront.sdk.common.NamedThreadFactory;
import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.common.metrics.WavefrontSdkCounter;
import com.wavefront.sdk.common.metrics.WavefrontSdkGauge;
import com.wavefront.sdk.common.metrics.WavefrontSdkMetric;
import com.wavefront.sdk.entities.metrics.WavefrontMetricSender;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WavefrontSdkMetricsRegistry
implements Runnable,
Closeable {
    private static final Logger logger = Logger.getLogger(WavefrontSdkMetricsRegistry.class.getCanonicalName());
    private final WavefrontMetricSender wavefrontMetricSender;
    private final String source;
    private final Map<String, String> tags;
    private final String prefix;
    private final ConcurrentMap<String, WavefrontSdkMetric> metrics;
    private final ScheduledExecutorService scheduler;

    private WavefrontSdkMetricsRegistry(Builder builder) {
        this.wavefrontMetricSender = builder.wavefrontMetricSender;
        this.source = builder.source;
        this.tags = builder.tags;
        this.prefix = builder.prefix == null || builder.prefix.isEmpty() ? "" : builder.prefix + ".";
        this.metrics = new ConcurrentHashMap<String, WavefrontSdkMetric>();
        this.scheduler = Executors.newScheduledThreadPool(1, new NamedThreadFactory("sdk-metrics-registry"));
        this.scheduler.scheduleAtFixedRate(this, builder.reportingIntervalSeconds, builder.reportingIntervalSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        long timestamp = System.currentTimeMillis();
        for (Map.Entry entry : this.metrics.entrySet()) {
            String name = this.prefix + (String)entry.getKey();
            WavefrontSdkMetric metric = (WavefrontSdkMetric)entry.getValue();
            try {
                if (metric instanceof WavefrontSdkGauge) {
                    if (!(((WavefrontSdkGauge)metric).getValue() instanceof Number)) continue;
                    Number value = (Number)((WavefrontSdkGauge)metric).getValue();
                    this.wavefrontMetricSender.sendMetric(name, value.doubleValue(), timestamp, this.source, this.tags);
                    continue;
                }
                if (!(metric instanceof WavefrontSdkCounter)) continue;
                this.wavefrontMetricSender.sendMetric(name + ".count", ((WavefrontSdkCounter)metric).count(), timestamp, this.source, this.tags);
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "Unable to send internal SDK metric", e);
            }
        }
    }

    @Override
    public void close() {
        Utils.shutdownExecutorAndWait(this.scheduler);
    }

    public <T> WavefrontSdkGauge<T> newGauge(String name, Supplier<T> supplier) {
        return this.getOrAdd(name, supplier::get);
    }

    public WavefrontSdkCounter newCounter(String name) {
        return this.getOrAdd(name, new WavefrontSdkCounter());
    }

    private <T extends WavefrontSdkMetric> T getOrAdd(String name, T metric) {
        WavefrontSdkMetric existingMetric = (WavefrontSdkMetric)this.metrics.get(name);
        if (existingMetric == null) {
            existingMetric = this.metrics.putIfAbsent(name, metric);
            return (T)(existingMetric == null ? metric : existingMetric);
        }
        return (T)existingMetric;
    }

    public static class Builder {
        private final WavefrontMetricSender wavefrontMetricSender;
        private final Map<String, String> tags;
        private int reportingIntervalSeconds = 60;
        private String source;
        private String prefix;

        public Builder(WavefrontMetricSender wavefrontMetricSender) {
            this.wavefrontMetricSender = wavefrontMetricSender;
            this.tags = new HashMap<String, String>();
        }

        public Builder reportingIntervalSeconds(int reportingIntervalSeconds) {
            this.reportingIntervalSeconds = reportingIntervalSeconds;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.tags.putAll(tags);
            return this;
        }

        public Builder tag(String key, String value) {
            this.tags.put(key, value);
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public WavefrontSdkMetricsRegistry build() {
            return new WavefrontSdkMetricsRegistry(this);
        }
    }
}

