/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.internal_reporter_java.io.dropwizard.metrics5.jvm;

import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.Metric;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricName;
import com.wavefront.internal_reporter_java.io.dropwizard.metrics5.MetricSet;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;

public class ClassLoadingGaugeSet
implements MetricSet {
    private final ClassLoadingMXBean mxBean;

    public ClassLoadingGaugeSet() {
        this(ManagementFactory.getClassLoadingMXBean());
    }

    public ClassLoadingGaugeSet(ClassLoadingMXBean mxBean) {
        this.mxBean = mxBean;
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        HashMap<MetricName, Metric> gauges = new HashMap<MetricName, Metric>();
        gauges.put(MetricName.build("loaded"), this.mxBean::getTotalLoadedClassCount);
        gauges.put(MetricName.build("unloaded"), this.mxBean::getUnloadedClassCount);
        return gauges;
    }
}

