/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.permission.dialog;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.Fragment;
import com.watayouxiang.permission.R;
import com.watayouxiang.permission.dialog.AppSettingsDialogHolderActivity;

public class AppSettingsDialog
implements Parcelable {
    public static final int DEFAULT_SETTINGS_REQ_CODE = 16061;
    static final String EXTRA_APP_SETTINGS = "extra_app_settings";
    @StyleRes
    private final int mThemeResId;
    private final String mRationale;
    private final String mTitle;
    private final String mPositiveButtonText;
    private final String mNegativeButtonText;
    private final int mRequestCode;
    private final int mIntentFlags;
    private Object mActivityOrFragment;
    private Context mContext;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Parcelable.Creator<AppSettingsDialog> CREATOR = new Parcelable.Creator<AppSettingsDialog>(){

        public AppSettingsDialog createFromParcel(Parcel in) {
            return new AppSettingsDialog(in);
        }

        public AppSettingsDialog[] newArray(int size) {
            return new AppSettingsDialog[size];
        }
    };

    private AppSettingsDialog(@NonNull Object activityOrFragment, @StyleRes int themeResId, @Nullable String rationale, @Nullable String title, @Nullable String positiveButtonText, @Nullable String negativeButtonText, int requestCode, int intentFlags) {
        this.setActivityOrFragment(activityOrFragment);
        this.mThemeResId = themeResId;
        this.mRationale = rationale;
        this.mTitle = title;
        this.mPositiveButtonText = positiveButtonText;
        this.mNegativeButtonText = negativeButtonText;
        this.mRequestCode = requestCode;
        this.mIntentFlags = intentFlags;
    }

    static AppSettingsDialog fromIntent(Intent intent, Activity activity) {
        AppSettingsDialog dialog = (AppSettingsDialog)intent.getParcelableExtra(EXTRA_APP_SETTINGS);
        dialog.setActivityOrFragment(activity);
        return dialog;
    }

    private void setActivityOrFragment(Object activityOrFragment) {
        this.mActivityOrFragment = activityOrFragment;
        if (activityOrFragment instanceof Activity) {
            this.mContext = (Activity)activityOrFragment;
        } else if (activityOrFragment instanceof Fragment) {
            this.mContext = ((Fragment)activityOrFragment).getContext();
        } else {
            throw new IllegalStateException("Unknown object: " + activityOrFragment);
        }
    }

    private void startForResult(Intent intent) {
        if (this.mActivityOrFragment instanceof Activity) {
            ((Activity)this.mActivityOrFragment).startActivityForResult(intent, this.mRequestCode);
        } else if (this.mActivityOrFragment instanceof Fragment) {
            ((Fragment)this.mActivityOrFragment).startActivityForResult(intent, this.mRequestCode);
        }
    }

    public void show() {
        this.startForResult(AppSettingsDialogHolderActivity.createShowDialogIntent(this.mContext, this));
    }

    AlertDialog showDialog(DialogInterface.OnClickListener positiveListener, DialogInterface.OnClickListener negativeListener) {
        AlertDialog.Builder builder = this.mThemeResId != -1 ? new AlertDialog.Builder(this.mContext, this.mThemeResId) : new AlertDialog.Builder(this.mContext);
        if (this.mTitle != null) {
            builder.setTitle((CharSequence)this.mTitle);
        }
        return builder.setCancelable(false).setMessage((CharSequence)this.mRationale).setPositiveButton((CharSequence)this.mPositiveButtonText, positiveListener).setNegativeButton((CharSequence)this.mNegativeButtonText, negativeListener).show();
    }

    int getIntentFlags() {
        return this.mIntentFlags;
    }

    private AppSettingsDialog(Parcel in) {
        this.mThemeResId = in.readInt();
        this.mRationale = in.readString();
        this.mTitle = in.readString();
        this.mPositiveButtonText = in.readString();
        this.mNegativeButtonText = in.readString();
        this.mRequestCode = in.readInt();
        this.mIntentFlags = in.readInt();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mThemeResId);
        dest.writeString(this.mRationale);
        dest.writeString(this.mTitle);
        dest.writeString(this.mPositiveButtonText);
        dest.writeString(this.mNegativeButtonText);
        dest.writeInt(this.mRequestCode);
        dest.writeInt(this.mIntentFlags);
    }

    public static class Builder {
        private final Object mActivityOrFragment;
        private final Context mContext;
        @StyleRes
        private int mThemeResId = -1;
        private String mRationale;
        private String mTitle;
        private String mPositiveButtonText;
        private String mNegativeButtonText;
        private int mRequestCode = -1;
        private boolean mOpenInNewTask = false;

        public Builder(@NonNull Activity activity) {
            this.mActivityOrFragment = activity;
            this.mContext = activity;
        }

        public Builder(@NonNull Fragment fragment) {
            this.mActivityOrFragment = fragment;
            this.mContext = fragment.getContext();
        }

        @NonNull
        public Builder setThemeResId(@StyleRes int themeResId) {
            this.mThemeResId = themeResId;
            return this;
        }

        @NonNull
        public Builder setTitle(@Nullable String title) {
            this.mTitle = title;
            return this;
        }

        @NonNull
        public Builder setTitle(@StringRes int title) {
            this.mTitle = this.mContext.getString(title);
            return this;
        }

        @NonNull
        public Builder setRationale(@Nullable String rationale) {
            this.mRationale = rationale;
            return this;
        }

        @NonNull
        public Builder setRationale(@StringRes int rationale) {
            this.mRationale = this.mContext.getString(rationale);
            return this;
        }

        @NonNull
        public Builder setPositiveButton(@Nullable String text) {
            this.mPositiveButtonText = text;
            return this;
        }

        @NonNull
        public Builder setPositiveButton(@StringRes int textId) {
            this.mPositiveButtonText = this.mContext.getString(textId);
            return this;
        }

        @NonNull
        public Builder setNegativeButton(@Nullable String text) {
            this.mNegativeButtonText = text;
            return this;
        }

        @NonNull
        public Builder setNegativeButton(@StringRes int textId) {
            this.mNegativeButtonText = this.mContext.getString(textId);
            return this;
        }

        @NonNull
        public Builder setRequestCode(int requestCode) {
            this.mRequestCode = requestCode;
            return this;
        }

        @NonNull
        public Builder setOpenInNewTask(boolean openInNewTask) {
            this.mOpenInNewTask = openInNewTask;
            return this;
        }

        @NonNull
        public AppSettingsDialog build() {
            this.mRationale = TextUtils.isEmpty((CharSequence)this.mRationale) ? this.mContext.getString(R.string.rationale_ask_again) : this.mRationale;
            this.mPositiveButtonText = TextUtils.isEmpty((CharSequence)this.mPositiveButtonText) ? this.mContext.getString(17039370) : this.mPositiveButtonText;
            this.mNegativeButtonText = TextUtils.isEmpty((CharSequence)this.mNegativeButtonText) ? this.mContext.getString(0x1040000) : this.mNegativeButtonText;
            this.mRequestCode = this.mRequestCode > 0 ? this.mRequestCode : 16061;
            int intentFlags = 0;
            if (this.mOpenInNewTask) {
                intentFlags |= 0x10000000;
            }
            return new AppSettingsDialog(this.mActivityOrFragment, this.mThemeResId, this.mRationale, this.mTitle, this.mPositiveButtonText, this.mNegativeButtonText, this.mRequestCode, intentFlags);
        }
    }
}

