/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.permission;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import java.util.ArrayList;
import java.util.List;

public class TaoPermissionUtils {
    @NonNull
    public static List<String> requestPermissions(@NonNull Fragment fragment, int requestCode, @Nullable List<String> permissions) {
        Context context = fragment.getContext();
        if (context == null) {
            throw new IllegalStateException("Fragment " + fragment + " not attached to Activity");
        }
        List<String> deniedPermissions = TaoPermissionUtils.filterDeniedPermissions(context, permissions);
        if (!deniedPermissions.isEmpty()) {
            fragment.requestPermissions(deniedPermissions.toArray(new String[0]), requestCode);
        }
        return deniedPermissions;
    }

    @NonNull
    public static List<String> requestPermissions(@NonNull Activity activity, int requestCode, @Nullable List<String> permissions) {
        List<String> deniedPermissions = TaoPermissionUtils.filterDeniedPermissions((Context)activity, permissions);
        if (!deniedPermissions.isEmpty()) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])deniedPermissions.toArray(new String[0]), (int)requestCode);
        }
        return deniedPermissions;
    }

    @NonNull
    public static List<String> filterDeniedPermissions(@NonNull Context context, @Nullable List<String> permissions) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        if (permissions != null) {
            for (String permission : permissions) {
                if (!TaoPermissionUtils.isDeniedPermission(context, permission)) continue;
                deniedPermissions.add(permission);
            }
        }
        return deniedPermissions;
    }

    public static boolean shouldShowRequestPermissionRationale(@NonNull Activity activity, @NonNull String permission) {
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission);
    }

    public static boolean isDeniedPermission(@NonNull Context context, @NonNull String permission) {
        return TaoPermissionUtils.isPermissionVersion() && ContextCompat.checkSelfPermission((Context)context, (String)permission) == -1;
    }

    public static boolean isPermissionVersion() {
        return Build.VERSION.SDK_INT >= 23;
    }
}

