/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.permission.helper;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.watayouxiang.permission.TaoPermissionUtils;
import com.watayouxiang.permission.helper.TaoPermissionListener;
import java.util.ArrayList;
import java.util.List;

abstract class PermissionHelper<T> {
    private static final int DEFAULT_PERMISSION_REQ_CODE = 13031;
    private TaoPermissionListener mPermissionListener;
    private int mRequestCode;
    private T mHost;

    public PermissionHelper(T host) {
        this.mHost = host;
    }

    T getHost() {
        return this.mHost;
    }

    public void requestPermissions(@Nullable List<String> permissions) {
        this.requestPermissions(permissions, 13031);
    }

    public void setPermissionListener(@Nullable TaoPermissionListener listener) {
        this.mPermissionListener = listener;
    }

    public void requestPermissions(@Nullable List<String> permissions, int requestCode) {
        this.mRequestCode = requestCode;
        if (this.startRequestPermissions(requestCode, permissions).isEmpty() && this.mPermissionListener != null) {
            this.mPermissionListener.onGranted();
        }
    }

    @NonNull
    abstract List<String> startRequestPermissions(int var1, List<String> var2);

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == this.mRequestCode) {
            ArrayList<String> deniedPermissions = new ArrayList<String>();
            ArrayList<String> disabledPermissions = new ArrayList<String>();
            if (permissions.length == grantResults.length && TaoPermissionUtils.isPermissionVersion()) {
                for (int i = 0; i < grantResults.length; ++i) {
                    if (grantResults[i] != -1) continue;
                    if (!TaoPermissionUtils.shouldShowRequestPermissionRationale(this.getActivity(), permissions[i])) {
                        disabledPermissions.add(permissions[i]);
                        continue;
                    }
                    deniedPermissions.add(permissions[i]);
                }
            }
            if (deniedPermissions.isEmpty() && disabledPermissions.isEmpty()) {
                if (this.mPermissionListener != null) {
                    this.mPermissionListener.onGranted();
                }
            } else if (!disabledPermissions.isEmpty()) {
                if (this.mPermissionListener != null) {
                    this.mPermissionListener.onDisabled(disabledPermissions, deniedPermissions);
                }
            } else if (this.mPermissionListener != null) {
                this.mPermissionListener.onDenied(deniedPermissions);
            }
        }
    }

    abstract Activity getActivity();
}

