/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.permission;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.watayouxiang.permission.PermissionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

abstract class PermissionHelper<T> {
    private T mHost;
    private final int DEFAULT_PERMISSION_REQ_CODE = 13031;
    private String[] mPermissions;
    private PermissionListener mPermissionListener;

    PermissionHelper(T host) {
        this.mHost = host;
    }

    T getHost() {
        return this.mHost;
    }

    private boolean somePermissionPermanentlyDenied(List<String> deniedPermissionList) {
        Iterator<String> iterator;
        if (this.needPermissionVersion() && (iterator = deniedPermissionList.iterator()).hasNext()) {
            String deniedPermission = iterator.next();
            return !ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivity(), (String)deniedPermission);
        }
        return false;
    }

    private List<String> getDeniedPermissions(String[] permissions) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        if (this.needPermissionVersion()) {
            for (String permission : permissions) {
                if (ContextCompat.checkSelfPermission((Context)this.getContext(), (String)permission) == 0) continue;
                deniedPermissions.add(permission);
            }
        }
        return deniedPermissions;
    }

    boolean needPermissionVersion() {
        return Build.VERSION.SDK_INT >= 23;
    }

    protected abstract Context getContext();

    protected abstract Activity getActivity();

    protected abstract void startRequestPermissions(List<String> var1, int var2);

    protected abstract void showAppSettingDialog(List<String> var1, int var2);

    public void requestPermissions(String[] permissions, PermissionListener listener) {
        List<String> deniedPermissions = this.getDeniedPermissions(permissions);
        if (!deniedPermissions.isEmpty()) {
            this.mPermissions = permissions;
            this.mPermissionListener = listener;
            this.startRequestPermissions(deniedPermissions, 13031);
        } else {
            listener.onGranted();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 13031) {
            ArrayList<String> deniedPermissions = new ArrayList<String>();
            for (int i = 0; i < grantResults.length; ++i) {
                if (grantResults[i] == 0) continue;
                deniedPermissions.add(permissions[i]);
            }
            if (deniedPermissions.isEmpty()) {
                this.mPermissionListener.onGranted();
            } else if (this.somePermissionPermanentlyDenied(deniedPermissions)) {
                this.showAppSettingDialog(deniedPermissions, 16061);
            } else {
                this.mPermissionListener.onDenied(deniedPermissions);
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 16061) {
            List<String> deniedPermissions = this.getDeniedPermissions(this.mPermissions);
            if (deniedPermissions.isEmpty()) {
                this.mPermissionListener.onGranted();
            } else {
                this.mPermissionListener.onDenied(deniedPermissions);
            }
        }
    }
}

