/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.demoshell.webview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.watayouxiang.demoshell.webview.TListener;
import com.watayouxiang.demoshell.webview.TWebChromeClient;
import com.watayouxiang.demoshell.webview.TWebViewClient;
import java.util.ArrayList;
import java.util.List;

public class TWebView
extends WebView {
    private List<TListener> mListeners = new ArrayList<TListener>();

    public TWebView(Context context) {
        this(context, null);
    }

    public TWebView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setDefaultWebSettings();
        this.setWebChromeClient(new TWebChromeClient(this.mListeners));
        this.setWebViewClient(new TWebViewClient(this.mListeners));
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void setDefaultWebSettings() {
        WebSettings ws = this.getSettings();
        ws.setJavaScriptEnabled(true);
        ws.setLoadWithOverviewMode(false);
        ws.setUseWideViewPort(true);
        ws.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        this.setInitialScale(100);
        ws.setTextZoom(100);
        ws.setSupportZoom(true);
        ws.setBuiltInZoomControls(true);
        ws.setDisplayZoomControls(false);
        ws.setAppCacheEnabled(true);
        ws.setCacheMode(-1);
        ws.setSaveFormData(true);
        ws.setDomStorageEnabled(true);
        ws.setDatabaseEnabled(true);
        ws.setAllowFileAccess(true);
        ws.setLoadsImagesAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            ws.setMixedContentMode(0);
        }
    }

    public void setListener(TListener listener) {
        if (listener != null && !this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void releaseRes() {
        ViewGroup parent = (ViewGroup)this.getParent();
        if (parent != null) {
            parent.removeView((View)this);
        }
        this.removeAllViews();
        this.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
        this.stopLoading();
        this.setWebChromeClient(null);
        this.setWebViewClient(null);
        this.destroy();
        if (this.mListeners != null) {
            this.mListeners.clear();
            this.mListeners = null;
        }
    }
}

