/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.demoshell.webview;

import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import androidx.appcompat.app.AlertDialog;
import com.watayouxiang.demoshell.webview.TListener;
import java.util.List;

class TWebChromeClient
extends WebChromeClient {
    private List<TListener> mListeners;

    TWebChromeClient(List<TListener> listener) {
        this.mListeners = listener;
    }

    public void onReceivedTitle(WebView view, String title) {
        super.onReceivedTitle(view, title);
        for (TListener listener : this.mListeners) {
            listener.onReceivedTitle(view, title);
        }
    }

    public boolean onJsAlert(WebView webView, String url, String message, JsResult result) {
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(webView.getContext());
        dialogBuilder.setMessage((CharSequence)message).setPositiveButton((CharSequence)"\u786e\u5b9a", null);
        dialogBuilder.setCancelable(true);
        dialogBuilder.create().show();
        result.confirm();
        return true;
    }

    public void onProgressChanged(WebView view, int newProgress) {
        if (newProgress >= 0 && newProgress <= 100) {
            for (TListener listener : this.mListeners) {
                listener.onProgressChanged(view, newProgress);
            }
        }
    }
}

