/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.demoshell.tool;

import com.watayouxiang.demoshell.tool.MdFile;
import com.watayouxiang.demoshell.tool.MdFileData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class MdFileTool {
    public void start(MdFileData data) {
        File inFile = new File(data.getInDirPath());
        LinkedList<MdFile> files = new LinkedList<MdFile>();
        this.getFiles(inFile, 0, data.getProjectUrl(), files);
        List<String> lines = this.getLines(files);
        File outFile = this.saveFile(lines, data.getOutFilePath());
        for (String line : lines) {
            System.out.println(line);
        }
        System.out.println("\u6587\u4ef6\u8f93\u51fa\u8def\u5f84\uff1a" + outFile.getAbsoluteFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File saveFile(List<String> mdLinkList, String outFilePath) {
        File outFile = new File(outFilePath);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(outFile));
            for (String mdLink : mdLinkList) {
                writer.write(mdLink);
                writer.newLine();
                writer.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return outFile;
    }

    private List<String> getLines(List<MdFile> inFileList) {
        if (inFileList == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> mdLinkList = new ArrayList<String>(inFileList.size());
        for (MdFile mdFile : inFileList) {
            String link = mdFile.getLink();
            mdLinkList.add(link);
        }
        return mdLinkList;
    }

    private void getFiles(File file, int level, String projectUrl, List<MdFile> fileList) {
        fileList.add(new MdFile(file, level, projectUrl));
        ++level;
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (File f : files) {
            this.getFiles(f, level, projectUrl, fileList);
        }
    }
}

