/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.demoshell.tool;

import java.io.File;

class MdFile {
    private final File file;
    private final int level;
    private final String projectUrl;

    MdFile(File file, int level, String projectUrl) {
        this.file = file;
        this.level = level;
        this.projectUrl = projectUrl;
    }

    private String getTabs() {
        StringBuilder builder = new StringBuilder();
        for (int x = 0; x < this.level; ++x) {
            builder.append("\t");
        }
        return builder.toString();
    }

    private String getRelativePath() {
        String absolutePath = this.file.getAbsolutePath();
        String projectPath = System.getProperty("user.dir");
        if (projectPath == null) {
            throw new NullPointerException("projectPath is null");
        }
        String relativePath = absolutePath.substring(projectPath.length());
        relativePath = relativePath.replace(File.separator, "/");
        return relativePath;
    }

    String getLink() {
        return this.getTabs() + "- [" + this.file.getName() + "](" + this.projectUrl + this.getRelativePath() + ")";
    }
}

