/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.demoshell;

import android.content.Context;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;

class UIUtils {
    UIUtils() {
    }

    static void setPadding(View view, int padding) {
        UIUtils.setPadding(view, new Rect(padding, padding, padding, padding));
    }

    static void setPadding(View view, Rect padding) {
        int paddingLeft = UIUtils.dp2px(view.getContext(), padding.left);
        int paddingTop = UIUtils.dp2px(view.getContext(), padding.top);
        int paddingRight = UIUtils.dp2px(view.getContext(), padding.right);
        int paddingBottom = UIUtils.dp2px(view.getContext(), padding.bottom);
        view.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    static void setMargin(View view, int margin) {
        UIUtils.setMargin(view, new Rect(margin, margin, margin, margin));
    }

    static void setMargin(View view, Rect margin) {
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)lp;
            int marginLeft = UIUtils.dp2px(view.getContext(), margin.left);
            int marginTop = UIUtils.dp2px(view.getContext(), margin.top);
            int marginRight = UIUtils.dp2px(view.getContext(), margin.right);
            int marginBottom = UIUtils.dp2px(view.getContext(), margin.bottom);
            params.setMargins(marginLeft, marginTop, marginRight, marginBottom);
        }
    }

    static int dp2px(Context context, int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }
}

