/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.demoshell;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.watayouxiang.demoshell.ListBean;
import com.watayouxiang.demoshell.R;
import com.watayouxiang.demoshell.UIUtils;
import java.util.List;

class ListAdapter
extends RecyclerView.Adapter<ListHolder> {
    private final List<ListBean> mData;

    ListAdapter(List<ListBean> date) {
        this.mData = date;
    }

    @NonNull
    public ListHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        LayoutInflater inflater = LayoutInflater.from((Context)viewGroup.getContext());
        View view = inflater.inflate(R.layout.list_item, viewGroup, false);
        return new ListHolder(view);
    }

    public void onBindViewHolder(@NonNull ListHolder holder, int i) {
        if (i < this.getItemCount() - 1) {
            UIUtils.setMargin((View)holder.tv_name, new Rect(5, 10, 5, 0));
        } else {
            UIUtils.setMargin((View)holder.tv_name, new Rect(5, 10, 5, 10));
        }
        ListBean bean = this.mData.get(i);
        if (bean.listener != null) {
            this.setItemStyle(holder.tv_name);
        } else {
            this.setSectionStyle(holder.tv_name);
        }
        holder.tv_name.setText((CharSequence)String.valueOf(bean.name));
        holder.tv_name.setOnClickListener(bean.listener);
    }

    private void setSectionStyle(TextView tv_name) {
        tv_name.setGravity(17);
        tv_name.setTextSize(2, 14.0f);
        tv_name.setTextColor(Color.parseColor((String)"#000000"));
        tv_name.setBackgroundColor(0);
        tv_name.setEnabled(false);
        UIUtils.setPadding((View)tv_name, 0);
    }

    private void setItemStyle(TextView tv_name) {
        tv_name.setGravity(0x800003);
        tv_name.setTextSize(2, 12.0f);
        tv_name.setTextColor(Color.parseColor((String)"#1A1A1A"));
        tv_name.setBackgroundColor(Color.parseColor((String)"#AACCCCCC"));
        tv_name.setEnabled(true);
        UIUtils.setPadding((View)tv_name, 10);
    }

    public int getItemCount() {
        return this.mData.size();
    }

    class ListHolder
    extends RecyclerView.ViewHolder {
        final TextView tv_name;

        ListHolder(View view) {
            super(view);
            this.tv_name = (TextView)view.findViewById(R.id.tv_name);
        }
    }
}

