/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.demoshell;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.view.MenuItem;
import android.webkit.WebView;
import android.widget.ProgressBar;
import com.watayouxiang.demoshell.BaseActivity;
import com.watayouxiang.demoshell.R;
import com.watayouxiang.demoshell.webview.TListener;
import com.watayouxiang.demoshell.webview.TWebView;

public class BrowserActivity
extends BaseActivity {
    private TWebView mTWebView;
    private ProgressBar mProgressBar;

    @Override
    protected int getRootViewId() {
        return R.layout.activity_browser;
    }

    @Override
    protected CharSequence getPageTitle() {
        return "\u52a0\u8f7d\u4e2d...";
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        super.initView(savedInstanceState);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.mTWebView = (TWebView)this.findViewById(R.id.browser);
    }

    @Override
    protected void initData(Bundle savedInstanceState) {
        super.initData(savedInstanceState);
        this.mTWebView.getSettings().setTextZoom(50);
        this.setWebListener(this.mTWebView, this.mProgressBar);
        String url = this.getIntent().getStringExtra("URL");
        if (url != null) {
            this.mTWebView.loadUrl(url);
        }
    }

    private void setWebListener(TWebView webBrowser, final ProgressBar progressBar) {
        webBrowser.setListener(new TListener(){

            @Override
            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                progressBar.setVisibility(0);
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                progressBar.setVisibility(8);
            }

            @Override
            public void onReceivedTitle(WebView view, String title) {
                BrowserActivity.this.setTitle(title);
            }

            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                progressBar.setProgress(newProgress);
            }
        });
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            if (this.mTWebView.canGoBack()) {
                this.mTWebView.goBack();
            } else {
                this.finish();
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mTWebView != null) {
            this.mTWebView.releaseRes();
            this.mTWebView = null;
        }
        if (this.mProgressBar != null) {
            this.mProgressBar = null;
        }
    }
}

