/*
 * Decompiled with CFR 0.152.
 */
package com.wassilak.cache_service.entity;

import com.wassilak.cache_service.entity.Entity;
import com.wassilak.cache_service.entity.EntityException;
import java.util.Date;

final class EntityImpl<T>
implements Entity<T> {
    private static final long serialVersionUID = -5465289859131162503L;
    private final T object;
    private final Date timeStamp;
    private final Long timeToLive;

    EntityImpl(T object, Long timeToLive) throws EntityException {
        if (object == null) {
            throw new EntityException("object must be provided");
        }
        if (timeToLive == null) {
            throw new EntityException("timeToLive must be provided");
        }
        if (timeToLive < Entity.MIN_TTL) {
            throw new EntityException("timeToLive must be at least " + Entity.MIN_TTL);
        }
        if (timeToLive > Entity.MAX_TTL) {
            throw new EntityException("timeToLive must be at most " + Entity.MAX_TTL);
        }
        this.object = object;
        this.timeToLive = timeToLive;
        this.timeStamp = new Date();
    }

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public Date getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public Long getTimeToLive() {
        return this.timeToLive;
    }
}

