/*
 * Decompiled with CFR 0.152.
 */
package com.wassilak.cache_service.cache;

import com.wassilak.cache_service.cache.Cache;
import com.wassilak.cache_service.entity.Entity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class CacheImpl<K, V>
implements Cache<K, V> {
    private static final long serialVersionUID = 8363605847331221757L;
    private final Map<K, List<Entity<V>>> map = new HashMap<K, List<Entity<V>>>();

    CacheImpl() {
    }

    @Override
    public synchronized List<Entity<V>> getEntities(K key) {
        this.cleanCache();
        return this.map.get(key);
    }

    @Override
    public synchronized void addEntity(K key, Entity<V> entity) {
        this.cleanCache();
        List<Entity<V>> entityList = this.map.get(key);
        if (entityList == null) {
            entityList = new ArrayList<Entity<V>>();
        }
        entityList.add(entity);
        this.map.put(key, entityList);
    }

    @Override
    public synchronized void removeEntity(K key, Entity<V> entity) {
        this.cleanCache();
        this.remove(key, entity);
    }

    void cleanCache() {
        HashMap<K, ArrayList<Entity<V>>> removalMap = new HashMap<K, ArrayList<Entity<V>>>();
        for (Map.Entry<K, List<Entity<V>>> entry : this.map.entrySet()) {
            for (Entity<V> e : entry.getValue()) {
                if (System.currentTimeMillis() - e.getTimeStamp().getTime() <= e.getTimeToLive()) continue;
                ArrayList<Entity<V>> currentList = (ArrayList<Entity<V>>)removalMap.get(entry.getKey());
                if (currentList == null) {
                    currentList = new ArrayList<Entity<V>>();
                }
                currentList.add(e);
                removalMap.put(entry.getKey(), currentList);
            }
        }
        for (Map.Entry<K, List<Entity<V>>> entry : removalMap.entrySet()) {
            for (Entity<V> e : entry.getValue()) {
                this.remove(entry.getKey(), e);
            }
        }
    }

    void remove(K key, Entity<V> entity) {
        List<Entity<V>> entityList = this.map.get(key);
        while (entityList.contains(entity)) {
            entityList.remove(entity);
        }
        if (entityList.isEmpty()) {
            this.map.remove(key);
        } else {
            this.map.put(key, entityList);
        }
    }
}

