package com.wassilak.cache_service.entity;

/**
 * The EntityFactory class gives users the ability to create Entity objects.
 * <p>
 * Copyright (C) 2014 John Wassilak (john@wassilak.com)
 * <p>
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * <p>
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * <p>
 * You should have received a copy of the GNU General Public License along with this program. If not, see
 * http://www.gnu.org/licenses/.
 */
public final class EntityFactory {

    /**
     * The EntityFactory constructor ensures that the EntityFactory class cannot be instantiated. It is package private
     * to allow testing.
     */
    EntityFactory() {
        throw new IllegalStateException("This class should not be instantiated.");
    }

    /**
     * The createEntity method creates an Entity object with the given parameters.
     * 
     * @param <T>
     *            The type of object that the Entity should contain.
     * @param object
     *            The object represented by this Entity.
     * @param timeToLive
     *            The time that the Entity can live before it should be removed from the cache, in milliseconds.
     * @return An Entity object created with the given parameters.
     * @throws EntityException
     *             If the entity is being created with invalid parameters.
     */
    public static <T> Entity<T> createEntity(T object, Long timeToLive) throws EntityException {
        return new EntityImpl<T>(object, timeToLive);
    }
}
